/* Rebuild the FunctionTable of the Pascal source for a HAL .DLL */
PARSE ARG PAS /* PAScal file */
NEWPAS="NEW.PAS" /* Temporary file */
DO WHILE CHARS(PAS)>0
	L=LINEIN(PAS)
	CALL LINEOUT NEWPAS,L
	IF L="{$LINKER" THEN LEAVE
END
IF CHARS(PAS)=0 THEN EXIT
DO WHILE CHARS(PAS)>0
	L=LINEIN(PAS)
	CALL LINEOUT NEWPAS,L
	IF L="EXPORTS" THEN LEAVE
END
IF CHARS(PAS)=0 THEN EXIT
I=0
DO WHILE CHARS(PAS)>0
	L=LINEIN(PAS)
	CALL LINEOUT NEWPAS,L
	IF L="}" THEN LEAVE
	IF POS("LOADFUNCS",TRANSLATE(L))>0 THEN ITERATE /* Don't put the ...LoadFuncs function in FunctionTable */
	I=I+1
	PARSE VALUE L WITH "="FUNC
	FUNC.I=STRIP(FUNC)
END
FUNC.0=I
DO WHILE CHARS(PAS)>0
	L=LINEIN(PAS)
	/* DON'T write to NEWPAS */
	IF RIGHT(L,2)=");" THEN LEAVE
END
CALL LINEOUT NEWPAS,""
CALL LINEOUT NEWPAS,"CONST FUNCTIONTABLE : ARRAY[ 0.."I-1" ] OF PCHAR ="
CALL LINEOUT NEWPAS,"("
DO I=1 TO FUNC.0-1
	CALL LINEOUT NEWPAS,"    '"FUNC.I"',"
END
CALL LINEOUT NEWPAS,"    '"FUNC.I"'"
CALL LINEOUT NEWPAS,");"
DO WHILE CHARS(PAS)>0
	CALL LINEOUT NEWPAS,LINEIN(PAS) /* Copy rest of file */
END
CALL LINEOUT NEWPAS
CALL STREAM PAS,"C","CLOSE"
"@DEL "PAS" >NUL 2>NUL"
"@REN "NEWPAS FILESPEC("N",PAS)
