{**********************************************************}
{*                                                        *}
{* The following routines are inline assembly, they are   *}
{* thus processor and bitness specific. Replace them      *}
{* with your own if you want to port the TrueType Engine  *}


{**********************************************************}
{* Calc A*B/C with Intermediate 64 bit precision          *}

function MulDiv( A, B, C : Int32 ): Int32; assembler;
asm
  db $66; mov ax,[A].word
  db $66; imul [B].word
  db $66; idiv [C].word
  db $66; mov dx, ax
  db $66; sar dx, 16
end;

function MulDiv_Round( A, B, C : Int32 ): Int32; assembler;
asm
  db $66; push cx
  db $66; mov ax,[A].word
  db $66; imul [B].word
  db $66; mov cx, [C].word
  db $66; sar cx, 1
  db $66; add ax, cx
  db $66; adc dx, 0
  db 0, 0
  db $66; sar cx, 31
  db $66; add dx, cx
  db $66; idiv [C].word
  db $66; mov dx, ax
  db $66; sar dx, 16
  db $66; pop cx
end;



{**********************************************************}
{* 64 Bit Addition                                        *}

procedure Add64( var X, Y, Z : Int64 ); assembler;
asm
  les si,[X]

  mov ax,es:[ si ].word
  mov dx,es:[si+2].word
  mov bx,es:[si+4].word
  mov cx,es:[si+6].word

  les si,[Y]
  add ax,es:[ si ].word
  adc dx,es:[si+2].word
  adc bx,es:[si+4].word
  adc cx,es:[si+6].word

  les si,[Z]
  mov es:[ si ].word,ax
  mov es:[si+2].word,dx
  mov es:[si+4].word,bx
  mov es:[si+6].word,cx
end;


{**********************************************************}
{* 64 Bit Substraction                                    *}

procedure Sub64( var X, Y, Z : Int64 ); assembler;
asm
  les si,[X]

  mov ax,es:[ si ].word
  mov dx,es:[si+2].word
  mov bx,es:[si+4].word
  mov cx,es:[si+6].word

  les si,[Y]
  sub ax,es:[ si ].word
  sbb dx,es:[si+2].word
  sbb bx,es:[si+4].word
  sbb cx,es:[si+6].word

  les si,[Z]
  mov es:[ si ].word,ax
  mov es:[si+2].word,dx
  mov es:[si+4].word,bx
  mov es:[si+6].word,cx
end;


{**********************************************************}
{* Multiply two Int32 to an Int64                         *}

procedure MulTo64( X, Y : Int32; var Z : Int64 ); assembler;
asm
  les si,[Z]
  db $66; mov ax,[X].word
  db $66; imul [Y].word
  db $66; mov es:[si],ax
  db $66; mov es:[si+4],dx
end;


{**********************************************************}
{* Divide an Int64 by an Int32                            *}

function Div64by32( var X : Int64; Y : Int32 ) : Int32; assembler;
asm
  les si,[X]

  db $66; mov ax,es:[si]
  db $66; mov dx,es:[si+4]
  db $66; idiv [Y].word

  db $66; mov dx, ax
  db $66; sar dx, 16
end;

procedure DivMod64by32( var X : Int64; Y : Int32; var Q, R : Int32 ); assembler;
asm
  les si,[X]

  db $66; mov ax,es:[si]
  db $66; mov dx,es:[si+4]
  db $66; idiv [Y].word

  les si, [Q]
  db $66; mov es:[si], ax

  les si, [R]
  db $66; mov es:[si], dx
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order64( var Z : Int64 ) : integer; assembler;
asm
  les si, [Z]
  db $66; mov ax, es:[ si ]
  db $66; mov dx, es:[si+4]

  db $66; test dx, dx
  jz @1

  db $66, $0F, $BD, $C2;    { bsr eax, edx }
  add ax, 32

  jmp @2

 @1:
  db $66, $0F, $BD, $C0     { bsr eax, eax }

 @2:
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order32( Z : Int32 ) : integer; assembler;
asm
  db $66; mov ax, [Z].word
  db $66, $0F, $BD, $C0   { bsr ax, ax }
end;



{* End of processor specific routines                     *}
{*                                                        *}
{**********************************************************}
