(**********************************************************)
(*                                                        *)
(* The following routines are inline assembly, they are   *)
(* thus processor and bitness specific. Replace them      *)
(* with your own if you want to port the TrueType Engine  *)

{ $DEFINE INLINE_ASSEMBLY}

(**********************************************************)
(* Calc A*B/C with Intermediate 64 bit precision          *)

function MulDiv( A, B, C : longint ) : longint;
const
  Bit31 = 1 shl 31;
label
  OverFlow;
var
  r, q, aq, ar, s1, s2 : longint;
  i                    : Integer;
begin
  s1 := a and Bit31; if s1 <> 0 then a := -a;
  s2 := b and Bit31; if s2 <> 0 then b := -b;

  s1 := s1 xor s2;

  s2 := c and Bit31; if s2 <> 0 then c := -c;

  s1 := s1 xor s2;

  if s1 <> 0 then
    s2 := $80000001
  else
    s2 := $7FFFFFFF;

  if c = 0 then goto OverFlow;

  { A Useful shortcut : most of the calculations fall here }

  if (a or b) shr 16 = 0 then
  begin
    q := a*b div c;
    if s1 <> 0 then q := -q;
    MulDiv := q;
    exit;
  end;

  aq := a div c;
  ar := a mod c;

  r := 0;
  q := 0;

  for i := 1 to 32 do
  begin
    r := r shl 1;
    q := q shl 1;

    { if q < 0 then goto OverFlow; }

    if b < 0 then
    begin
      inc( r, ar );
      inc( q, aq );

      { if q < 0 then goto OverFlow; }
    end;

    b := b shl 1;

    while (r-c) >= 0 do
    begin
      dec( r, c );
      inc( q );
     {  if q < 0 then goto OverFlow; }
    end;

  end;

  if s1 <> 0 then q := -q;
  MulDiv := q;
  exit;

OverFlow:
  MulDiv := s2;

end;

function MulDiv_Round( A, B, C : longint ) : longint;
const
  Bit31 = 1 shl 31;
label
  OverFlow;
var
  r, q, aq, ar, s1, s2 : longint;
  i                    : Integer;
begin
  s1 := a and Bit31; if s1 <> 0 then a := -a;
  s2 := b and Bit31; if s2 <> 0 then b := -b;

  s1 := s1 xor s2;

  s2 := c and Bit31; if s2 <> 0 then c := -c;

  s1 := s1 xor s2;

  if s1 <> 0 then
    s2 := $80000001
  else
    s2 := $7FFFFFFF;

  if c = 0 then goto OverFlow;

  { A Useful shortcut : most of the calculations fall here }

  if (a or b) shr 16 = 0 then
  begin
    q := (a*b + c div 2) div c;
    if s1 <> 0 then q := -q;
    MulDiv_Round := q;
    exit;
  end;

  (* no rounding for greatest values *)

  aq := a div c;
  ar := a mod c;

  r := 0;
  q := 0;

  for i := 1 to 32 do
  begin
    r := r shl 1;
    q := q shl 1;

    { if q < 0 then goto OverFlow; }

    if b < 0 then
    begin
      inc( r, ar );
      inc( q, aq );

      { if q < 0 then goto OverFlow; }
    end;

    b := b shl 1;

    while (r-c) >= 0 do
    begin
      dec( r, c );
      inc( q );
     {  if q < 0 then goto OverFlow; }
    end;

  end;

  if s1 <> 0 then q := -q;
  MulDiv_Round := q;
  exit;

OverFlow:
  MulDiv_Round := s2;

end;


{$IFDEF OS2}

(**********************************************************)
(* 64 Bit Addition                                        *)

procedure Add64( var X, Y, Z : Int64 ); assembler; {$USES ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]

  mov ebx,[Y].dword
  add eax,[ebx]
  adc edx,[ebx+4]

  mov ebx,[Z].dword
  mov [ebx],eax
  mov [ebx+4],edx
end;


(**********************************************************)
(* 64 Bit Substraction                                    *)

procedure Sub64( var X, Y, Z : Int64 ); assembler; {$USES eax, ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]

  mov ebx,[Y].dword
  sub eax,[ebx]
  sbb edx,[ebx+4]

  mov ebx,[Z].dword
  mov [ebx],eax
  mov [ebx+4],edx
end;


(**********************************************************)
(* Multiply two Int32 to an Int64                         *)

procedure MulTo64( X, Y : Int32; var Z : Int64 ); assembler; {$USES ebx, edx }
asm
  mov ebx,[Z].dword
  mov eax,[X]
  imul [Y]
  mov [ebx],eax
  mov [ebx+4],edx
end;


(**********************************************************)
(* Divide an Int64 by an Int32                            *)

function Div64by32( var X : Int64; Y : Int32 ) : Int32; assembler;
         {$USES ebx, edx}
asm
  mov ebx, [X].dword
  mov eax, [ebx]
  mov edx, [ebx+4]
  idiv [Y]
end;

procedure DivMod64by32( var X : Int64; Y : Int32; var Q, R : Int32 );
          assembler; {$USES ebx, edx}
asm
  mov ebx, [X].dword
  mov eax, [ebx]
  mov edx, [ebx+4]
  idiv [Y]
  mov ebx, [Q].dword
  mov [ebx], eax
  mov ebx, [R].dword
  mov [ebx], edx
end;


{$ELSE}

{**********************************************************}
{* 64 Bit Addition                                        *}

procedure Add64( var X, Y, Z : Int64 ); assembler;
asm
  les si,[X]

  mov ax,es:[ si ].word
  mov dx,es:[si+2].word
  mov bx,es:[si+4].word
  mov cx,es:[si+6].word

  les si,[Y]
  add ax,es:[ si ].word
  adc dx,es:[si+2].word
  adc bx,es:[si+4].word
  adc cx,es:[si+6].word

  les si,[Z]
  mov es:[ si ].word,ax
  mov es:[si+2].word,dx
  mov es:[si+4].word,bx
  mov es:[si+6].word,cx
end;


{**********************************************************}
{* 64 Bit Substraction                                    *}

procedure Sub64( var X, Y, Z : Int64 ); assembler;
asm
  les si,[X]

  mov ax,es:[ si ].word
  mov dx,es:[si+2].word
  mov bx,es:[si+4].word
  mov cx,es:[si+6].word

  les si,[Y]
  sub ax,es:[ si ].word
  sbb dx,es:[si+2].word
  sbb bx,es:[si+4].word
  sbb cx,es:[si+6].word

  les si,[Z]
  mov es:[ si ].word,ax
  mov es:[si+2].word,dx
  mov es:[si+4].word,bx
  mov es:[si+6].word,cx
end;


{**********************************************************}
{* Multiply two Int32 to an Int64                         *}

procedure MulTo64( X, Y : Int32; var Z : Int64 ); assembler;
asm
  les si,[Z]
  db $66; mov ax,[X].word
  db $66; imul [Y].word
  db $66; mov es:[si],ax
  db $66; mov es:[si+4],dx
end;


{**********************************************************}
{* Divide an Int64 by an Int32                            *}

function Div64by32( var X : Int64; Y : Int32 ) : Int32; assembler;
asm
  les si,[X]

  db $66; mov ax,es:[si]
  db $66; mov dx,es:[si+4]
  db $66; idiv [Y].word

  db $66; mov dx, ax
  db $66; sar dx, 16
end;

procedure DivMod64by32( var X : Int64; Y : Int32; var Q, R : Int32 ); assembler;
asm
  les si,[X]

  db $66; mov ax,es:[si]
  db $66; mov dx,es:[si+4]
  db $66; idiv [Y].word

  les si, [Q]
  db $66; mov es:[si], ax

  les si, [R]
  db $66; mov es:[si], dx
end;


{$ENDIF}


(**********************************************************)
(* MSB index ( return -1 for 0 )                          *)

function Order64( var Z : Int64 ) : integer;
begin
  if Z.Hi <> 0 then Order64 := 32 + Order32( Z.Hi )
               else Order64 := Order32( Z.Lo );
end;


(**********************************************************)
(* MSB index ( return -1 for 0 )                          *)

function Order32( Z : Int32 ) : integer;
var b : integer;
begin

  b := 0;
  while Z <> 0 do begin Z := Z shr 1; inc( b ); end;

  Order32 := b-1;

end;

