/*******************************************************************
 *
 *  ttmemory.h                                               1.1
 *
 *    Memory management component (specification).
 *
 *  Copyright 1996, 1997 by
 *  David Turner, Robert Wilhelm, and Werner Lemberg.
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute 
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 *  NOTE:
 *
 *    The FreeType library uses a simple and fast growing heap
 *    known as a 'Font Pool' to manage all its data. This version
 *    does not manage multiple pools (a feature that may reveal
 *    useful for a FreeType based font server to be able to manage
 *    several open fonts).
 *
 ******************************************************************/

#ifndef TTMEMORY_H
#define TTMEMORY_H

#include "tttypes.h"

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct  _TMarkRecord
  {
    unsigned long  Magic;
    long           Top;
  } TMarkRecord;

  typedef TMarkRecord*  PMarkRecord;

#define ALLOC(_pointer_,_size_)  Alloc( _size_, (void**)&(_pointer_) )

#define ALLOC_ARRAY(_pointer_,_count_,_type_) \
          Alloc( (_count_)*sizeof(_type_), (void**)&(_pointer_) )

  extern Bool  Font_Pool_Allocated;

  long  Mem_Allocated( void );
  long  Mem_Free( void );

  void  Init_FontPool( void*  Buff, long  Size );

  Bool  Alloc( long  Size, void**  P );

  void  Mark( PMarkRecord  M );
  Bool  Release( PMarkRecord  M );

#ifdef __cplusplus
}
#endif

#endif /* TTMEMORY_H */


/* End */
