/*******************************************************************
 *
 *  ttcalc.h
 *
 *    Arithmetic Computations (specification).
 *
 *  Copyright 1996, 1997 by
 *  David Turner, Robert Wilhelm, and Werner Lemberg.
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute 
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 ******************************************************************/

#ifndef TTCALC_H
#define TTCALC_H

#include "tttypes.h"

  /* IntN types :                                                       */
  /*                                                                    */
  /*   Used to guarantee the size of some specific integers.            */
  /*                                                                    */
  /*  Of course, they are equivalent to Short, UShort, Long, etc.       */
  /*  but parts of this unit could be used by different programs.       */
  /*                                                                    */

  typedef signed short    Int16;
  typedef signed long     Int32;

  typedef unsigned short  Word16;
  typedef unsigned long   Word32;

  struct _Int64
  {
    Word32  lo;
    Word32  hi;
  };
  typedef struct _Int64   Int64;


#define INT_TO_F26DOT6( x )    ( (Int)(x) << 6  )
#define INT_TO_F2DOT14( x )    ( (Int)(x) << 14 )
#define INT_TO_FIXED( x )      ( (Int)(x) << 16 )
#define F2DOT14_TO_FIXED( x )  ( (Int)(x) << 2  )
#define FLOAT_TO_FIXED( x )    ( (Int)(x * 65536.0) )

#define ROUND_F26DOT6( x )     ( ( ( (Int)(x) + ( (x) > -32 ? 32 : -32 ) ) \
                                 >> 6 ) << 6 )

#ifdef __cplusplus
extern "C" {
#endif

  Int32  MulDiv( Int32  A, Int32  B, Int32  C );
  Int32  MulDiv_Round( Int32  a, Int32  b, Int32  c );

  void  Add64( Int64*  x, Int64*  y, Int64*  z );
  void  Sub64( Int64*  x, Int64*  y, Int64*  z );

  void  MulTo64( Int32  x, Int32  y, Int64*  z );

  Int32  Div64by32( Int64*  x, Int32  y );

  Int  Order64( Int64*  z );
  Int  Order32( Int32   z );

  Int32  Sqrt32( Int32   l );
  Int32  Sqrt64( Int64*  l );

#define MUL_FIXED( a, b )  MulDiv_Round( (Int32)(a), (Int32)(b), 1 << 16 )

#ifdef __cplusplus
}
#endif

#endif


/* End */
