#define INCL_BASE
#define INCL_DOS
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <i86.h>
#include <os2.h>
#include "joyos2.h"
#include "ejoyos2.h"

#define AXIS_PRINT(axis_flag,axisname,axisvalue,chk_bit1,chk_bit2) \
    if (caps.flags & axis_flag) \
    { \
    printf("%s = %4ld ", axisname, axisvalue); \
    if (info.axis & chk_bit1) \
    { \
    printf("%20s\n", "AXIS_UP"); \
    } else if (info.axis & chk_bit2) \
    printf("%20s\n", "AXIS_DOWN"); \
    else \
    printf("%20s\n", ""); \
    }

HFILE hGame;
BOOL  enchanced_joystick_interface=FALSE;
GAME_EXT_INFO info;
GAME_EXT_CAPS caps;
GAME_EXT_CALIB calib;
GAME_EXT_DEADZONE deadzone;
GAME_EXT_VERSION version;

void game_open()
{
    ULONG  action;
    APIRET rc;

    rc = DosOpen(
                 GAMEPDDNAME,
                 &hGame,
                 &action,
                 0,
                 FILE_READONLY,
                 FILE_OPEN,
                 OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE,
                 NULL);

    if (rc != 0)
    {
        printf("no joystick found on system!\n");
        exit(1);
    }
}

void game_close()
{
    DosClose(hGame);
}

void game_check_version()
{
    ULONG version;
    ULONG version_len;
    APIRET rc;

    version_len = sizeof(ULONG);

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_GET_VERSION,
                     NULL, 0, NULL,
                     &version, version_len, &version_len);

    enchanced_joystick_interface=FALSE;

    printf("Joystick driver interface version %d.%d\n", version>>4, version & 0x0F);

    if (version >= 0x21)
    {
        enchanced_joystick_interface=TRUE;
    }
}

void game_ext_get_caps()
{
    ULONG param;
    ULONG param_len;
    ULONG caps_len;
    APIRET rc;

    caps_len = sizeof(GAME_EXT_CAPS);
    param_len = sizeof(ULONG);

    param = 0; // read first joystick capabilities

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_GET_CAPS,
                     &param, param_len, &param_len,
                     &caps, caps_len, &caps_len);
}

void game_ext_get_info()
{
    ULONG info_len;
    long joy_nro;
    ULONG param_len;
    APIRET rc;

    info_len = sizeof(GAME_EXT_INFO);
    param_len = sizeof(long);

    joy_nro = 0; // read first joystick values

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_GET_INFO,
                     &joy_nro, param_len, &param_len,
                     &info, info_len, &info_len);
}

void game_ext_get_calib()
{
    ULONG calib_len;
    long param;
    ULONG param_len;
    APIRET rc;

    param=0;
    param_len = sizeof(long);

    calib_len = sizeof(GAME_EXT_CALIB);


    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_GET_CALIB,
                     &param, param_len, &param_len,
                     &calib, calib_len, &calib_len);
}

void game_ext_get_deadzone()
{
    ULONG deadzone_len;
    long param;
    ULONG param_len;
    APIRET rc;

    param=0;
    param_len = sizeof(long);

    deadzone_len = sizeof(GAME_EXT_DEADZONE);


    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_GET_DEADZONE,
                     &param, param_len, &param_len,
                     &deadzone, deadzone_len, &deadzone_len);
}

void get_driver_version()
{
    ULONG version_len;
    APIRET rc;

    version_len = sizeof(GAME_EXT_VERSION);
    memset(&version, 0, sizeof(GAME_EXT_VERSION));

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_GET_DRIVER_VERSION,
                     NULL, 0, NULL,
                     &version, version_len, &version_len);

}

void main()
{
    int i;
    ULONG buttons;
    ULONG last_axis=-1, last_buttons=-1;

    printf("This app is designed to read statuses using enchanced joystickinterface v2.1+\n\n");

    game_open();
    game_check_version();
    if (!enchanced_joystick_interface)
    {
        printf("Joystick driver doesn't support enchanced joystick i.face\n");
        game_close();
        exit(0);
    }

    printf("Joystick driver supports enchanced joystick i.face\n");

    get_driver_version();
    game_ext_get_caps();

    if (caps.flags & JOYCAPS_NOTCONNECTED)
    {
        printf("Adapter name : %s\n", caps.product);
        printf("joystick is not connected!\n");
        return;
    }

    printf("\033[0m\033[2J\033[1;1H");
    printf("Press any key to exit...\n");
    printf("Adapter name : %s\n", caps.product);
    printf("Driver: %s\n", version.driver_name);
    printf("Author: %s\n", version.author_name);
    printf("Version string: %s\n", version.version_str);
    printf("Version: %08lx\n", version.version);
    printf("Buttons# : %d   Axis# : %d\n", caps.nro_of_buttons, caps.nro_of_axis);


    while(!kbhit())
    {
        game_ext_get_info();

        buttons=info.buttons;

        if (last_buttons!=buttons)
        {
            printf("\033[8;1H");
            last_buttons=buttons;

            for (i=0; i<caps.nro_of_buttons; i++)
            {
                printf("%d ", buttons & 0x01);
                buttons>>=1;
            }
        }

//        if (last_axis!=info.axis)
        {
            printf("\033[9;1H");

            last_axis=info.axis;

            AXIS_PRINT(JOYCAPS_HASX, "x", info.xpos, JOY_X_UP, JOY_X_DOWN);
            AXIS_PRINT(JOYCAPS_HASY, "y", info.ypos, JOY_Y_UP, JOY_Y_DOWN);
            AXIS_PRINT(JOYCAPS_HASZ, "z", info.zpos, JOY_Z_UP, JOY_Z_DOWN);
            AXIS_PRINT(JOYCAPS_HASR, "r", info.rpos, JOY_R_UP, JOY_R_DOWN);
            AXIS_PRINT(JOYCAPS_HASU, "u", info.upos, JOY_U_UP, JOY_U_DOWN);
            AXIS_PRINT(JOYCAPS_HASV, "v", info.vpos, JOY_V_UP, JOY_V_DOWN);
        }
        fflush(stdout);
    }
    game_ext_get_calib();
    game_ext_get_deadzone();

    printf("\033[16;1H");
    printf("calibration:\n");
    printf("\033[17;1Hx-axis min=%d center=%d max=%d", calib.xmin, calib.xcent, calib.xmax);
    printf("\033[17;40Hy-axis min=%d center=%d max=%d", calib.ymin, calib.ycent, calib.ymax);
    printf("\033[18;1Hz-axis min=%d center=%d max=%d", calib.zmin, calib.zcent, calib.zmax);
    printf("\033[18;40Hr-axis min=%d center=%d max=%d", calib.rmin, calib.rcent, calib.rmax);
    printf("\033[19;1Hu-axis min=%d center=%d max=%d", calib.umin, calib.ucent, calib.umax);
    printf("\033[19;40Hv-axis min=%d center=%d max=%d", calib.vmin, calib.vcent, calib.vmax);

    printf("\033[20;1H");
    printf("deadzones:\n");
    printf("\033[21;1Hx-axis upper=%d lower=%d\n", deadzone.x_dzone_lower, deadzone.x_dzone_upper);
    printf("\033[21;40Hy-axis upper=%d lower=%d\n", deadzone.y_dzone_lower, deadzone.y_dzone_upper);
    printf("\033[22;1Hz-axis upper=%d lower=%d\n", deadzone.z_dzone_lower, deadzone.z_dzone_upper);
    printf("\033[22;40Hr-axis upper=%d lower=%d\n", deadzone.r_dzone_lower, deadzone.r_dzone_upper);
    printf("\033[23;1Hu-axis upper=%d lower=%d\n", deadzone.u_dzone_lower, deadzone.u_dzone_upper);
    printf("\033[23;40Hv-axis upper=%d lower=%d\n", deadzone.v_dzone_lower, deadzone.v_dzone_upper);
    printf("\033[24;1H");
    game_close();
}
