/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.io.*;

public interface HDatabaseIO
{
   public final static int PAGE_SIZE = 1024;

   public HDataNode findNode(HDataNode parent, String name) throws IOException;
   public short childCount(HDataNode parent) throws IOException;
   public HDataNode read(HDataNode parent, int index) throws IOException;
   public boolean remove(HDataNode aNode) throws IOException;
   public boolean update(HDataNode aNode, HDataNode updatedNode) throws IOException;
   public boolean move(HDataNode parent, HDataNode aNode) throws IOException;
   public boolean write(HDataNode parent, HDataNode aNode) throws IOException;
   public boolean retrieveBlob(HDataNode aNode) throws IOException;
   public HDataNode readParent(HDataNode aChild) throws IOException;
}

