/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.io.*;

public class FilenameMatch implements FilenameFilter
{


String mask;

public FilenameMatch(String mask)
{
   this.mask = mask;
}

// case insensitive wildcard match.  only works on one filename, not a path
// hasDot indicates if original name contains at least one dot
protected boolean recursive_match(String mask, String name, boolean hasDot)
{
   int i = 0, j = 0;

   // we only check if j is out of range if the mask is not a wildcard
   while(i < mask.length() )     /* && j < name.length()) */
   {
      switch(mask.charAt(i))
      {
         // match any character
         case '?':
            i++; j++;
            break;

         // match implicit dot at the end of filename
         case '.':
            if(j >= name.length())
               return false;

            i++;
            if(name.charAt(j) == '.')
               j++;
            else if(hasDot || ++j < name.length())
               return false;
            break;

         // match buncha characters.  uses recursion
         case '*':
            i++;

            if(i >= mask.length() && j < name.length())
               return true;

            // make * match 0 characters
            if(j >= name.length())
               break;

            boolean rc = recursive_match(mask.substring(i), name.substring(j), hasDot);
            while(!rc)
            {
               j++;

               if(j >= name.length())
                  return false;

               rc = recursive_match(mask.substring(i), name.substring(j), hasDot);
            }
            return true;

         default:
            if(j >= name.length())
               return false;

            if(Character.toLowerCase(mask.charAt(i)) !=
               Character.toLowerCase(name.charAt(j)))
               return false;
            i++; j++;
            break;
      }
   }

   // name must be completely scanned to match
   if(i >= mask.length() && j >= name.length())
      return true;
   else
      return false;
}

public boolean match(String name)
{
   return recursive_match(mask, name, name.indexOf('.') > -1);
}

public boolean accept(File dir, String name)
{
   return match(name);
}


public static void main(String[] args)
{
   FilenameMatch fnmatch = new FilenameMatch(args[0]);
   File dir = new File(".");

   String[] files = dir.list(fnmatch);

   for(int i = 0; i < files.length; i++)
      System.out.println(files[i]);
}


}
