/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class DeleteConfirmDialog extends JDialog implements ActionListener
{
   JTextArea message = new JTextArea("Are you sure you want to delete the following\nfiles/directories and all they contain?");
   JList   objectList;
   JScrollPane scrollList;
   JButton ok = new JButton("Ok"),
           cancel = new JButton("Cancel");

   JPanel buttonPane = new JPanel();
   boolean rc = false;
   JFrame mainFrame;

public DeleteConfirmDialog(JFrame frame, Object[] objects)
{
   super(frame,"Delete Confirmation",true);
   mainFrame = frame;

   message.setOpaque(false);
   message.setEditable(false);

   objectList = new JList(objects);
   scrollList = new JScrollPane(objectList);

   buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
   buttonPane.add(ok);
   buttonPane.add(Box.createRigidArea(new Dimension(5,0)));
   buttonPane.add(cancel);
   ok.addActionListener(this);
   cancel.addActionListener(this);
   ok.setMnemonic(KeyEvent.VK_O);
   cancel.setMnemonic(KeyEvent.VK_C);

   JPanel dialogPane = new JPanel();
   dialogPane.setLayout(new BoxLayout(dialogPane, BoxLayout.Y_AXIS));
   dialogPane.add(message);
   dialogPane.add(Box.createRigidArea(new Dimension(0,5)));
   dialogPane.add(scrollList);
   dialogPane.add(Box.createRigidArea(new Dimension(0,5)));
   dialogPane.add(buttonPane);

   dialogPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));

   addWindowListener(new WindowAdapter()
   {
      public void windowClosing(WindowEvent e)
      {
         mainFrame.requestFocus();
      }
      boolean focusSet = false;
      public void windowActivated(WindowEvent e)
      {
         if(!focusSet)
           cancel.requestFocus();
         focusSet = true;
      }
   });

   this.getContentPane().add(dialogPane);
   this.pack();
   setLocationRelativeTo(frame);
}

public void actionPerformed(ActionEvent e)
{
   String command = e.getActionCommand();

   rc = command == "Ok";

   this.dispose();
   mainFrame.requestFocus();
}

public static boolean showDialog(JFrame frame, Object[] objects)
{
   DeleteConfirmDialog dialog = new DeleteConfirmDialog(frame,objects);
   dialog.setVisible(true);
   return dialog.rc;
}


}
