/*
 * Decompiled with CFR 0.152.
 */
package WatermarkHelper;

import WatermarkHelper.WaterMarkHelper;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class WriteToPDF {
    public void writeToPDF(String outputPath, ArrayList results, float[] dimentions, WaterMarkHelper helper) {
        try {
            Rectangle pageSize = new Rectangle(dimentions[1] + 20.0f, dimentions[0] + 20.0f);
            Document document = new Document(pageSize);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outputPath));
            document.open();
            for (BufferedImage result : results) {
                com.lowagie.text.Image img = com.lowagie.text.Image.getInstance((Image)result, null);
                if (img == null) continue;
                img.scalePercent(95.0f);
                img.setAlignment(1);
                document.add((Element)img);
                document.newPage();
            }
            document.addSubject(helper.getProperty("constants.metaTag.Comments"));
            document.addKeywords("Hitesh S J Sathawane Watermarker");
            document.addCreator("Hitesh S J Sathawane Watermarker");
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

