/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.crw;

import it.tidalwave.imageio.crw.CRWMetadata;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.CurveOperation;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CRWCurveOperation
extends CurveOperation {
    private static final String CLASS = CRWCurveOperation.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    @Nonnull
    protected int[] getBlackLevel(@Nonnull PipelineArtifact artifact) {
        logger.fine("getBlackLevel(%s)", artifact);
        WritableRaster raster = artifact.getImage().getRaster();
        CRWMetadata metadata = (CRWMetadata)artifact.getRAWMetadata();
        int yMin = metadata.getSensorTopBorder();
        int yMax = metadata.getSensorBottomBorder();
        int xMin = 2;
        int xMax = metadata.getSensorLeftBorder() - 13;
        logger.finer(">>>> computing black level from (%d; %d) - (%d; %d)...", 2, xMax, yMin, yMax);
        double[] dark = new double[2];
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = 2; x <= xMax; ++x) {
                int s1 = raster.getSample(x, y, 0);
                int s2 = raster.getSample(x, y, 1);
                int s3 = raster.getSample(x, y, 2);
                int n = x & 1;
                dark[n] = dark[n] + (double)(s1 + s2 + s3);
            }
        }
        logger.finer(">>>> dark: %s", Arrays.toString(dark));
        int sampleCount = (yMax - yMin + 1) * (xMax - 2 + 1) / 2;
        int black = (int)((dark[0] + dark[1]) / (double)(2 * sampleCount));
        return new int[]{black, black, black};
    }

    @Nonnegative
    protected double getWhiteLevel(@Nonnull PipelineArtifact artifact) {
        logger.fine("getWhiteLevel(%s)", artifact);
        return 4095.0;
    }
}

