/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor;

import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.rawprocessor.Operation;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.util.Logger;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class OperationSupport
implements Operation {
    public static final String CLASS = OperationSupport.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final Map<String, Properties> PROPERTY_MAP = new HashMap<String, Properties>();
    @Nonnull
    private final Set<Source.Type> imageTypes;

    @Nonnull
    protected static Logger getLogger(@Nonnull Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public OperationSupport(Source.Type ... imageType) {
        if (imageType.length == 0) {
            System.err.println("SEVERE: invalid operation: " + this.getClass());
            throw new IllegalArgumentException("You must specify at least one imageType - " + this.getClass());
        }
        this.imageTypes = new HashSet<Source.Type>(Arrays.asList(imageType));
    }

    public boolean supportsType(@Nonnull Source.Type imageType) {
        return this.imageTypes.contains((Object)imageType);
    }

    public void init(@Nonnull PipelineArtifact artifact) throws Exception {
    }

    public void processMetadata(PipelineArtifact artifact) throws Exception {
    }

    @Nonnull
    protected static Properties getProperties(@Nonnull Class clazz) {
        String name = clazz.getName();
        int i = name.lastIndexOf(46);
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        return OperationSupport.getProperties(clazz, name + ".properties");
    }

    @Nonnull
    private static Properties getProperties(@Nonnull Class clazz, @Nonnull String resourceName) {
        String key = clazz + ":" + resourceName;
        Properties properties = PROPERTY_MAP.get(key);
        if (properties == null) {
            InputStream[] is = OperationSupport.getResourceInputStream(clazz, resourceName);
            properties = new Properties();
            if (is != null) {
                for (int i = 0; i < is.length; ++i) {
                    try {
                        properties.load(is[i]);
                        is[i].close();
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                PROPERTY_MAP.put(key, properties);
            }
        }
        return properties;
    }

    public static InputStream[] getResourceInputStream(@Nonnull Class clazz, @Nonnull String resourceName) {
        ArrayList<InputStream> temp = new ArrayList<InputStream>();
        while (clazz != null) {
            String string = "/" + clazz.getPackage().getName().replace('.', '/') + "/" + resourceName;
            InputStream is = clazz.getResourceAsStream(string);
            if (is != null) {
                logger.fine(">>>> getResourceInputStream() from %s", string);
                temp.add(is);
            }
            clazz = clazz.getSuperclass();
        }
        return temp.toArray(new InputStream[0]);
    }

    @Nonnull
    public String toString() {
        return "[" + this.getClass().getSimpleName().replaceAll(".*\\.", "") + "]";
    }

    protected static String toString(int[] array, int radix) {
        StringBuilder buffer = new StringBuilder("");
        for (int i = 0; i < array.length; ++i) {
            buffer.append(Integer.toString(array[i], radix));
            if (i >= array.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    protected static void logImage(@Nonnull Logger logger, @Nonnull String prefix, @Nonnull RenderedImage image) {
        if (image == null) {
            logger.fine("%s.image:       null", prefix);
        } else {
            ColorModel colorModel = image.getColorModel();
            logger.fine("%s.size:        %d x %d", prefix, image.getWidth(), image.getHeight());
            logger.fine("%s.class:       %s", prefix, image.getClass().getName());
            logger.fine("%s.sampleModel: %s", prefix, OperationSupport.toString(image.getSampleModel()));
            logger.fine("%s.colorModel:  %s : %s", prefix, colorModel.getClass().getName(), colorModel);
            logger.fine("%s.colorSpace:  %s", prefix, OperationSupport.toString(colorModel.getColorSpace()));
        }
    }

    private static String toString(SampleModel sampleModel) {
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            return OperationSupport.toString((SinglePixelPackedSampleModel)sampleModel);
        }
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            return OperationSupport.toString((PixelInterleavedSampleModel)sampleModel);
        }
        return sampleModel.toString();
    }

    private static String toString(ColorSpace colorSpace) {
        if (colorSpace instanceof ICC_ColorSpace) {
            return OperationSupport.toString((ICC_ColorSpace)colorSpace);
        }
        return colorSpace.toString();
    }

    private static String toString(ICC_ColorSpace colorSpace) {
        StringBuilder buffer = new StringBuilder("");
        buffer.append(colorSpace.getClass().getName());
        buffer.append("[type: ");
        buffer.append(colorSpace.getType());
        buffer.append(", profile name: ");
        buffer.append(OperationSupport.getICCProfileName(colorSpace.getProfile()));
        buffer.append("]");
        return buffer.toString();
    }

    private static String toString(SinglePixelPackedSampleModel sampleModel) {
        StringBuilder buffer = new StringBuilder("");
        buffer.append(sampleModel.getClass().getName());
        buffer.append("[width: ");
        buffer.append(sampleModel.getWidth());
        buffer.append(", height: ");
        buffer.append(sampleModel.getHeight());
        buffer.append(", numBands: ");
        buffer.append(sampleModel.getNumBands());
        buffer.append(", dataType: ");
        buffer.append(sampleModel.getDataType());
        buffer.append(", scanlineStride: ");
        buffer.append(sampleModel.getScanlineStride());
        buffer.append(", transferType: ");
        buffer.append(sampleModel.getTransferType());
        buffer.append(", numDataElements: ");
        buffer.append(sampleModel.getNumDataElements());
        buffer.append(", bitMasks: ");
        buffer.append(OperationSupport.toString(sampleModel.getBitMasks(), 16));
        buffer.append(", bitOffsets: ");
        buffer.append(OperationSupport.toString(sampleModel.getBitOffsets(), 10));
        buffer.append("]");
        return buffer.toString();
    }

    private static String toString(PixelInterleavedSampleModel sampleModel) {
        StringBuilder buffer = new StringBuilder("");
        buffer.append(sampleModel.getClass().getName());
        buffer.append("[width: ");
        buffer.append(sampleModel.getWidth());
        buffer.append(", height: ");
        buffer.append(sampleModel.getHeight());
        buffer.append(", numBands: ");
        buffer.append(sampleModel.getNumBands());
        buffer.append(", dataType: ");
        buffer.append(sampleModel.getDataType());
        buffer.append(", scanlineStride: ");
        buffer.append(sampleModel.getScanlineStride());
        buffer.append(", transferType: ");
        buffer.append(sampleModel.getTransferType());
        buffer.append(", numDataElements: ");
        buffer.append(sampleModel.getNumDataElements());
        buffer.append(", bandOffsets: ");
        buffer.append(OperationSupport.toString(sampleModel.getBandOffsets(), 10));
        buffer.append(", bankIndices: ");
        buffer.append(OperationSupport.toString(sampleModel.getBankIndices(), 10));
        buffer.append("]");
        return buffer.toString();
    }

    @Nonnegative
    protected int normalizedAngle(int angle) {
        while (angle < 0) {
            angle += 360;
        }
        return angle % 360;
    }

    protected static ICC_Profile getICCProfile(RenderedImage image) {
        ColorSpace colorSpace = image.getColorModel().getColorSpace();
        if (colorSpace instanceof ICC_ColorSpace) {
            ICC_ColorSpace iccColorSpace = (ICC_ColorSpace)colorSpace;
            return iccColorSpace.getProfile();
        }
        return null;
    }

    protected static String getICCProfileName(ICC_Profile profile) {
        if (profile == null) {
            return null;
        }
        byte[] xx = profile.getData(1684370275);
        int offset = 12;
        int count = 1;
        while (xx[offset + count] != 0) {
            ++count;
        }
        return new String(xx, 0, offset, count);
    }
}

