/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.raw.TagRegistry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.stream.ImageInputStream;

public abstract class AbstractTag
implements Serializable {
    private static final long serialVersionUID = 2694868438676854749L;
    private static final int MAX_TRAILING_VALUES = 20;
    private static final int MAX_LEADING_VALUES = 40;
    protected transient TagRegistry registry;
    private final String registryName;
    protected int code;
    protected int type;
    protected int valuesCount;
    protected byte[] undefinedValue;
    protected int[] intValue;
    protected TagRational[] rationalValue;
    protected float[] floatValue;
    protected String asciiValue;

    public AbstractTag(@Nonnull TagRegistry registry, int code) {
        this.registry = registry;
        this.code = code;
        this.registryName = registry.getName();
    }

    public int getCode() {
        return this.code;
    }

    public int getType() {
        return this.type;
    }

    public int getValuesCount() {
        return this.valuesCount;
    }

    @CheckForNull
    public Object getValue() {
        if (this.undefinedValue != null) {
            return this.undefinedValue;
        }
        if (this.intValue != null) {
            Object object;
            if (this.intValue.length > 1) {
                object = this.intValue;
            } else {
                Integer n;
                object = n;
                n = new Integer(this.intValue[0]);
            }
            return object;
        }
        if (this.rationalValue != null) {
            return this.rationalValue.length > 1 ? this.rationalValue : this.rationalValue[0];
        }
        if (this.asciiValue != null) {
            return this.asciiValue;
        }
        return null;
    }

    @CheckForNull
    public byte[] getByteValues() {
        if (this.undefinedValue == null && this.intValue != null && this.intValue.length <= 4) {
            this.undefinedValue = new byte[this.intValue.length];
            for (int i = 0; i < this.undefinedValue.length; ++i) {
                this.undefinedValue[i] = (byte)this.intValue[i];
            }
        }
        return this.undefinedValue;
    }

    @CheckForNull
    public int[] getIntValues() {
        return this.intValue;
    }

    @CheckForNull
    public float[] getFloatValues() {
        return this.floatValue;
    }

    @CheckForNull
    public TagRational[] getRationalValues() {
        return this.rationalValue;
    }

    @CheckForNull
    public String getASCIIValue() {
        return this.asciiValue;
    }

    @Nonnull
    protected int[] readIntValues(@Nonnull ImageInputStream iis, long valueOffset, @Nonnegative int valuesCount) throws IOException {
        int[] buffer = new int[valuesCount];
        iis.mark();
        iis.seek(valueOffset);
        for (int i = 0; i < valuesCount; ++i) {
            buffer[i] = iis.readInt();
        }
        iis.reset();
        return buffer;
    }

    @Nonnull
    protected int[] readShortValues(@Nonnull ImageInputStream iis, long valueOffset, @Nonnegative int valuesCount) throws IOException {
        int[] buffer = new int[valuesCount];
        iis.mark();
        iis.seek(valueOffset);
        for (int i = 0; i < valuesCount; ++i) {
            buffer[i] = iis.readShort() & 0xFFFF;
        }
        iis.reset();
        return buffer;
    }

    @Nonnull
    protected int[] readByteValues(@Nonnull ImageInputStream iis, long valueOffset, @Nonnegative int valuesCount) throws IOException {
        int[] buffer = new int[valuesCount];
        iis.mark();
        iis.seek(valueOffset);
        for (int i = 0; i < valuesCount; ++i) {
            buffer[i] = iis.readByte();
        }
        iis.reset();
        return buffer;
    }

    protected void appendValues(@Nonnull StringBuilder buffer) {
        if (this.undefinedValue != null) {
            for (int j = 0; j < this.undefinedValue.length; ++j) {
                if (j > 0) {
                    buffer.append(",");
                }
                if (j > 40 && this.undefinedValue.length - 20 > j) {
                    buffer.append(" ... ,");
                    j = this.undefinedValue.length - 20;
                }
                buffer.append(Integer.toHexString(this.undefinedValue[j] & 0xFF));
            }
        } else if (this.intValue != null) {
            for (int j = 0; j < this.intValue.length; ++j) {
                if (j > 0) {
                    buffer.append(",");
                }
                if (j > 40 && this.intValue.length - 20 > j) {
                    buffer.append(" ... ,");
                    j = this.intValue.length - 20;
                }
                buffer.append(this.intValue[j]);
            }
        } else if (this.rationalValue != null) {
            for (int j = 0; j < this.rationalValue.length; ++j) {
                if (j > 0) {
                    buffer.append(",");
                }
                if (j > 40 && this.rationalValue.length - 20 > j) {
                    buffer.append(" ... ,");
                    j = this.rationalValue.length - 20;
                }
                buffer.append(this.rationalValue[j]);
            }
        } else if (this.asciiValue != null) {
            buffer.append(this.asciiValue);
        } else {
            buffer.append("????");
        }
    }

    private void readObject(@Nonnull ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.registry = TagRegistry.getRegistry(this.registryName);
    }
}

