/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.orf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Packed12RasterReader;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class SPRasterReader
extends Packed12RasterReader {
    private static final String CLASS = SPRasterReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private int height;

    protected void loadUncompressedRaster(@Nonnull RAWImageInputStream iis, @Nonnull WritableRaster raster, @Nonnull RAWImageReaderSupport ir) throws IOException {
        logger.fine("loadUncompressedRaster(%s, %s, %s)", iis, raster, ir);
        this.height = raster.getHeight();
        super.loadUncompressedRaster(iis, raster, ir);
    }

    @Nonnegative
    protected int getRow(@Nonnegative int interlacedRow, @Nonnegative int height) {
        return interlacedRow * 2 - (interlacedRow <= height / 2 ? 0 : height / 2 * 2 + 1);
    }

    protected void endOfRow(@Nonnegative int y, @Nonnull RAWImageInputStream iis) throws IOException {
        if (y == this.height / 2) {
            long offset = iis.getStreamPosition() + 1023L & 0xFFFFFFFFFFFFFC00L;
            logger.finest(">>>> at row %d seeking to %d - current position %d", y, offset, iis.getStreamPosition());
            iis.seek(offset);
        }
    }

    @Nonnull
    public String toString() {
        return String.format("SPRasterReader@%x", System.identityHashCode(this));
    }
}

