/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.makernote;

import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.TagRegistry;
import it.tidalwave.imageio.tiff.IFDSupport;

public class LeicaMakerNoteSupport
extends IFDSupport {
    private static final long serialVersionUID = 2517342348960118907L;
    public static final TagRegistry REGISTRY = TagRegistry.getRegistry("Leica");
    public static final Object COMPRESSIONRATE = REGISTRY.register(1, "CompressionRate");
    public static final Object WHITEBALANCE = REGISTRY.register(3, "WhiteBalance");
    public static final Object FOCUSMODE = REGISTRY.register(7, "FocusMode");
    public static final Object LEIKAWHITEBALANCE = REGISTRY.register(13, "LeikaWhiteBalance");
    public static final Object SPOT_AUTOFOCUS = REGISTRY.register(15, "Spot Autofocus");
    public static final Object MACROMODE = REGISTRY.register(28, "MacroMode");
    public static final Object APERTURE = REGISTRY.register(31, "Aperture");
    public static final Object FLASHEV = REGISTRY.register(36, "FlashEV");
    public static final Object CONTRAST = REGISTRY.register(44, "Contrast");

    public LeicaMakerNoteSupport() {
        super(REGISTRY);
    }

    public boolean isCompressionRateAvailable() {
        return this.containsTag(COMPRESSIONRATE);
    }

    public CompressionRate getCompressionRate() {
        return CompressionRate.getInstance(this.getInteger(COMPRESSIONRATE));
    }

    public boolean isWhiteBalanceAvailable() {
        return this.containsTag(WHITEBALANCE);
    }

    public WhiteBalance getWhiteBalance() {
        return WhiteBalance.getInstance(this.getInteger(WHITEBALANCE));
    }

    public boolean isFocusModeAvailable() {
        return this.containsTag(FOCUSMODE);
    }

    public FocusMode getFocusMode() {
        return FocusMode.getInstance(this.getInteger(FOCUSMODE));
    }

    public boolean isLeikaWhiteBalanceAvailable() {
        return this.containsTag(LEIKAWHITEBALANCE);
    }

    public int[] getLeikaWhiteBalance() {
        return this.getIntegers(LEIKAWHITEBALANCE);
    }

    public boolean isSpotAutofocusAvailable() {
        return this.containsTag(SPOT_AUTOFOCUS);
    }

    public SpotAutofocus getSpotAutofocus() {
        return SpotAutofocus.getInstance(this.getInteger(SPOT_AUTOFOCUS));
    }

    public boolean isMacroModeAvailable() {
        return this.containsTag(MACROMODE);
    }

    public int getMacroMode() {
        return this.getInteger(MACROMODE);
    }

    public boolean isApertureAvailable() {
        return this.containsTag(APERTURE);
    }

    public Aperture getAperture() {
        return Aperture.getInstance(this.getInteger(APERTURE));
    }

    public boolean isFlashEVAvailable() {
        return this.containsTag(FLASHEV);
    }

    public int getFlashEV() {
        return this.getInteger(FLASHEV);
    }

    public boolean isContrastAvailable() {
        return this.containsTag(CONTRAST);
    }

    public Contrast getContrast() {
        return Contrast.getInstance(this.getInteger(CONTRAST));
    }

    public static class Contrast
    extends Directory.Enumeration {
        public static final Contrast _0X100 = new Contrast(256, "0x100");
        public static final Contrast _0X110 = new Contrast(272, "0x110");
        public static final Contrast _0X120 = new Contrast(288, "0x120");
        public static final Contrast __1 = new Contrast(-1, "-1");

        private Contrast(int value, String name) {
            super(value, name);
        }

        private Contrast(int[] value, String name) {
            super(value, name);
        }

        public static Contrast getInstance(int value) {
            if (Contrast.equals(value, 256)) {
                return _0X100;
            }
            if (Contrast.equals(value, 272)) {
                return _0X110;
            }
            if (Contrast.equals(value, 288)) {
                return _0X120;
            }
            if (Contrast.equals(value, -1)) {
                return __1;
            }
            return new Contrast(value, "unknown");
        }
    }

    public static class Aperture
    extends Directory.Enumeration {
        public static final Aperture _6 = new Aperture(6, "6");
        public static final Aperture _7 = new Aperture(7, "7");
        public static final Aperture __1 = new Aperture(-1, "-1");

        private Aperture(int value, String name) {
            super(value, name);
        }

        private Aperture(int[] value, String name) {
            super(value, name);
        }

        public static Aperture getInstance(int value) {
            if (Aperture.equals(value, 6)) {
                return _6;
            }
            if (Aperture.equals(value, 7)) {
                return _7;
            }
            if (Aperture.equals(value, -1)) {
                return __1;
            }
            return new Aperture(value, "unknown");
        }
    }

    public static class SpotAutofocus
    extends Directory.Enumeration {
        public static final SpotAutofocus _256 = new SpotAutofocus(256, "256");
        public static final SpotAutofocus _4096 = new SpotAutofocus(4096, "4096");
        public static final SpotAutofocus __1 = new SpotAutofocus(-1, "-1");

        private SpotAutofocus(int value, String name) {
            super(value, name);
        }

        private SpotAutofocus(int[] value, String name) {
            super(value, name);
        }

        public static SpotAutofocus getInstance(int value) {
            if (SpotAutofocus.equals(value, 256)) {
                return _256;
            }
            if (SpotAutofocus.equals(value, 4096)) {
                return _4096;
            }
            if (SpotAutofocus.equals(value, -1)) {
                return __1;
            }
            return new SpotAutofocus(value, "unknown");
        }
    }

    public static class FocusMode
    extends Directory.Enumeration {
        public static final FocusMode _1 = new FocusMode(1, "1");
        public static final FocusMode _2 = new FocusMode(2, "2");
        public static final FocusMode __1 = new FocusMode(-1, "-1");

        private FocusMode(int value, String name) {
            super(value, name);
        }

        private FocusMode(int[] value, String name) {
            super(value, name);
        }

        public static FocusMode getInstance(int value) {
            if (FocusMode.equals(value, 1)) {
                return _1;
            }
            if (FocusMode.equals(value, 2)) {
                return _2;
            }
            if (FocusMode.equals(value, -1)) {
                return __1;
            }
            return new FocusMode(value, "unknown");
        }
    }

    public static class WhiteBalance
    extends Directory.Enumeration {
        public static final WhiteBalance _1 = new WhiteBalance(1, "1");
        public static final WhiteBalance _2 = new WhiteBalance(2, "2");
        public static final WhiteBalance _3 = new WhiteBalance(3, "3");
        public static final WhiteBalance _4 = new WhiteBalance(4, "4");
        public static final WhiteBalance _5 = new WhiteBalance(5, "5");
        public static final WhiteBalance _8 = new WhiteBalance(8, "8");
        public static final WhiteBalance _10 = new WhiteBalance(10, "10");
        public static final WhiteBalance __1 = new WhiteBalance(-1, "-1");

        private WhiteBalance(int value, String name) {
            super(value, name);
        }

        private WhiteBalance(int[] value, String name) {
            super(value, name);
        }

        public static WhiteBalance getInstance(int value) {
            if (WhiteBalance.equals(value, 1)) {
                return _1;
            }
            if (WhiteBalance.equals(value, 2)) {
                return _2;
            }
            if (WhiteBalance.equals(value, 3)) {
                return _3;
            }
            if (WhiteBalance.equals(value, 4)) {
                return _4;
            }
            if (WhiteBalance.equals(value, 5)) {
                return _5;
            }
            if (WhiteBalance.equals(value, 8)) {
                return _8;
            }
            if (WhiteBalance.equals(value, 10)) {
                return _10;
            }
            if (WhiteBalance.equals(value, -1)) {
                return __1;
            }
            return new WhiteBalance(value, "unknown");
        }
    }

    public static class CompressionRate
    extends Directory.Enumeration {
        public static final CompressionRate _2 = new CompressionRate(2, "2");
        public static final CompressionRate _3 = new CompressionRate(3, "3");
        public static final CompressionRate _6 = new CompressionRate(6, "6");
        public static final CompressionRate _7 = new CompressionRate(7, "7");
        public static final CompressionRate __1 = new CompressionRate(-1, "-1");

        private CompressionRate(int value, String name) {
            super(value, name);
        }

        private CompressionRate(int[] value, String name) {
            super(value, name);
        }

        public static CompressionRate getInstance(int value) {
            if (CompressionRate.equals(value, 2)) {
                return _2;
            }
            if (CompressionRate.equals(value, 3)) {
                return _3;
            }
            if (CompressionRate.equals(value, 6)) {
                return _6;
            }
            if (CompressionRate.equals(value, 7)) {
                return _7;
            }
            if (CompressionRate.equals(value, -1)) {
                return __1;
            }
            return new CompressionRate(value, "unknown");
        }
    }
}

