/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.io;

import it.tidalwave.imageio.io.BitReader;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.stream.ImageInputStream;

class FastBitReader
extends BitReader {
    private static final int BITS_PER_BYTE = 8;
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private boolean skipZeroAfterFF;

    public FastBitReader(@Nonnull ImageInputStream iis) {
        this(iis, 65536);
    }

    public FastBitReader(@Nonnull ImageInputStream iis, @Nonnegative int bufferSize) {
        this.iis = iis;
        this.byteBuffer = new byte[bufferSize];
    }

    public void setSkipZeroAfterFF(boolean skipZeroAfterFF) {
        this.skipZeroAfterFF = skipZeroAfterFF;
    }

    protected void resync() {
        this.bufferSize = 0;
        this.bitPosition = 0;
        this.bytePointer = 0;
    }

    @Nonnegative
    public int readBits(@Nonnegative int bitsToGet) throws IOException {
        if (bitsToGet < 0) {
            throw new IllegalArgumentException("bitsToGet: " + bitsToGet);
        }
        if (bitsToGet == 0) {
            return 0;
        }
        int r = 0;
        int mask = (int)((1L << bitsToGet) - 1L);
        while (bitsToGet > 0) {
            int bitsToGetNow = 8 - this.bitPosition;
            if (bitsToGetNow > bitsToGet) {
                bitsToGetNow = bitsToGet;
            }
            if (this.bytePointer >= this.bufferSize) {
                this.bufferSize = this.iis.read(this.byteBuffer);
                this.bytePointer = 0;
            }
            int currentByte = this.byteBuffer[this.bytePointer] & 0xFF;
            int shift = this.bitPosition + bitsToGet - 8;
            r |= shift >= 0 ? currentByte << shift : currentByte >>> -shift;
            bitsToGet -= bitsToGetNow;
            this.bitPosition += bitsToGetNow;
            if (this.bitPosition < 8) continue;
            this.bitPosition -= 8;
            ++this.bytePointer;
            if (!this.skipZeroAfterFF || currentByte != 255) continue;
            if (this.bytePointer >= this.bufferSize) {
                byte b = this.iis.readByte();
                continue;
            }
            ++this.bytePointer;
        }
        return r & mask;
    }

    public String toString() {
        return String.format("FastBitReader@%06x", System.identityHashCode(this));
    }
}

