/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.image;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.grelf.image.FITS_KeywordRecord;
import net.grelf.image.Metadata;
import net.grelf.image.NoImageException;

public class FITS_Header {
    private List<FITS_KeywordRecord> keywordsList = null;
    private Map<String, FITS_KeywordRecord> keywordsMap = null;
    private int[] axes = null;
    private int bitpix = 0;
    private double bscale = 1.0;
    private double bzero = 0.0;
    private boolean primary;

    public Metadata getMetadata() {
        return new Metadata(this.keywordsList);
    }

    public int[] getAxes() {
        return this.axes;
    }

    public int getBitpix() {
        return this.bitpix;
    }

    public double getBscale() {
        return this.bscale;
    }

    public double getBzero() {
        return this.bzero;
    }

    public boolean isPrimaryHeader() {
        return this.primary;
    }

    public boolean isImageHeader() {
        if (this.primary) {
            FITS_KeywordRecord fITS_KeywordRecord = this.keywordsMap.get("SIMPLE");
            return null != fITS_KeywordRecord && fITS_KeywordRecord.getValue().equals("T");
        }
        FITS_KeywordRecord fITS_KeywordRecord = this.keywordsMap.get("XTENSION");
        return null != fITS_KeywordRecord && fITS_KeywordRecord.getValue().equals("'IMAGE   '");
    }

    public FITS_Header read(DataInputStream dataInputStream, String string, boolean bl) throws IOException, NoImageException {
        this.keywordsList = new ArrayList<FITS_KeywordRecord>();
        this.keywordsMap = new HashMap<String, FITS_KeywordRecord>();
        this.primary = bl;
        byte[] byArray = new byte[80];
        int n = 0;
        try {
            int n2;
            boolean bl2 = false;
            do {
                dataInputStream.readFully(byArray);
                FITS_KeywordRecord fITS_KeywordRecord = new FITS_KeywordRecord(byArray);
                if (null == fITS_KeywordRecord) {
                    throw new NoImageException("Invalid keyword record");
                }
                bl2 = fITS_KeywordRecord.getKeyword().equals("END");
                if (!bl2) {
                    this.keywordsList.add(fITS_KeywordRecord);
                    this.keywordsMap.put(fITS_KeywordRecord.getKeyword(), fITS_KeywordRecord);
                }
                ++n;
            } while (!bl2);
            for (int i = n % 36; i < 36; ++i) {
                dataInputStream.readFully(byArray);
            }
            FITS_KeywordRecord fITS_KeywordRecord = this.keywordsMap.get("NAXIS");
            if (null != fITS_KeywordRecord && 0 < (n2 = Integer.parseInt(fITS_KeywordRecord.getValue()))) {
                this.axes = new int[n2];
            }
            if (null == this.axes) {
                throw new NoImageException("NAXES is 0 or not found");
            }
            for (n2 = 1; n2 <= this.axes.length; ++n2) {
                int n3;
                String string2 = "NAXIS" + n2;
                FITS_KeywordRecord fITS_KeywordRecord2 = this.keywordsMap.get(string2);
                if (null != fITS_KeywordRecord2) {
                    n3 = Integer.parseInt(fITS_KeywordRecord2.getValue());
                    if (0 >= n3) {
                        throw new NoImageException("NAXIS" + n2 + " is 0");
                    }
                } else {
                    throw new NoImageException("NAXIS" + n2 + " keyword absent");
                }
                this.axes[n2 - 1] = n3;
            }
            fITS_KeywordRecord = this.keywordsMap.get("BITPIX");
            if (null == fITS_KeywordRecord) {
                throw new NoImageException("BITPIX keyword absent");
            }
            this.bitpix = Integer.parseInt(fITS_KeywordRecord.getValue());
            try {
                FITS_KeywordRecord fITS_KeywordRecord3;
                fITS_KeywordRecord = this.keywordsMap.get("BSCALE");
                if (null != fITS_KeywordRecord) {
                    this.bscale = Double.parseDouble(fITS_KeywordRecord.getValue());
                }
                if (null != (fITS_KeywordRecord3 = this.keywordsMap.get("BZERO"))) {
                    this.bzero = Double.parseDouble(fITS_KeywordRecord3.getValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.bscale = 1.0;
                this.bzero = 0.0;
            }
        }
        catch (EOFException eOFException) {
            return null;
        }
        return this;
    }
}

