/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import net.grelf.Util;
import net.grelf.VectorFloat;
import net.grelf.grip.ConnectionList;
import net.grelf.grip.GRIP;

public class Connection
implements Comparable<Connection> {
    protected VectorFloat vector;
    protected int fromBlob;
    protected int toBlob;

    public Connection(VectorFloat vectorFloat, int n, int n2) {
        this.vector = vectorFloat;
        this.fromBlob = n;
        this.toBlob = n2;
    }

    @Override
    public int compareTo(Connection connection) {
        return this.vector.compareTo(connection.vector);
    }

    public String toString() {
        return "Connection: " + this.vector.toString() + " from Blob " + this.fromBlob + " to Blob " + this.toBlob;
    }

    public static void reportConnections(List<List<ConnectionList>> list, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            printWriter.println("image,i,j,r,theta");
            for (int i = 0; i < list.size(); ++i) {
                List<ConnectionList> list2 = list.get(i);
                for (int j = 0; j < list2.size(); ++j) {
                    ConnectionList connectionList = list2.get(j);
                    for (Connection connection : connectionList) {
                        printWriter.println(i + "," + connection.fromBlob + "," + connection.toBlob + "," + (int)connection.vector.r + "," + (int)(180.0 * (double)connection.vector.theta / Math.PI));
                    }
                }
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            Util.warning(GRIP.getInstance(), "Error", (Object)iOException.toString());
        }
    }
}

