/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.grip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.grelf.AbstractDialogue;
import net.grelf.FileIO;
import net.grelf.grip.Config;
import net.grelf.grip.GRIP;

public class ConfigDialogue
extends AbstractDialogue
implements ActionListener {
    private Map<String, JTextField> fields = new HashMap<String, JTextField>();
    private JButton okButton;
    private JButton cancelButton;
    private JButton resetButton;
    private JPanel buttonPanel;
    private Map<String, JButton> browseButtons = new HashMap<String, JButton>();

    public ConfigDialogue() {
        this.setTitle("Configure properties");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        this.buttonPanel = new JPanel(new BorderLayout());
        this.buttonPanel.add((Component)this.resetButton, "West");
        this.buttonPanel.add((Component)this.okButton, "Center");
        this.buttonPanel.add((Component)this.cancelButton, "East");
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(0, 3, 8, 8));
        List<String> list = Config.getKeys();
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!string.endsWith(".prompt")) continue;
            String string2 = string.substring(0, string.lastIndexOf(".prompt"));
            String string3 = Config.getValue(string);
            String string4 = Config.getValue(string2 + ".value");
            String string5 = Config.getValue(string2 + ".min");
            String string6 = Config.getValue(string2 + ".max");
            String string7 = Config.getValue(string2 + ".type");
            if (null != string5) {
                string3 = null != string6 ? string3 + " [" + string5 + " .. " + string6 + "] " : string3 + " [" + string5 + " .. ] ";
            } else if (null != string6) {
                string3 = string3 + " [ .. " + string6 + "] ";
            }
            container.add(new JLabel(string3));
            JTextField jTextField = new JTextField();
            if (null != string4) {
                jTextField.setText(string4);
            }
            container.add(jTextField);
            this.fields.put(string2, jTextField);
            if (string7.equals("path")) {
                JButton jButton = new JButton("Browse");
                jButton.addActionListener(this);
                container.add(jButton);
                this.browseButtons.put(string2, jButton);
                continue;
            }
            container.add(new JLabel(" "));
        }
        container.add(this.buttonPanel);
        this.pack();
        this.setLocation(200, 0);
        this.setModal(true);
        this.setIconImage(GRIP.getInstance().getIconImage());
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.okButton) {
                this.processOK();
            } else if (jButton == this.resetButton) {
                this.processReset();
            } else if (jButton == this.cancelButton) {
                this.processCancel();
            } else {
                Set<String> set = this.browseButtons.keySet();
                for (String string : set) {
                    String string2;
                    String string3;
                    JButton jButton2 = this.browseButtons.get(string);
                    if (jButton != jButton2 || null == (string3 = FileIO.selectInputFile(string2 = Config.getValue(string + ".prompt")))) continue;
                    this.fields.get(string).setText(string3);
                }
            }
        }
    }

    private void processOK() {
        boolean bl = true;
        for (String string : this.fields.keySet()) {
            String string2 = Config.getValue(string + ".type");
            String string3 = Config.getValue(string + ".min");
            String string4 = Config.getValue(string + ".max");
            if (null == string2) continue;
            JTextField jTextField = this.fields.get(string);
            jTextField.setForeground(Color.black);
            try {
                int n;
                if (string2.equals("double")) {
                    double d;
                    double d2 = Double.parseDouble(jTextField.getText());
                    if (null != string3 && d2 < (d = Double.parseDouble(string3))) {
                        bl = false;
                        jTextField.setForeground(Color.red);
                    }
                    if (null == string4 || !(d2 > (d = Double.parseDouble(string4)))) continue;
                    bl = false;
                    jTextField.setForeground(Color.red);
                    continue;
                }
                if (!string2.equals("int")) continue;
                int n2 = Integer.parseInt(jTextField.getText());
                if (null != string3 && n2 < (n = Integer.parseInt(string3))) {
                    bl = false;
                    jTextField.setForeground(Color.red);
                }
                if (null == string4 || n2 <= (n = Integer.parseInt(string4))) continue;
                bl = false;
                jTextField.setForeground(Color.red);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                jTextField.setForeground(Color.red);
            }
        }
        if (bl) {
            for (String string : this.fields.keySet()) {
                Config.set(string + ".value", this.fields.get(string).getText());
            }
            Config.save();
            this.setVisible(false);
            this.dispose();
        }
    }

    private void processReset() {
        for (String string : this.fields.keySet()) {
            JTextField jTextField = this.fields.get(string);
            String string2 = Config.getValue(string + ".default");
            if (null == string2) continue;
            jTextField.setText(string2);
        }
    }

    private void processCancel() {
        this.setVisible(false);
        this.dispose();
    }
}

