/*
 * Decompiled with CFR 0.152.
 */
package net.grelf.astro;

import java.io.Serializable;
import java.text.DecimalFormat;

public class ProperMotion
implements Serializable,
Cloneable {
    private double pmRA_arcsecPerYr = 0.0;
    private double pmDec_arcsecPerYr = 0.0;
    private static final double EPSILON = 1.0E-7;
    private static final DecimalFormat DF4 = new DecimalFormat("0.0000");

    public double getPmRA_arcsecPerYr() {
        return this.pmRA_arcsecPerYr;
    }

    public double getPmDec_arcsecPerYr() {
        return this.pmDec_arcsecPerYr;
    }

    public boolean isKnown() {
        return this.pmRA_arcsecPerYr != 0.0 || this.pmDec_arcsecPerYr != 0.0;
    }

    public ProperMotion(double d, double d2) {
        this.pmRA_arcsecPerYr = d;
        this.pmDec_arcsecPerYr = d2;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        ProperMotion properMotion = (ProperMotion)object;
        if (1.0E-7 < Math.abs(properMotion.pmRA_arcsecPerYr - this.pmRA_arcsecPerYr)) {
            return false;
        }
        return !(1.0E-7 < Math.abs(properMotion.pmDec_arcsecPerYr - this.pmDec_arcsecPerYr));
    }

    public int hashCode() {
        return (int)(31.0 * this.pmRA_arcsecPerYr + 43.0 * this.pmDec_arcsecPerYr);
    }

    public ProperMotion clone() {
        return new ProperMotion(this.pmRA_arcsecPerYr, this.pmDec_arcsecPerYr);
    }

    public String toString() {
        return "RA: " + DF4.format(this.pmRA_arcsecPerYr) + " Dec: " + DF4.format(this.pmDec_arcsecPerYr) + " (arcsec/yr)";
    }

    public String toFoldedString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RA: ");
        stringBuffer.append(DF4.format(this.pmRA_arcsecPerYr));
        stringBuffer.append(string);
        stringBuffer.append(" Dec: ");
        stringBuffer.append(DF4.format(this.pmDec_arcsecPerYr));
        stringBuffer.append(string);
        stringBuffer.append(" (arcsec/yr)");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public StringBuffer toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<PM><RA>");
        stringBuffer.append(DF4.format(this.pmRA_arcsecPerYr));
        stringBuffer.append("</RA><Dec>");
        stringBuffer.append(DF4.format(this.pmDec_arcsecPerYr));
        stringBuffer.append("</Dec><Units>arcsec/yr</Units></PM>");
        return stringBuffer;
    }
}

