/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.image;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.stamppagetor.image.ImageEditList;

public class ImageEditControl
extends JComponent
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -3645143557561869231L;
    private static final String ROTATE_LEFT_COMMAND = "Rotate Left";
    private static final String ROTATE_RIGHT_COMMAND = "Rotate Right";
    private static final String DELETE_COMMAND = "Delete";
    private final JButton rotateLeftButton = new JButton("Rotate Left");
    private final JButton rotateRightButton = new JButton("Rotate Right");
    private final JButton deleteButton = new JButton("Delete");
    private final ImageEditList imageEditList = new ImageEditList();
    private final JList listControl = new JList(this.imageEditList);

    public ImageEditControl() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.rotateLeftButton);
        jPanel.add(this.rotateRightButton);
        jPanel.add(this.deleteButton);
        this.rotateLeftButton.addActionListener(this);
        this.rotateRightButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.rotateLeftButton.setEnabled(false);
        this.rotateRightButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.listControl.setBorder(BorderFactory.createLoweredBevelBorder());
        this.listControl.setSelectionMode(0);
        this.listControl.setLayoutOrientation(2);
        this.listControl.setVisibleRowCount(-1);
        this.listControl.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.listControl);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setBorder(BorderFactory.createTitledBorder("Images"));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel, "South");
    }

    public void setImages(Vector<BufferedImage> vector) {
        this.imageEditList.setImages(vector);
    }

    public Vector<BufferedImage> getImages() {
        return this.imageEditList.getImages();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = this.listControl.getSelectedIndex();
        if (n >= 0) {
            if (string.equals(ROTATE_LEFT_COMMAND)) {
                this.imageEditList.rotateImage90(n, false);
            } else if (string.equals(ROTATE_RIGHT_COMMAND)) {
                this.imageEditList.rotateImage90(n, true);
            } else if (string.equals(DELETE_COMMAND)) {
                this.imageEditList.deleteImage(n);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.listControl.getSelectedIndex() >= 0;
        this.rotateLeftButton.setEnabled(bl);
        this.rotateRightButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
    }
}

