/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.stamppagetor.PageViewActionListener;
import org.stamppagetor.StampDocument;
import org.stamppagetor.StampPage;
import org.stamppagetor.StampPrintable;

public class PageView
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = -4579588095023677687L;
    private Zooming zoomState = Zooming.ZOOM_FIT_WIDTH;
    private double zoom = 1.0;
    private final int marginal = 20;
    private int selectedPage = 0;
    private StampDocument document = null;
    private StampPrintable selectedObject = null;
    private boolean highlight = false;
    private Rectangle paperRect = null;
    private Set<PageViewActionListener> actionListeners = new HashSet<PageViewActionListener>(7);
    static final Dimension minSize = new Dimension(100, 100);

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension;
        switch (this.zoomState) {
            case ZOOM_FIT_PAGE: {
                dimension = this.getParent().getSize();
                break;
            }
            case ZOOM_FIT_WIDTH: {
                Dimension dimension2 = this.getPaperDimension();
                Dimension dimension3 = this.getParent().getParent().getSize();
                dimension = new Dimension(dimension3.width - 32, (dimension3.width - 32) * dimension2.height / dimension2.width);
                break;
            }
            case ZOOM_CUSTOM: {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                int n = toolkit.getScreenResolution();
                Dimension dimension4 = this.getPaperDimension();
                dimension = new Dimension((int)(this.zoom * (double)dimension4.width * (double)n / 72.0), (int)(this.zoom * (double)dimension4.height * (double)n / 72.0));
                break;
            }
            default: {
                dimension = super.getPreferredSize();
            }
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return minSize;
    }

    public void setDoc(StampDocument stampDocument) {
        if (this.document != stampDocument) {
            this.document = stampDocument;
            this.repaint();
        }
    }

    public void setPage(int n) {
        this.selectedPage = n;
        this.repaint();
    }

    public void setPage(StampPage stampPage) {
        int n = this.document.getIndexOfPage(stampPage);
        if (this.selectedPage != n) {
            this.selectedPage = n != -1 ? n : 0;
            this.repaint();
        }
    }

    public void setPageHighLight(boolean bl) {
        this.highlight = bl;
    }

    public void setSelection(StampPrintable stampPrintable) {
        if (stampPrintable != this.selectedObject) {
            this.selectedObject = stampPrintable;
            this.repaint();
        }
    }

    private Dimension getPaperDimension() {
        PageFormat pageFormat = this.document != null ? this.document.getPageFormat(0) : new PageFormat();
        return new Dimension((int)pageFormat.getWidth(), (int)pageFormat.getHeight());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle;
        int n;
        int n2;
        int n3 = super.getWidth();
        int n4 = super.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics.create(0, 0, n3, n4);
        Rectangle rectangle2 = new Rectangle(0, 0, n3, n4);
        graphics2D.setColor(new Color(120, 120, 120));
        graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Dimension dimension = this.getPaperDimension();
        int n5 = rectangle2.height - this.marginal - this.marginal;
        int n6 = dimension.width * n5 / dimension.height;
        int n7 = rectangle2.width - this.marginal - this.marginal;
        if (this.zoomState == Zooming.ZOOM_CUSTOM) {
            int n8 = Toolkit.getDefaultToolkit().getScreenResolution();
            n2 = (int)(this.zoom * 0.9 * (double)dimension.width * (double)n8 / 72.0);
            n = (int)(this.zoom * 0.9 * (double)dimension.height * (double)n8 / 72.0);
        } else if (n6 <= n7) {
            n2 = n6;
            n = n5;
        } else {
            n2 = n7;
            n = n7 * dimension.height / dimension.width;
        }
        this.paperRect = rectangle = new Rectangle(rectangle2.x + (rectangle2.width - n2) / 2, rectangle2.y + (rectangle2.height - n) / 2, n2, n);
        graphics2D.setColor(new Color(100, 100, 100));
        graphics2D.fillRect(rectangle.x + 4, rectangle.y + 4, rectangle.width, rectangle.height);
        if (this.highlight) {
            graphics2D.setColor(new Color(255, 255, 170));
        } else {
            graphics2D.setColor(new Color(255, 255, 255));
        }
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(new Color(0, 0, 0));
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        double d = (double)n2 / (double)dimension.width;
        graphics2D.scale(d, d);
        Rectangle rectangle3 = new Rectangle((int)((double)rectangle.x / d), (int)((double)rectangle.y / d), (int)((double)rectangle.width / d), (int)((double)rectangle.height / d));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.document != null) {
            this.document.print(graphics2D, this.document.getPageFormat(0), this.selectedPage, this.selectedObject, rectangle3);
        }
    }

    public void addActionListener(PageViewActionListener pageViewActionListener) {
        this.actionListeners.add(pageViewActionListener);
        this.addMouseListener(this);
    }

    private StampPrintable getObjectAt(int n, int n2) {
        StampPrintable stampPrintable = null;
        if (this.document != null) {
            int n3 = n;
            int n4 = n2;
            Rectangle rectangle = this.paperRect;
            PageFormat pageFormat = this.document != null ? this.document.getPageFormat(0) : new PageFormat();
            Dimension dimension = new Dimension((int)pageFormat.getWidth(), (int)pageFormat.getHeight());
            int n5 = (int)((double)(n3 - rectangle.x) / (double)rectangle.width * (double)dimension.width);
            int n6 = (int)((double)(n4 - rectangle.y) / (double)rectangle.height * (double)dimension.height);
            stampPrintable = this.document.checkPoint(this.selectedPage, n5, n6);
        }
        return stampPrintable;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        StampPrintable stampPrintable = this.getObjectAt(mouseEvent.getX(), mouseEvent.getY());
        if (stampPrintable != null) {
            for (PageViewActionListener pageViewActionListener : this.actionListeners) {
                pageViewActionListener.pagePressed(this.selectedPage, stampPrintable);
            }
            if (mouseEvent.isPopupTrigger()) {
                for (PageViewActionListener pageViewActionListener : this.actionListeners) {
                    pageViewActionListener.pagePopUp(this.selectedPage, stampPrintable, this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        StampPrintable stampPrintable = this.getObjectAt(mouseEvent.getX(), mouseEvent.getY());
        if (stampPrintable != null && mouseEvent.isPopupTrigger()) {
            for (PageViewActionListener pageViewActionListener : this.actionListeners) {
                pageViewActionListener.pagePressed(this.selectedPage, stampPrintable);
                pageViewActionListener.pagePopUp(this.selectedPage, stampPrintable, this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Zooming getZoomState() {
        return this.zoomState;
    }

    public void setZoomState(Zooming zooming) {
        this.zoomState = zooming;
        this.revalidate();
        this.repaint();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double d) {
        this.zoom = d;
    }

    public static enum Zooming {
        ZOOM_FIT_PAGE,
        ZOOM_FIT_WIDTH,
        ZOOM_CUSTOM;

    }
}

