package typecontrol.forms;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Date;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

import com.michaelbaranov.microba.calendar.CalendarPane;

public class FrmCalendar extends JDialog {

	private static final long serialVersionUID = 1L;

	private Action _actionListener;
	private GUI _gui;
	private ValidateListener _validateListener;
	
	private Date _date;
	
	public FrmCalendar(String title, Boolean setVisible, Date date) {
		
		super();
		
		setTitle(title);
		
		_date = date;
		
		initialize();
		pack();
		
		setVisible(setVisible);
		
		setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
		addWindowListener(new Window());
	}
	
	public void addValidateListener(ValidateListener validate) {
		_validateListener = validate;
	}
	
	public void removeValidateListener() {
		_validateListener = null;
	}
	
	private void btnOk_Click() {
		setVisible(false);
		if (_validateListener != null) {
			_validateListener.validate(true, _gui.getCalendarPane().getDate());
		}
	}
	
	private void btnCancel_Click() {
		setVisible(false);
		if (_validateListener != null) {
			_validateListener.validate(false, _gui.getCalendarPane().getDate());
		}
	}
	
	private void initialize() {
		_actionListener = new Action();
		_gui = new GUI();
	}
	
	private class GUI {
		protected static final String BTN_OK_NAME = "btnOk";
		protected static final String BTN_CANCEL_NAME = "btnCancel";
		
		private CalendarPane _calCalendar;
		
		private JButton _btnOk;
		private JButton _btnCancel;
		
		private JPanel _panButtons;
		
		public GUI() {
			setLayout(new BorderLayout());
			add(getCalendarPane(), BorderLayout.CENTER);
			add(getPanButtons(), BorderLayout.SOUTH);
		}
		
		protected JButton getBtnOk() {
			if (_btnOk == null) {
				_btnOk = new JButton();
				_btnOk.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(getClass().getClassLoader().getResource("ressources/OK.png"))));
				_btnOk.setName(BTN_OK_NAME);
				_btnOk.addActionListener(_actionListener);
			}
			return _btnOk;
		}
		
		protected JButton getBtnCancel() {
			if (_btnCancel == null) {
				_btnCancel = new JButton();
				_btnCancel.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(getClass().getClassLoader().getResource("ressources/Cancel.png"))));
				_btnCancel.setName(BTN_CANCEL_NAME);
				_btnCancel.addActionListener(_actionListener);
			}
			return _btnCancel;
		}
	
		protected JPanel getPanButtons() {
			if (_panButtons == null) {
				_panButtons = new JPanel();
				_panButtons.add(getBtnOk());
				_panButtons.add(getBtnCancel());
			}
			return _panButtons;
		}
	
		protected CalendarPane getCalendarPane() {
			if (_calCalendar == null) {
				_calCalendar = new CalendarPane(_date);
			}
			return _calCalendar;
		}
	}
	
	private class Action implements ActionListener {
		public void actionPerformed(ActionEvent arg0) {
			String name = ((JComponent) arg0.getSource()).getName();
			if (name.equals(GUI.BTN_OK_NAME)) {
				btnOk_Click();
			} else if (name.equals(GUI.BTN_CANCEL_NAME)) {
				btnCancel_Click();
			}
		}
	}
	
	private class Window implements WindowListener {

		public void windowActivated(WindowEvent arg0) {}

		public void windowClosed(WindowEvent arg0) {}

		public void windowClosing(WindowEvent arg0) {
			btnCancel_Click();
		}

		public void windowDeactivated(WindowEvent arg0) {}

		public void windowDeiconified(WindowEvent arg0) {}

		public void windowIconified(WindowEvent arg0) {}

		public void windowOpened(WindowEvent arg0) {
			// TODO Auto-generated method stub
			
		}
		
	}
	
	public interface ValidateListener {
		public void validate(Boolean isValid, Date date);
	}
}
