/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.simplemq.MessageDispatcher;
import org.diylc.common.DrawOption;
import org.diylc.common.EventType;
import org.diylc.common.GridType;
import org.diylc.common.IComponentFiler;
import org.diylc.common.ObjectCache;
import org.diylc.core.ComponentState;
import org.diylc.core.IContinuity;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.presenter.CalcUtils;
import org.diylc.presenter.ComponentArea;
import org.diylc.presenter.Connection;
import org.diylc.presenter.G2DWrapper;
import org.diylc.utils.Constants;

public class DrawingManager {
    private static final Logger LOG = Logger.getLogger(DrawingManager.class);
    public static int CONTROL_POINT_SIZE = 7;
    public static double EXTRA_SPACE = 0.25;
    public static final String ZOOM_KEY = "zoom";
    private static boolean SHADE_EXTRA_SPACE = true;
    public static String DEBUG_COMPONENT_AREAS = "org.diylc.debugComponentAreas";
    public static String DEBUG_CONTINUITY_AREAS = "org.diylc.debugContinuityAreas";
    public static Color CONTROL_POINT_COLOR = Color.blue;
    public static Color SELECTED_CONTROL_POINT_COLOR = Color.green;
    private Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
    private Map<IDIYComponent<?>, ComponentArea> componentAreaMap;
    private Map<IDIYComponent<?>, ComponentState> lastDrawnStateMap;
    private Area continuityArea;
    private Composite slotComposite = AlphaComposite.getInstance(3, 0.3f);
    private Composite lockedComposite = AlphaComposite.getInstance(3, 0.3f);
    private List<IDIYComponent<?>> failedComponents = new ArrayList();
    private double zoomLevel = 1.0;
    private MessageDispatcher<EventType> messageDispatcher;
    private boolean debugComponentAreas;
    private boolean debugContinuityAreas;

    public DrawingManager(MessageDispatcher<EventType> messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        this.componentAreaMap = new HashMap();
        this.lastDrawnStateMap = new HashMap();
        String string = System.getProperty(DEBUG_COMPONENT_AREAS);
        this.debugComponentAreas = string != null && string.equalsIgnoreCase("true");
        String string2 = System.getProperty(DEBUG_CONTINUITY_AREAS);
        this.debugContinuityAreas = string2 != null && string2.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IDIYComponent<?>> drawProject(Graphics2D graphics2D, Project project, Set<DrawOption> set, IComponentFiler iComponentFiler, Rectangle rectangle, Collection<IDIYComponent<?>> collection, Set<IDIYComponent<?>> set2, Set<IDIYComponent<?>> set3, List<Point> list, List<IDIYComponent<?>> list2, boolean bl, Double d) {
        Object object;
        Iterator<ComponentArea> iterator;
        this.failedComponents.clear();
        if (project == null) {
            return this.failedComponents;
        }
        double d2 = 1.0;
        d2 = set.contains((Object)DrawOption.ZOOM) ? this.zoomLevel : 1.0 / Constants.PIXEL_SIZE;
        if (d != null) {
            d2 *= d.doubleValue();
        }
        G2DWrapper g2DWrapper = new G2DWrapper(graphics2D, d2);
        if (set.contains((Object)DrawOption.ANTIALIASING)) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (ConfigurationManager.getInstance().readBoolean("hiQualityRender", false)) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        Dimension dimension = this.getCanvasDimensions(project, d2, set.contains((Object)DrawOption.EXTRA_SPACE));
        g2DWrapper.setColor(this.theme.getBgColor());
        g2DWrapper.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.clip(new Rectangle(new Point(0, 0), dimension));
        GridType gridType = GridType.LINES;
        if (set.contains((Object)DrawOption.GRID) && gridType != GridType.NONE) {
            double d3;
            double d4 = project.getGridSpacing().convertToPixels() * d2;
            float f = (float)(1.0 * (d2 > 1.0 ? 1.0 : d2));
            if (gridType == GridType.CROSSHAIR) {
                graphics2D.setStroke(new BasicStroke(f, 0, 0, 10.0f, new float[]{(float)d4 / 2.0f, (float)d4 / 2.0f}, (float)d4 / 4.0f));
            } else if (gridType == GridType.DOT) {
                graphics2D.setStroke(new BasicStroke(f, 0, 0, 10.0f, new float[]{1.0f, (float)d4 - 1.0f}, 0.0f));
            } else {
                graphics2D.setStroke(ObjectCache.getInstance().fetchZoomableStroke(f));
            }
            g2DWrapper.setColor(this.theme.getGridColor());
            for (d3 = d4; d3 < (double)dimension.width; d3 += d4) {
                g2DWrapper.draw(new Line2D.Double(d3, 0.0, d3, dimension.height - 1));
            }
            for (d3 = d4; d3 < (double)dimension.height; d3 += d4) {
                g2DWrapper.draw(new Line2D.Double(0.0, d3, dimension.width - 1, d3));
            }
        }
        Rectangle2D.Double double_ = null;
        AffineTransform affineTransform = null;
        double d5 = 0.0;
        if (set.contains((Object)DrawOption.EXTRA_SPACE)) {
            iterator = this.getCanvasDimensions(project, d2, false);
            d5 = this.getExtraSpace(project) * d2;
            float f = (float)(3.0 * (d2 > 1.0 ? 1.0 : d2));
            graphics2D.setStroke(ObjectCache.getInstance().fetchStroke(f, new float[]{f * 4.0f, f * 4.0f}, 0.0f, 0));
            g2DWrapper.setColor(this.theme.getOutlineColor());
            double_ = new Rectangle2D.Double(d5, d5, ((Dimension)((Object)iterator)).getWidth(), ((Dimension)((Object)iterator)).getHeight());
            graphics2D.draw(double_);
            affineTransform = graphics2D.getTransform();
            graphics2D.transform(AffineTransform.getTranslateInstance(d5, d5));
        }
        if (Math.abs(1.0 - d2) > 1.0E-4) {
            g2DWrapper.scale(d2, d2);
        }
        for (IDIYComponent iDIYComponent : project.getComponents()) {
            if (iComponentFiler != null && !iComponentFiler.testComponent(iDIYComponent)) continue;
            ComponentState componentState = ComponentState.NORMAL;
            if (set.contains((Object)DrawOption.SELECTION) && collection.contains(iDIYComponent)) {
                componentState = bl ? ComponentState.DRAGGING : ComponentState.SELECTED;
            }
            boolean bl2 = this.lastDrawnStateMap.get(iDIYComponent) != componentState;
            object = graphics2D;
            synchronized (object) {
                g2DWrapper.startedDrawingComponent();
                if (!bl2) {
                    g2DWrapper.stopTracking();
                }
                if (set2.contains(iDIYComponent)) {
                    graphics2D.setComposite(this.lockedComposite);
                }
                try {
                    iDIYComponent.draw(g2DWrapper, componentState, set.contains((Object)DrawOption.OUTLINE_MODE), project, g2DWrapper);
                    if (g2DWrapper.isTrackingContinuityArea()) {
                        LOG.info((Object)("Component " + iDIYComponent.getName() + " of type " + iDIYComponent.getClass().getName() + " did not stop tracking continuity area."));
                        g2DWrapper.stopTrackingContinuityArea();
                    }
                }
                catch (Exception exception) {
                    LOG.error((Object)("Error drawing " + iDIYComponent.getName()), (Throwable)exception);
                    this.failedComponents.add(iDIYComponent);
                }
                ComponentArea componentArea = g2DWrapper.finishedDrawingComponent();
                if (bl2 && componentArea != null && !componentArea.getOutlineArea().isEmpty()) {
                    this.componentAreaMap.put(iDIYComponent, componentArea);
                    this.lastDrawnStateMap.put(iDIYComponent, componentState);
                }
            }
        }
        if (set.contains((Object)DrawOption.CONTROL_POINTS)) {
            if (bl || set.contains((Object)DrawOption.OUTLINE_MODE)) {
                for (IDIYComponent iDIYComponent : project.getComponents()) {
                    for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                        VisibilityPolicy visibilityPolicy = iDIYComponent.getControlPointVisibilityPolicy(i);
                        if ((!set3.contains(iDIYComponent) || visibilityPolicy != VisibilityPolicy.ALWAYS && (!collection.contains(iDIYComponent) || visibilityPolicy != VisibilityPolicy.WHEN_SELECTED)) && (set3.contains(iDIYComponent) || collection.contains(iDIYComponent) || iDIYComponent.getControlPointVisibilityPolicy(i) != VisibilityPolicy.ALWAYS)) continue;
                        g2DWrapper.setColor(CONTROL_POINT_COLOR);
                        object = iDIYComponent.getControlPoint(i);
                        int n = CONTROL_POINT_SIZE - 2;
                        g2DWrapper.fillOval(((Point)object).x - n / 2, ((Point)object).y - n / 2, n, n);
                    }
                }
            }
            for (IDIYComponent iDIYComponent : collection) {
                for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                    if (set3.contains(iDIYComponent) || iDIYComponent.getControlPointVisibilityPolicy(i) != VisibilityPolicy.WHEN_SELECTED && iDIYComponent.getControlPointVisibilityPolicy(i) != VisibilityPolicy.ALWAYS) continue;
                    Point point = iDIYComponent.getControlPoint(i);
                    int n = CONTROL_POINT_SIZE;
                    g2DWrapper.setColor(SELECTED_CONTROL_POINT_COLOR.darker());
                    g2DWrapper.fillOval(point.x - n / 2, point.y - n / 2, n, n);
                    g2DWrapper.setColor(SELECTED_CONTROL_POINT_COLOR);
                    g2DWrapper.fillOval(point.x - CONTROL_POINT_SIZE / 2 + 1, point.y - CONTROL_POINT_SIZE / 2 + 1, CONTROL_POINT_SIZE - 2, CONTROL_POINT_SIZE - 2);
                }
            }
        }
        if (list2 != null) {
            g2DWrapper.startedDrawingComponent();
            g2DWrapper.setComposite(this.slotComposite);
            for (IDIYComponent iDIYComponent : list2) {
                try {
                    iDIYComponent.draw(g2DWrapper, ComponentState.NORMAL, set.contains((Object)DrawOption.OUTLINE_MODE), project, g2DWrapper);
                }
                catch (Exception exception) {
                    LOG.error((Object)("Error drawing " + iDIYComponent.getName()), (Throwable)exception);
                    this.failedComponents.add(iDIYComponent);
                }
            }
            g2DWrapper.finishedDrawingComponent();
        }
        if (list != null) {
            for (Point point : list) {
                if (point == null) continue;
                g2DWrapper.setColor(SELECTED_CONTROL_POINT_COLOR.darker());
                g2DWrapper.fillOval(point.x - CONTROL_POINT_SIZE / 2, point.y - CONTROL_POINT_SIZE / 2, CONTROL_POINT_SIZE, CONTROL_POINT_SIZE);
                g2DWrapper.setColor(SELECTED_CONTROL_POINT_COLOR);
                g2DWrapper.fillOval(point.x - CONTROL_POINT_SIZE / 2 + 1, point.y - CONTROL_POINT_SIZE / 2 + 1, CONTROL_POINT_SIZE - 2, CONTROL_POINT_SIZE - 2);
            }
        }
        if (set.contains((Object)DrawOption.SELECTION) && rectangle != null) {
            graphics2D.setColor(Color.white);
            graphics2D.draw(rectangle);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(Constants.DASHED_STROKE);
            graphics2D.draw(rectangle);
        }
        if (this.debugComponentAreas) {
            graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
            graphics2D.setColor(Color.red);
            for (ComponentArea componentArea : this.componentAreaMap.values()) {
                graphics2D.draw(componentArea.getOutlineArea());
            }
        }
        if (this.debugContinuityAreas) {
            graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
            graphics2D.setColor(Color.green);
            for (ComponentArea componentArea : this.componentAreaMap.values()) {
                for (Area area : componentArea.getContinuityPositiveAreas()) {
                    graphics2D.draw(area);
                }
            }
            graphics2D.setColor(Color.blue);
            for (ComponentArea componentArea : this.componentAreaMap.values()) {
                for (Area area : componentArea.getContinuityNegativeAreas()) {
                    graphics2D.draw(area);
                }
            }
        }
        if (this.continuityArea != null && ConfigurationManager.getInstance().readBoolean("highlightContinuityArea", false)) {
            iterator = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            graphics2D.setColor(Color.green);
            graphics2D.fill(this.continuityArea);
            graphics2D.setComposite((Composite)((Object)iterator));
        }
        if (SHADE_EXTRA_SPACE && double_ != null) {
            iterator = new Area(new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight()));
            ((Area)((Object)iterator)).subtract(new Area(double_));
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.05f));
            graphics2D.setTransform(affineTransform);
            graphics2D.setColor(this.theme.getOutlineColor());
            graphics2D.fill((Shape)((Object)iterator));
        }
        return this.failedComponents;
    }

    public double getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(double d) {
        this.zoomLevel = d;
        this.fireZoomChanged();
    }

    public void invalidateComponent(IDIYComponent<?> iDIYComponent) {
        this.componentAreaMap.remove(iDIYComponent);
        this.lastDrawnStateMap.remove(iDIYComponent);
    }

    public ComponentArea getComponentArea(IDIYComponent<?> iDIYComponent) {
        return this.componentAreaMap.get(iDIYComponent);
    }

    public void clearComponentAreaMap() {
        this.componentAreaMap.clear();
        this.lastDrawnStateMap.clear();
    }

    public void clearContinuityArea() {
        this.continuityArea = null;
    }

    public List<IDIYComponent<?>> findComponentsAt(Point point, Project project) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < project.getComponents().size(); ++i) {
            ComponentArea componentArea = this.componentAreaMap.get(project.getComponents().get(i));
            if (componentArea == null || !componentArea.getOutlineArea().contains(point)) continue;
            arrayList.add(0, project.getComponents().get(i));
        }
        return arrayList;
    }

    public double getExtraSpace(Project project) {
        double d = project.getWidth().convertToPixels();
        double d2 = project.getHeight().convertToPixels();
        double d3 = EXTRA_SPACE * Math.max(d, d2);
        return CalcUtils.roundToGrid(d3, project.getGridSpacing());
    }

    public Dimension getCanvasDimensions(Project project, Double d, boolean bl) {
        double d2 = project.getWidth().convertToPixels();
        double d3 = project.getHeight().convertToPixels();
        if (bl) {
            double d4 = this.getExtraSpace(project);
            d2 += 2.0 * d4;
            d3 += 2.0 * d4;
        }
        return new Dimension((int)(d2 *= d.doubleValue()), (int)(d3 *= d.doubleValue()));
    }

    public void fireZoomChanged() {
        this.messageDispatcher.dispatchMessage((Enum)EventType.ZOOM_CHANGED, new Object[]{this.zoomLevel});
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        ConfigurationManager.getInstance().writeValue("theme", (Object)theme);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    public void findContinuityAreaAtPoint(Project project, Point point) {
        List<Area> list = this.getContinuityAreas(project);
        for (Area area : list) {
            if (!area.contains(point)) continue;
            this.continuityArea = area;
            return;
        }
        this.continuityArea = null;
    }

    public List<Area> getContinuityAreas(Project project) {
        Object object;
        ArrayList<Area> arrayList = new ArrayList<Area>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        HashSet<Connection> hashSet = new HashSet<Connection>();
        for (IDIYComponent<?> iDIYComponent : project.getComponents()) {
            object = this.getComponentArea(iDIYComponent);
            if (iDIYComponent instanceof IContinuity) {
                for (int i = 0; i < iDIYComponent.getControlPointCount() - 1; ++i) {
                    for (int j = i + 1; j < iDIYComponent.getControlPointCount(); ++j) {
                        if (!((IContinuity)((Object)iDIYComponent)).arePointsConnected(i, j)) continue;
                        hashSet.add(new Connection(iDIYComponent.getControlPoint(i), iDIYComponent.getControlPoint(j)));
                    }
                }
            }
            if (object == null || ((ComponentArea)object).getOutlineArea() == null) continue;
            if (((ComponentArea)object).getContinuityPositiveAreas() != null) {
                for (Area area : ((ComponentArea)object).getContinuityPositiveAreas()) {
                    arrayList.add(area);
                    arrayList2.add(false);
                }
            }
            if (((ComponentArea)object).getContinuityNegativeAreas() == null) continue;
            for (Area area : ((ComponentArea)object).getContinuityNegativeAreas()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Area area2 = (Area)arrayList.get(i);
                    if (!area2.intersects(area.getBounds2D())) continue;
                    area2.subtract(area);
                    arrayList2.set(i, true);
                }
            }
        }
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (Area)arrayList.get(i);
            arrayList3.addAll(this.tryBreakout((Area)object));
        }
        this.expandConnections(hashSet);
        this.crunchAreas(arrayList3, hashSet);
        return arrayList3;
    }

    public void expandConnections(Set<Connection> set) {
        HashSet<Connection> hashSet = new HashSet<Connection>();
        for (Connection connection : set) {
            for (Connection connection2 : set) {
                if (connection == connection2) continue;
                if (connection.getP1().distance(connection2.getP1()) < (double)CONTROL_POINT_SIZE) {
                    hashSet.add(new Connection(connection.getP2(), connection2.getP2()));
                }
                if (connection.getP1().distance(connection2.getP2()) < (double)CONTROL_POINT_SIZE) {
                    hashSet.add(new Connection(connection.getP2(), connection2.getP1()));
                }
                if (connection.getP2().distance(connection2.getP1()) < (double)CONTROL_POINT_SIZE) {
                    hashSet.add(new Connection(connection.getP1(), connection2.getP2()));
                }
                if (!(connection.getP2().distance(connection2.getP2()) < (double)CONTROL_POINT_SIZE)) continue;
                hashSet.add(new Connection(connection.getP1(), connection2.getP1()));
            }
        }
        if (set.addAll(hashSet)) {
            this.expandConnections(set);
        }
    }

    private boolean crunchAreas(List<Area> list, Set<Connection> set) {
        int n;
        boolean bl = false;
        ArrayList<Area> arrayList = new ArrayList<Area>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        for (n = 0; n < list.size(); ++n) {
            arrayList2.add(false);
        }
        for (n = 0; n < list.size(); ++n) {
            block2: for (int i = n + 1; i < list.size(); ++i) {
                if (((Boolean)arrayList2.get(i)).booleanValue()) continue;
                Area area = list.get(n);
                Area area2 = list.get(i);
                Area area3 = null;
                if (area.getBounds2D().intersects(area2.getBounds())) {
                    area3 = new Area(area);
                    area3.intersect(area2);
                }
                if (area3 != null && !area3.isEmpty()) {
                    area.add(area2);
                    arrayList2.set(i, true);
                    continue;
                }
                for (Connection connection : set) {
                    if ((!area.getBounds().contains(connection.getP1()) || !area2.getBounds().contains(connection.getP2()) || !area.contains(connection.getP1()) || !area2.contains(connection.getP2())) && (!area.getBounds().contains(connection.getP2()) || !area2.getBounds().contains(connection.getP1()) || !area.contains(connection.getP2()) || !area2.contains(connection.getP1()))) continue;
                    area.add(area2);
                    arrayList2.set(i, true);
                    continue block2;
                }
            }
        }
        for (n = 0; n < list.size(); ++n) {
            if (!((Boolean)arrayList2.get(n)).booleanValue()) {
                arrayList.add(list.get(n));
                continue;
            }
            bl = true;
        }
        if (bl) {
            list.clear();
            list.addAll(arrayList);
            this.crunchAreas(list, set);
        }
        return bl;
    }

    private List<Area> tryBreakout(Area area) {
        Object object;
        ArrayList<Area> arrayList = new ArrayList<Area>();
        Path2D.Double double_ = null;
        PathIterator pathIterator = area.getPathIterator(null);
        while (!pathIterator.isDone()) {
            object = new double[6];
            int n = pathIterator.currentSegment((double[])object);
            switch (n) {
                case 0: {
                    if (double_ != null) {
                        Area area2 = new Area(double_);
                        arrayList.add(area2);
                    }
                    double_ = new Path2D.Double();
                    ((Path2D)double_).moveTo(object[0], object[1]);
                    break;
                }
                case 1: {
                    ((Path2D)double_).lineTo(object[0], object[1]);
                    break;
                }
                case 3: {
                    ((Path2D)double_).curveTo(object[0], object[1], object[2], object[3], object[4], object[5]);
                    break;
                }
                case 2: {
                    ((Path2D)double_).quadTo(object[0], object[1], object[2], object[3]);
                }
            }
            pathIterator.next();
        }
        if (double_ != null) {
            object = new Area(double_);
            arrayList.add((Area)object);
        }
        return arrayList;
    }
}

