/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.diylc.core.IPropertyValidator;

public class PropertyWrapper
implements Cloneable {
    private String name;
    private Class<?> type;
    private Object value;
    private String setter;
    private String getter;
    private boolean defaultable;
    private IPropertyValidator validator;
    private boolean unique = true;
    private boolean changed = false;
    private int sortOrder;
    private Object ownerObject;

    public PropertyWrapper(String string, Class<?> clazz, String string2, String string3, boolean bl, IPropertyValidator iPropertyValidator, int n) {
        this.name = string;
        this.type = clazz;
        this.getter = string2;
        this.setter = string3;
        this.defaultable = bl;
        this.validator = iPropertyValidator;
        this.sortOrder = n;
        this.ownerObject = null;
    }

    public void readFrom(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        this.ownerObject = object;
        this.value = this.getGetter().invoke(object, new Object[0]);
    }

    public void writeTo(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        object.getClass().getMethod(this.setter, this.type).invoke(object, this.value);
    }

    public Method getGetter() throws SecurityException, NoSuchMethodException {
        return this.getOwnerObject().getClass().getMethod(this.getter, new Class[0]);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Object getOwnerObject() {
        return this.ownerObject;
    }

    public boolean isDefaultable() {
        return this.defaultable;
    }

    public IPropertyValidator getValidator() {
        return this.validator;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public Object clone() throws CloneNotSupportedException {
        PropertyWrapper propertyWrapper = new PropertyWrapper(this.name, this.type, this.getter, this.setter, this.defaultable, this.validator, this.sortOrder);
        propertyWrapper.value = this.value;
        propertyWrapper.changed = this.changed;
        propertyWrapper.unique = this.unique;
        return propertyWrapper;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.defaultable ? 1231 : 1237);
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.setter == null ? 0 : this.setter.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PropertyWrapper propertyWrapper = (PropertyWrapper)object;
        if (this.defaultable != propertyWrapper.defaultable) {
            return false;
        }
        if (this.getter == null ? propertyWrapper.getter != null : !this.getter.equals(propertyWrapper.getter)) {
            return false;
        }
        if (this.name == null ? propertyWrapper.name != null : !this.name.equals(propertyWrapper.name)) {
            return false;
        }
        if (this.setter == null ? propertyWrapper.setter != null : !this.setter.equals(propertyWrapper.setter)) {
            return false;
        }
        return !(this.type == null ? propertyWrapper.type != null : !this.type.equals(propertyWrapper.type));
    }

    public String toString() {
        return this.name + " = " + this.value;
    }
}

