/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.cloud.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.diylc.common.DrawOption;
import org.diylc.common.IPlugInPort;
import org.diylc.common.PropertyWrapper;
import org.diylc.swing.gui.components.HTMLTextArea;
import org.diylc.swingframework.ButtonDialog;
import org.diylc.utils.KeywordExtractor;

public class UploadDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    private static final String BULLET = "&nbsp;&nbsp;&nbsp;&#8226;&nbsp;";
    private static final String TERMS_HTML = "<html>&nbsp;&nbsp;&nbsp;&#8226;&nbsp;All content uploaded to DIY Cloud is shared under Creative Commons 3.0 Licence.<br>&nbsp;&nbsp;&nbsp;&#8226;&nbsp;Only finished and resonably verified projects may be uploaded to the DIY Cloud.<br>&nbsp;&nbsp;&nbsp;&#8226;&nbsp;Please provide a meaningful project description to make it possible for others to find the project.<br>&nbsp;&nbsp;&nbsp;&#8226;&nbsp;If you are building on top of someone else's work, please leave credits in the description.<br>&nbsp;&nbsp;&nbsp;&#8226;&nbsp;Uploaded content may be reviewed, edited and removed by the administrators if it is not up to standards.<br></html>";
    private JPanel mainPanel;
    private JLabel termsLabel;
    private JCheckBox agreeBox;
    private JPanel thumbnailPanel;
    private JTextField nameField;
    private JComboBox categoryBox;
    private JScrollPane descriptionPane;
    private JTextArea descriptionArea;
    private JTextField keywordsField;
    private IPlugInPort plugInPort;
    private String[] categories;

    public UploadDialog(JFrame jFrame, IPlugInPort iPlugInPort, String[] stringArray, boolean bl) {
        super(jFrame, bl ? "Re-Upload A Project" : "Upload A Project", new String[]{"OK", "Cancel"});
        this.plugInPort = iPlugInPort;
        this.categories = stringArray;
        this.layoutGui();
        this.getButton("OK").setEnabled(false);
    }

    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 4;
            this.mainPanel.add((Component)this.getThumbnailPanel(), gridBagConstraints);
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 2, 2);
            gridBagConstraints.fill = 2;
            this.mainPanel.add((Component)new JLabel("Project Name: "), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.mainPanel.add((Component)new JLabel("Category:"), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.mainPanel.add((Component)new JLabel("Description: "), gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.mainPanel.add((Component)new JLabel("Keywords: "), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.mainPanel.add((Component)this.getNameField(), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.mainPanel.add((Component)this.getCategoryBox(), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.mainPanel.add((Component)this.getDescriptionPane(), gridBagConstraints);
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.mainPanel.add((Component)this.getKeywordsField(), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            this.mainPanel.add((Component)this.getTermsLabel(), gridBagConstraints);
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.mainPanel.add((Component)this.getAgreeBox(), gridBagConstraints);
        }
        return this.mainPanel;
    }

    private JCheckBox getAgreeBox() {
        if (this.agreeBox == null) {
            this.agreeBox = new JCheckBox("I agree to these terms");
            this.agreeBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    UploadDialog.this.getButton("OK").setEnabled(UploadDialog.this.getAgreeBox().isSelected());
                }
            });
        }
        return this.agreeBox;
    }

    private JLabel getTermsLabel() {
        if (this.termsLabel == null) {
            this.termsLabel = new JLabel();
            this.termsLabel.setOpaque(true);
            this.termsLabel.setBackground(UIManager.getColor("ToolTip.background"));
            this.termsLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.termsLabel.setText(TERMS_HTML);
        }
        return this.termsLabel;
    }

    private JPanel getThumbnailPanel() {
        if (this.thumbnailPanel == null) {
            this.thumbnailPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 21;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.thumbnailPanel.add((Component)new JComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    UploadDialog.this.paintThumbnail(graphics, this.getBounds());
                }
            }, gridBagConstraints);
            this.thumbnailPanel.setPreferredSize(this.getThumbnailSize());
            this.thumbnailPanel.setBorder(BorderFactory.createEtchedBorder());
        }
        return this.thumbnailPanel;
    }

    private Dimension getThumbnailSize() {
        Dimension dimension = this.plugInPort.getCanvasDimensions(false, false);
        if (dimension.height > dimension.width) {
            return new Dimension(192 * dimension.width / dimension.height, 192);
        }
        return new Dimension(192, 192 * dimension.height / dimension.width);
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
            List list = this.plugInPort.getProperties((Object)this.plugInPort.getCurrentProject());
            for (int i = 0; i < list.size(); ++i) {
                if (!((PropertyWrapper)list.get(i)).getName().equals("Title")) continue;
                this.nameField.setText(((PropertyWrapper)list.get(i)).getValue().toString());
            }
        }
        return this.nameField;
    }

    private JComboBox getCategoryBox() {
        if (this.categoryBox == null) {
            this.categoryBox = new JComboBox<String>(this.categories);
        }
        return this.categoryBox;
    }

    private JScrollPane getDescriptionPane() {
        if (this.descriptionPane == null) {
            this.descriptionPane = new JScrollPane(this.getDescriptionArea());
            this.descriptionPane.setBorder(this.getNameField().getBorder());
            this.descriptionPane.setPreferredSize(new Dimension(1, 128));
        }
        return this.descriptionPane;
    }

    private JTextArea getDescriptionArea() {
        if (this.descriptionArea == null) {
            this.descriptionArea = new HTMLTextArea();
            List list = this.plugInPort.getProperties((Object)this.plugInPort.getCurrentProject());
            for (int i = 0; i < list.size(); ++i) {
                if (!((PropertyWrapper)list.get(i)).getName().equals("Description")) continue;
                try {
                    this.descriptionArea.setText(((PropertyWrapper)list.get(i)).getValue().toString());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.descriptionArea.setBorder(null);
            this.descriptionArea.setFont(this.getNameField().getFont());
        }
        return this.descriptionArea;
    }

    private JTextField getKeywordsField() {
        if (this.keywordsField == null) {
            this.keywordsField = new JTextField();
            this.keywordsField.setColumns(32);
            this.keywordsField.setText(KeywordExtractor.getInstance().extractKeywords(this.plugInPort.getCurrentProject()));
        }
        return this.keywordsField;
    }

    public String getName() {
        return this.getNameField().getText();
    }

    public String getDescription() {
        return this.getDescriptionArea().getText();
    }

    public String getCategory() {
        return this.getCategoryBox().getSelectedItem().toString();
    }

    public BufferedImage getThumbnail() {
        Dimension dimension = this.getThumbnailSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.paintThumbnail(graphics2D, new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
        return bufferedImage;
    }

    private void paintThumbnail(Graphics graphics, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.plugInPort.getCanvasDimensions(false, false);
        graphics2D.setColor(Color.white);
        graphics2D.fill(rectangle);
        double d = dimension.getWidth() / dimension.getHeight();
        double d2 = rectangle.getWidth() / rectangle.getHeight();
        double d3 = d > d2 ? rectangle.getWidth() / dimension.getWidth() : rectangle.getHeight() / dimension.getHeight();
        this.plugInPort.draw(graphics2D, EnumSet.of(DrawOption.ANTIALIASING), null, Double.valueOf(d3));
    }

    public String getKeywords() {
        return this.getKeywordsField().getText();
    }
}

