/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.BuildingBlockPackage;
import org.diylc.common.ComponentType;
import org.diylc.common.INetlistAnalyzer;
import org.diylc.common.IPlugInPort;
import org.diylc.common.ITask;
import org.diylc.common.PropertyWrapper;
import org.diylc.common.VariantPackage;
import org.diylc.core.ExpansionMode;
import org.diylc.core.IDIYComponent;
import org.diylc.core.IView;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.measures.Nudge;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.images.IconLoader;
import org.diylc.netlist.Group;
import org.diylc.netlist.Netlist;
import org.diylc.netlist.Summary;
import org.diylc.presenter.Presenter;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.gui.DialogFactory;
import org.diylc.swing.gui.editor.PropertyEditorDialog;
import org.diylc.swing.plugins.edit.ComponentTransferable;
import org.diylc.swing.plugins.file.BomDialog;
import org.diylc.swing.plugins.file.FileFilterEnum;
import org.diylc.swingframework.CheckBoxListDialog;
import org.diylc.swingframework.IDrawingProvider;
import org.diylc.swingframework.export.DrawingExporter;
import org.diylc.swingframework.text.TextDialog;
import org.diylc.utils.BomMaker;

public class ActionFactory {
    private static final Logger LOG = Logger.getLogger(ActionFactory.class);
    private static ActionFactory instance;

    public static ActionFactory getInstance() {
        if (instance == null) {
            instance = new ActionFactory();
        }
        return instance;
    }

    private ActionFactory() {
    }

    public NewAction createNewAction(IPlugInPort iPlugInPort) {
        return new NewAction(iPlugInPort);
    }

    public OpenAction createOpenAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
        return new OpenAction(iPlugInPort, iSwingUI);
    }

    public ImportAction createImportAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
        return new ImportAction(iPlugInPort, iSwingUI);
    }

    public SaveAction createSaveAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
        return new SaveAction(iPlugInPort, iSwingUI);
    }

    public SaveAsAction createSaveAsAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
        return new SaveAsAction(iPlugInPort, iSwingUI);
    }

    public CreateBomAction createBomAction(IPlugInPort iPlugInPort) {
        return new CreateBomAction(iPlugInPort);
    }

    public ExportPDFAction createExportPDFAction(IPlugInPort iPlugInPort, IDrawingProvider iDrawingProvider, ISwingUI iSwingUI, String string) {
        return new ExportPDFAction(iPlugInPort, iDrawingProvider, iSwingUI, string);
    }

    public ExportPNGAction createExportPNGAction(IPlugInPort iPlugInPort, IDrawingProvider iDrawingProvider, ISwingUI iSwingUI, String string) {
        return new ExportPNGAction(iPlugInPort, iDrawingProvider, iSwingUI, string);
    }

    public PrintAction createPrintAction(IDrawingProvider iDrawingProvider, int n) {
        return new PrintAction(iDrawingProvider, n);
    }

    public ExportVariantsAction createExportVariantsAction(ISwingUI iSwingUI, IPlugInPort iPlugInPort) {
        return new ExportVariantsAction(iSwingUI, iPlugInPort);
    }

    public ImportVariantsAction createImportVariantsAction(ISwingUI iSwingUI, IPlugInPort iPlugInPort) {
        return new ImportVariantsAction(iSwingUI, iPlugInPort);
    }

    public ExportBlocksAction createExportBlocksAction(ISwingUI iSwingUI) {
        return new ExportBlocksAction(iSwingUI);
    }

    public ImportBlocksAction createImportBlocksAction(ISwingUI iSwingUI, IPlugInPort iPlugInPort) {
        return new ImportBlocksAction(iSwingUI, iPlugInPort);
    }

    public ExitAction createExitAction(IPlugInPort iPlugInPort) {
        return new ExitAction(iPlugInPort);
    }

    public CutAction createCutAction(IPlugInPort iPlugInPort, Clipboard clipboard, ClipboardOwner clipboardOwner) {
        return new CutAction(iPlugInPort, clipboard, clipboardOwner);
    }

    public CopyAction createCopyAction(IPlugInPort iPlugInPort, Clipboard clipboard, ClipboardOwner clipboardOwner) {
        return new CopyAction(iPlugInPort, clipboard, clipboardOwner);
    }

    public PasteAction createPasteAction(IPlugInPort iPlugInPort, Clipboard clipboard) {
        return new PasteAction(iPlugInPort, clipboard);
    }

    public DuplicateAction createDuplicateAction(IPlugInPort iPlugInPort) {
        return new DuplicateAction(iPlugInPort);
    }

    public SelectAllAction createSelectAllAction(IPlugInPort iPlugInPort) {
        return new SelectAllAction(iPlugInPort);
    }

    public GroupAction createGroupAction(IPlugInPort iPlugInPort) {
        return new GroupAction(iPlugInPort);
    }

    public UngroupAction createUngroupAction(IPlugInPort iPlugInPort) {
        return new UngroupAction(iPlugInPort);
    }

    public EditProjectAction createEditProjectAction(IPlugInPort iPlugInPort) {
        return new EditProjectAction(iPlugInPort);
    }

    public EditSelectionAction createEditSelectionAction(IPlugInPort iPlugInPort) {
        return new EditSelectionAction(iPlugInPort);
    }

    public DeleteSelectionAction createDeleteSelectionAction(IPlugInPort iPlugInPort) {
        return new DeleteSelectionAction(iPlugInPort);
    }

    public SaveAsTemplateAction createSaveAsTemplateAction(IPlugInPort iPlugInPort) {
        return new SaveAsTemplateAction(iPlugInPort);
    }

    public SaveAsBlockAction createSaveAsBlockAction(IPlugInPort iPlugInPort) {
        return new SaveAsBlockAction(iPlugInPort);
    }

    public ExpandSelectionAction createExpandSelectionAction(IPlugInPort iPlugInPort, ExpansionMode expansionMode) {
        return new ExpandSelectionAction(iPlugInPort, expansionMode);
    }

    public RotateSelectionAction createRotateSelectionAction(IPlugInPort iPlugInPort, int n) {
        return new RotateSelectionAction(iPlugInPort, n);
    }

    public MirrorSelectionAction createMirrorSelectionAction(IPlugInPort iPlugInPort, int n) {
        return new MirrorSelectionAction(iPlugInPort, n);
    }

    public SendToBackAction createSendToBackAction(IPlugInPort iPlugInPort) {
        return new SendToBackAction(iPlugInPort);
    }

    public BringToFrontAction createBringToFrontAction(IPlugInPort iPlugInPort) {
        return new BringToFrontAction(iPlugInPort);
    }

    public NudgeAction createNudgeAction(IPlugInPort iPlugInPort) {
        return new NudgeAction(iPlugInPort);
    }

    public ConfigAction createConfigAction(IPlugInPort iPlugInPort, String string, String string2, boolean bl) {
        return new ConfigAction(iPlugInPort, string, string2, bl);
    }

    public ConfigAction createConfigAction(IPlugInPort iPlugInPort, String string, String string2, boolean bl, String string3) {
        return new ConfigAction(iPlugInPort, string, string2, bl, string3);
    }

    public ThemeAction createThemeAction(IPlugInPort iPlugInPort, Theme theme) {
        return new ThemeAction(iPlugInPort, theme);
    }

    public ComponentBrowserAction createComponentBrowserAction(String string) {
        return new ComponentBrowserAction(string);
    }

    public RenumberAction createRenumberAction(IPlugInPort iPlugInPort, boolean bl) {
        return new RenumberAction(iPlugInPort, bl);
    }

    public GenerateNetlistAction createGenerateNetlistAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
        return new GenerateNetlistAction(iPlugInPort, iSwingUI);
    }

    public SummarizeNetlistAction createSummarizeNetlistAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI, INetlistAnalyzer iNetlistAnalyzer) {
        return new SummarizeNetlistAction(iPlugInPort, iSwingUI, iNetlistAnalyzer);
    }

    private static List<IDIYComponent<?>> cloneComponents(Collection<IDIYComponent<?>> collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        for (IDIYComponent<?> iDIYComponent : collection) {
            try {
                arrayList.add(iDIYComponent.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }
        return arrayList;
    }

    public static class SummarizeNetlistAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;
        private INetlistAnalyzer summarizer;

        public SummarizeNetlistAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI, INetlistAnalyzer iNetlistAnalyzer) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.summarizer = iNetlistAnalyzer;
            this.putValue("Name", iNetlistAnalyzer.getName());
            this.putValue("SmallIcon", Enum.valueOf(IconLoader.class, iNetlistAnalyzer.getIconName()).getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.swingUI.executeBackgroundTask(new ITask<List<Summary>>(){

                public List<Summary> doInBackground() throws Exception {
                    List list = SummarizeNetlistAction.this.plugInPort.extractNetlists(true);
                    if (list == null || list.isEmpty()) {
                        throw new Exception("The generated netlist is empty, nothing to show.");
                    }
                    return SummarizeNetlistAction.this.summarizer.summarize(list, null);
                }

                public void failed(Exception exception) {
                    SummarizeNetlistAction.this.swingUI.showMessage(exception.getMessage(), SummarizeNetlistAction.this.summarizer.getName(), 1);
                }

                public void complete(List<Summary> list) {
                    if (list == null) {
                        SummarizeNetlistAction.this.swingUI.showMessage("The generated summary is empty, nothing to show.", SummarizeNetlistAction.this.summarizer.getName(), 1);
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder("<html>");
                    for (Summary summary : list) {
                        stringBuilder.append("<p style=\"font-family: ").append(SummarizeNetlistAction.this.summarizer.getFontName()).append("; font-size: 9px\">");
                        if (list.size() > 1) {
                            stringBuilder.append("<b>Switch configuration: ").append(summary.getNetlist().getSwitchSetup()).append("</b><br><br>");
                        }
                        stringBuilder.append(summary.getSummary());
                        stringBuilder.append("</p><br>");
                        if (list.size() <= 1) continue;
                        stringBuilder.append("<hr>");
                    }
                    stringBuilder.append("</html>");
                    new TextDialog((JComponent)SummarizeNetlistAction.this.swingUI.getOwnerFrame().getRootPane(), stringBuilder.toString(), SummarizeNetlistAction.this.summarizer.getName(), new Dimension(600, 480)).setVisible(true);
                }
            }, true);
        }
    }

    public static class GenerateNetlistAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;

        public GenerateNetlistAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.putValue("Name", "Generate DIYLC Netlist");
            this.putValue("SmallIcon", IconLoader.Web.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.swingUI.executeBackgroundTask(new ITask<List<Netlist>>(){

                public List<Netlist> doInBackground() throws Exception {
                    return GenerateNetlistAction.this.plugInPort.extractNetlists(true);
                }

                public void failed(Exception exception) {
                    GenerateNetlistAction.this.swingUI.showMessage("Failed to generate the netlist: " + exception.getMessage(), "DIYLC Netlist", 1);
                }

                public void complete(List<Netlist> list) {
                    if (list == null) {
                        GenerateNetlistAction.this.swingUI.showMessage("The generated netlist is empty, nothing to show.", "DIYLC Netlist", 1);
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder("<html>");
                    for (Netlist netlist : list) {
                        stringBuilder.append("<p style=\"font-family: " + new JLabel().getFont().getName() + "; font-size: 9px\"><b>Switch configuration: ").append(netlist.getSwitchSetup()).append("</b><br><br>Connected node groups:<br>");
                        for (Group group : netlist.getSortedGroups()) {
                            stringBuilder.append("&nbsp;&nbsp;").append(group.getSortedNodes()).append("<br>");
                        }
                        stringBuilder.append("</p><br><hr>");
                    }
                    stringBuilder.append("</html>");
                    new TextDialog((JComponent)GenerateNetlistAction.this.swingUI.getOwnerFrame().getRootPane(), stringBuilder.toString(), "DIYLC Netlist", new Dimension(600, 480)).setVisible(true);
                }
            }, true);
        }
    }

    public static class RenumberAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private boolean xAxisFirst;

        public RenumberAction(IPlugInPort iPlugInPort, boolean bl) {
            this.plugInPort = iPlugInPort;
            this.xAxisFirst = bl;
            this.putValue("Name", bl ? "Top-to-Bottom" : "Left-to-Right");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)(this.getValue("Name") + " triggered"));
            this.plugInPort.renumberSelectedComponents(this.xAxisFirst);
        }
    }

    public static class ComponentBrowserAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private String browserType;

        public ComponentBrowserAction(String string) {
            this.browserType = string;
            this.putValue("Name", string);
            this.putValue("org.diylc.radioButtonGroup", "componentBrowser");
            this.putValue("SwingSelectedKey", string.equals(ConfigurationManager.getInstance().readString("componentBrowser", "Searchable Tree")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)(this.getValue("Name") + " triggered"));
            ConfigurationManager.getInstance().writeValue("componentBrowser", this.browserType);
        }
    }

    public static class ThemeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private Theme theme;

        public ThemeAction(IPlugInPort iPlugInPort, Theme theme) {
            this.plugInPort = iPlugInPort;
            this.theme = theme;
            this.putValue("Name", theme.getName());
            this.putValue("org.diylc.radioButtonGroup", "theme");
            this.putValue("SwingSelectedKey", iPlugInPort.getSelectedTheme().getName().equals(theme.getName()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)(this.getValue("Name") + " triggered"));
            this.plugInPort.setSelectedTheme(this.theme);
        }
    }

    public static class ConfigAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private String configKey;
        private String tipKey;

        public ConfigAction(IPlugInPort iPlugInPort, String string, String string2, boolean bl, String string3) {
            this.plugInPort = iPlugInPort;
            this.configKey = string2;
            this.tipKey = string3;
            this.putValue("Name", string);
            this.putValue("org.diylc.checkBoxMenuItem", true);
            this.putValue("SwingSelectedKey", ConfigurationManager.getInstance().readBoolean(string2, bl));
        }

        public ConfigAction(IPlugInPort iPlugInPort, String string, String string2, boolean bl) {
            this(iPlugInPort, string, string2, bl, null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)(this.getValue("Name") + " triggered"));
            ConfigurationManager.getInstance().writeValue(this.configKey, this.getValue("SwingSelectedKey"));
            if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue() && this.tipKey != null && !ConfigurationManager.getInstance().readBoolean(this.tipKey + ".dismissed", false)) {
                DialogFactory.getInstance().createInfoDialog(this.tipKey).setVisible(true);
            }
            this.plugInPort.refresh();
        }
    }

    public static class BringToFrontAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public BringToFrontAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Bring Forward");
            this.putValue("SmallIcon", IconLoader.Front.getIcon());
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 8));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Bring to Front triggered");
            this.plugInPort.bringSelectionToFront();
        }
    }

    public static class SendToBackAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public SendToBackAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Send Backward");
            this.putValue("SmallIcon", IconLoader.Back.getIcon());
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 8));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Send to Back triggered");
            this.plugInPort.sendSelectionToBack();
        }
    }

    public static class MirrorSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private int direction;

        public MirrorSelectionAction(IPlugInPort iPlugInPort, int n) {
            this.plugInPort = iPlugInPort;
            this.direction = n;
            if (n == 0) {
                this.putValue("Name", "Mirror Horizontally");
                this.putValue("SmallIcon", IconLoader.FlipHorizontal.getIcon());
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, 8));
            } else {
                this.putValue("Name", "Mirror Vertically");
                this.putValue("SmallIcon", IconLoader.FlipVertical.getIcon());
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 8));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)("Mirror Selection triggered: " + this.direction));
            this.plugInPort.mirrorSelection(this.direction);
        }
    }

    public static class RotateSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private int direction;

        public RotateSelectionAction(IPlugInPort iPlugInPort, int n) {
            this.plugInPort = iPlugInPort;
            this.direction = n;
            if (n > 0) {
                this.putValue("Name", "Rotate Clockwise");
                this.putValue("SmallIcon", IconLoader.RotateCW.getIcon());
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 8));
            } else {
                this.putValue("Name", "Rotate Counterclockwise");
                this.putValue("SmallIcon", IconLoader.RotateCCW.getIcon());
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 8));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)("Rotate Selection triggered: " + this.direction));
            this.plugInPort.rotateSelection(this.direction);
        }
    }

    public static class ExpandSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ExpansionMode expansionMode;

        public ExpandSelectionAction(IPlugInPort iPlugInPort, ExpansionMode expansionMode) {
            this.plugInPort = iPlugInPort;
            this.expansionMode = expansionMode;
            switch (expansionMode) {
                case ALL: {
                    this.putValue("Name", "All Connected");
                    break;
                }
                case IMMEDIATE: {
                    this.putValue("Name", "Immediate Only");
                    break;
                }
                case SAME_TYPE: {
                    this.putValue("Name", "Same Type Only");
                    break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)("Expand Selection triggered: " + this.expansionMode));
            this.plugInPort.expandSelection(this.expansionMode);
        }
    }

    public static class SaveAsBlockAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public SaveAsBlockAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Save as Building Block");
            this.putValue("SmallIcon", IconLoader.ComponentAdd.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Save as building block triggered");
            String string = JOptionPane.showInputDialog(null, "Block name:", "Save as Building Block", -1);
            if (string != null && !string.trim().isEmpty()) {
                this.plugInPort.saveSelectionAsBlock(string);
            }
        }
    }

    public static class SaveAsTemplateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public SaveAsTemplateAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Save as Variant");
            this.putValue("SmallIcon", IconLoader.BriefcaseAdd.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Save as template triggered");
            String string = JOptionPane.showInputDialog(null, "Variant name:", "Save as Variant", -1);
            if (string != null && !string.trim().isEmpty()) {
                this.plugInPort.saveSelectedComponentAsVariant(string);
            }
        }
    }

    public static class DeleteSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public DeleteSelectionAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Delete Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.putValue("SmallIcon", IconLoader.Delete.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Delete Selection triggered");
            this.plugInPort.deleteSelectedComponents();
        }
    }

    public static class EditSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public EditSelectionAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Edit Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.EditComponent.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Edit Selection triggered");
            List list = this.plugInPort.getMutualSelectionProperties();
            if (list == null || list.isEmpty()) {
                LOG.info((Object)"Nothing to edit");
                return;
            }
            this.plugInPort.editSelection();
        }
    }

    public static class NudgeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public NudgeAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Nudge");
            this.putValue("SmallIcon", IconLoader.FitToSize.getIcon());
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Nudge triggered");
            Nudge nudge = new Nudge();
            boolean bl = ConfigurationManager.getInstance().readBoolean("metric", true);
            if (bl) {
                nudge.setxOffset(new Size(Double.valueOf(0.0), SizeUnit.mm));
                nudge.setyOffset(new Size(Double.valueOf(0.0), SizeUnit.mm));
            } else {
                nudge.setxOffset(new Size(Double.valueOf(0.0), SizeUnit.in));
                nudge.setyOffset(new Size(Double.valueOf(0.0), SizeUnit.in));
            }
            List list = this.plugInPort.getProperties((Object)nudge);
            PropertyEditorDialog propertyEditorDialog = DialogFactory.getInstance().createPropertyEditorDialog(list, "Nudge Selection", false);
            propertyEditorDialog.setVisible(true);
            if ("OK".equals(propertyEditorDialog.getSelectedButtonCaption())) {
                this.plugInPort.applyProperties((Object)nudge, list);
                this.plugInPort.nudgeSelection(nudge.getxOffset(), nudge.getyOffset(), nudge.getAffectStuckComponents());
            }
        }
    }

    public static class EditProjectAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public EditProjectAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Edit Project Settings");
            this.putValue("SmallIcon", IconLoader.DocumentEdit.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Edit Project triggered");
            List list = this.plugInPort.getProperties((Object)this.plugInPort.getCurrentProject());
            PropertyEditorDialog propertyEditorDialog = DialogFactory.getInstance().createPropertyEditorDialog(list, "Edit Project", true);
            propertyEditorDialog.setVisible(true);
            if ("OK".equals(propertyEditorDialog.getSelectedButtonCaption())) {
                this.plugInPort.applyProperties((Object)this.plugInPort.getCurrentProject(), list);
            }
            for (PropertyWrapper propertyWrapper : propertyEditorDialog.getDefaultedProperties()) {
                if (propertyWrapper.getValue() == null) continue;
                this.plugInPort.setDefaultPropertyValue(Project.class, propertyWrapper.getName(), propertyWrapper.getValue());
            }
        }
    }

    public static class UngroupAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public UngroupAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Ungroup Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.Ungroup.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Ungroup Selection triggered");
            this.plugInPort.ungroupSelectedComponents();
        }
    }

    public static class GroupAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public GroupAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Group Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.Group.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Group Selection triggered");
            this.plugInPort.groupSelectedComponents();
        }
    }

    public static class SelectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public SelectAllAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Select All");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.Selection.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Select All triggered");
            this.plugInPort.selectAll(0);
        }
    }

    public static class DuplicateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public DuplicateAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Duplicate");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.DocumentsGear.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Duplicate triggered");
            try {
                this.plugInPort.duplicateSelection();
            }
            catch (Exception exception) {
                LOG.error((Object)"Coule not duplicate.", (Throwable)exception);
            }
        }
    }

    public static class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private Clipboard clipboard;
        private ClipboardOwner clipboardOwner;

        public CopyAction(IPlugInPort iPlugInPort, Clipboard clipboard, ClipboardOwner clipboardOwner) {
            this.plugInPort = iPlugInPort;
            this.clipboard = clipboard;
            this.clipboardOwner = clipboardOwner;
            this.putValue("Name", "Copy");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.Copy.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Copy triggered");
            this.clipboard.setContents(new ComponentTransferable(ActionFactory.cloneComponents(this.plugInPort.getSelectedComponents())), this.clipboardOwner);
        }
    }

    public static class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private Clipboard clipboard;

        public PasteAction(IPlugInPort iPlugInPort, Clipboard clipboard) {
            this.plugInPort = iPlugInPort;
            this.clipboard = clipboard;
            this.putValue("Name", "Paste");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.Paste.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Paste triggered");
            try {
                List list = (List)this.clipboard.getData(ComponentTransferable.listFlavor);
                this.plugInPort.pasteComponents((Collection)ActionFactory.cloneComponents(list), false);
            }
            catch (Exception exception) {
                LOG.error((Object)"Coule not paste.", (Throwable)exception);
            }
        }
    }

    public static class CutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private Clipboard clipboard;
        private ClipboardOwner clipboardOwner;

        public CutAction(IPlugInPort iPlugInPort, Clipboard clipboard, ClipboardOwner clipboardOwner) {
            this.plugInPort = iPlugInPort;
            this.clipboard = clipboard;
            this.clipboardOwner = clipboardOwner;
            this.putValue("Name", "Cut");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.Cut.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Cut triggered");
            this.clipboard.setContents(new ComponentTransferable(ActionFactory.cloneComponents(this.plugInPort.getSelectedComponents())), this.clipboardOwner);
            this.plugInPort.deleteSelectedComponents();
        }
    }

    public static class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public ExitAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Exit");
            this.putValue("SmallIcon", IconLoader.Exit.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"ExitAction triggered");
            if (this.plugInPort.allowFileAction()) {
                System.exit(0);
            }
        }
    }

    public static class ImportBlocksAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private ISwingUI swingUI;
        private IPlugInPort plugInPort;

        public ImportBlocksAction(ISwingUI iSwingUI, IPlugInPort iPlugInPort) {
            this.swingUI = iSwingUI;
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Import Building Blocks");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"ImportBlocksAction triggered");
            final File file = DialogFactory.getInstance().showOpenDialog(FileFilterEnum.XML.getFilter(), null, FileFilterEnum.XML.getExtensions()[0], null, this.swingUI.getOwnerFrame());
            if (file != null) {
                this.swingUI.executeBackgroundTask(new ITask<Integer>(){

                    public Integer doInBackground() throws Exception {
                        return ImportBlocksAction.this.plugInPort.importBlocks(file.getAbsolutePath());
                    }

                    public void complete(Integer n) {
                        ImportBlocksAction.this.swingUI.showMessage(n + " building block(s) imported from \"" + file.getName() + "\".", "Success", 1);
                    }

                    public void failed(Exception exception) {
                        ImportBlocksAction.this.swingUI.showMessage("Could not import building blocks: " + exception.getMessage(), "Error", 0);
                    }
                }, true);
            }
        }
    }

    public static class ExportBlocksAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private ISwingUI swingUI;

        public ExportBlocksAction(ISwingUI iSwingUI) {
            this.swingUI = iSwingUI;
            this.putValue("Name", "Export Building Blocks");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HashMap hashMap;
            Object object;
            Object object2;
            Map map;
            LOG.info((Object)"ExportBuildingBlocksAction triggered");
            try {
                map = (Map)ConfigurationManager.getInstance().readObject("buildingBlocks", null);
                if (map == null || map.isEmpty()) {
                    this.swingUI.showMessage("No building blocks found to export.", "Error", 0);
                    return;
                }
                object2 = map.keySet().toArray(new String[0]);
                Arrays.sort(object2, new Comparator<String>(){

                    @Override
                    public int compare(String string, String string2) {
                        return string.compareToIgnoreCase(string2);
                    }
                });
                object = new CheckBoxListDialog(this.swingUI.getOwnerFrame(), "Export Building Blocks", object2);
                object.setVisible(true);
                if (object.getSelectedButtonCaption() != "OK") {
                    return;
                }
                Object[] objectArray = object.getSelectedOptions();
                if (objectArray.length == 0) {
                    this.swingUI.showMessage("No building blocks selected for export.", "Error", 0);
                    return;
                }
                hashMap = new HashMap();
                for (Object object3 : objectArray) {
                    hashMap.put(object3.toString(), map.get(object3));
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Error preparing building blocks for export", (Throwable)exception);
                this.swingUI.showMessage("Could not export building blocks. Please check the log for details", "Export Building Blocks", 0);
                return;
            }
            map = new BuildingBlockPackage(hashMap, System.getProperty("user.name"));
            object2 = new File(map.getOwner() == null ? "building blocks.xml" : "building blocks by " + map.getOwner().toLowerCase() + ".xml");
            object = DialogFactory.getInstance().showSaveDialog(this.swingUI.getOwnerFrame(), FileFilterEnum.XML.getFilter(), (File)object2, FileFilterEnum.XML.getExtensions()[0], null);
            if (object != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>((File)object, (BuildingBlockPackage)map){
                    final /* synthetic */ File val$file;
                    final /* synthetic */ BuildingBlockPackage val$variantPkg;
                    {
                        this.val$file = file;
                        this.val$variantPkg = buildingBlockPackage;
                    }

                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Exporting variants to " + this.val$file.getAbsolutePath()));
                        try {
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.val$file));
                            XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
                            xStream.toXML((Object)this.val$variantPkg, (OutputStream)bufferedOutputStream);
                            bufferedOutputStream.close();
                            LOG.info((Object)"Exported building blocks succesfully");
                        }
                        catch (IOException iOException) {
                            LOG.error((Object)"Could not export building blocks", (Throwable)iOException);
                        }
                        return null;
                    }

                    public void complete(Void void_) {
                        ExportBlocksAction.this.swingUI.showMessage("Building blocks exported to \"" + this.val$file.getName() + "\".", "Success", 1);
                    }

                    public void failed(Exception exception) {
                        ExportBlocksAction.this.swingUI.showMessage("Could not export building blocks: " + exception.getMessage(), "Error", 0);
                    }
                }, true);
            }
        }
    }

    public static class ImportVariantsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private ISwingUI swingUI;
        private IPlugInPort plugInPort;

        public ImportVariantsAction(ISwingUI iSwingUI, IPlugInPort iPlugInPort) {
            this.swingUI = iSwingUI;
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Import Variants");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"ImportVariantsAction triggered");
            final File file = DialogFactory.getInstance().showOpenDialog(FileFilterEnum.XML.getFilter(), null, FileFilterEnum.XML.getExtensions()[0], null, this.swingUI.getOwnerFrame());
            if (file != null) {
                this.swingUI.executeBackgroundTask(new ITask<Integer>(){

                    public Integer doInBackground() throws Exception {
                        return ImportVariantsAction.this.plugInPort.importVariants(file.getAbsolutePath());
                    }

                    public void complete(Integer n) {
                        ImportVariantsAction.this.swingUI.showMessage(n + " variant(s) imported from \"" + file.getName() + "\".", "Success", 1);
                    }

                    public void failed(Exception exception) {
                        ImportVariantsAction.this.swingUI.showMessage("Could not import variants: " + exception.getMessage(), "Error", 0);
                    }
                }, true);
            }
        }
    }

    public static class ExportVariantsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private ISwingUI swingUI;
        private Map<String, ComponentType> typeMap = new TreeMap<String, ComponentType>(String.CASE_INSENSITIVE_ORDER);

        public ExportVariantsAction(ISwingUI iSwingUI, IPlugInPort iPlugInPort) {
            this.swingUI = iSwingUI;
            this.putValue("Name", "Export Variants");
            Map map = iPlugInPort.getComponentTypes();
            for (Map.Entry entry : map.entrySet()) {
                for (ComponentType componentType : (List)entry.getValue()) {
                    this.typeMap.put(componentType.getInstanceClass().getCanonicalName(), componentType);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HashMap<String, List> hashMap;
            Object object;
            Serializable serializable;
            Map map;
            LOG.info((Object)"ExportVariantsAction triggered");
            try {
                Object[] objectArray2;
                map = (Map)ConfigurationManager.getInstance().readObject("templates", null);
                if (map == null || map.isEmpty()) {
                    this.swingUI.showMessage("No variants found to export.", "Error", 0);
                    return;
                }
                serializable = new ArrayList<Object[]>();
                for (Object[] objectArray2 : map.keySet()) {
                    Object[] objectArray3 = this.typeMap.get(objectArray2);
                    if (objectArray3 != null) {
                        serializable.add(objectArray3);
                        continue;
                    }
                    LOG.warn((Object)("Could not find type for: " + (String)objectArray2));
                }
                Collections.sort(serializable, new Comparator<ComponentType>(){

                    @Override
                    public int compare(ComponentType componentType, ComponentType componentType2) {
                        return componentType.toString().compareToIgnoreCase(componentType2.toString());
                    }
                });
                object = new CheckBoxListDialog(this.swingUI.getOwnerFrame(), "Export Variants", serializable.toArray());
                object.setVisible(true);
                if (object.getSelectedButtonCaption() != "OK") {
                    return;
                }
                objectArray2 = object.getSelectedOptions();
                if (objectArray2.length == 0) {
                    this.swingUI.showMessage("No variants selected for export.", "Error", 0);
                    return;
                }
                hashMap = new HashMap<String, List>();
                for (Object object2 : objectArray2) {
                    ComponentType componentType = (ComponentType)object2;
                    String string = componentType.getInstanceClass().getCanonicalName();
                    List list = (List)map.get(string);
                    if (list == null) continue;
                    hashMap.put(string, list);
                }
            }
            catch (Exception exception) {
                LOG.error((Object)"Error preparing variants for export", (Throwable)exception);
                this.swingUI.showMessage("Could not export variants. Please check the log for details", "Export Variants", 0);
                return;
            }
            map = new VariantPackage(hashMap, System.getProperty("user.name"));
            serializable = new File(map.getOwner() == null ? "variants.xml" : "variants by " + map.getOwner().toLowerCase() + ".xml");
            object = DialogFactory.getInstance().showSaveDialog(this.swingUI.getOwnerFrame(), FileFilterEnum.XML.getFilter(), (File)serializable, FileFilterEnum.XML.getExtensions()[0], null);
            if (object != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>((File)object, (VariantPackage)map){
                    final /* synthetic */ File val$file;
                    final /* synthetic */ VariantPackage val$variantPkg;
                    {
                        this.val$file = file;
                        this.val$variantPkg = variantPackage;
                    }

                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Exporting variants to " + this.val$file.getAbsolutePath()));
                        try {
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.val$file));
                            XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
                            xStream.toXML((Object)this.val$variantPkg, (OutputStream)bufferedOutputStream);
                            bufferedOutputStream.close();
                            LOG.info((Object)"Exported variants succesfully");
                        }
                        catch (IOException iOException) {
                            LOG.error((Object)"Could not export variants", (Throwable)iOException);
                        }
                        return null;
                    }

                    public void complete(Void void_) {
                        ExportVariantsAction.this.swingUI.showMessage("Variants exported to \"" + this.val$file.getName() + "\".", "Success", 1);
                    }

                    public void failed(Exception exception) {
                        ExportVariantsAction.this.swingUI.showMessage("Could not export variants: " + exception.getMessage(), "Error", 0);
                    }
                }, true);
            }
        }
    }

    public static class PrintAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IDrawingProvider drawingProvider;

        public PrintAction(IDrawingProvider iDrawingProvider, int n) {
            this.drawingProvider = iDrawingProvider;
            this.putValue("Name", "Print...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, n));
            this.putValue("SmallIcon", IconLoader.Print.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"PrintAction triggered");
            try {
                DrawingExporter.getInstance().print(this.drawingProvider);
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
    }

    public static class ExportPNGAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IDrawingProvider drawingProvider;
        private ISwingUI swingUI;
        private IPlugInPort plugInPort;
        private String defaultSuffix;

        public ExportPNGAction(IPlugInPort iPlugInPort, IDrawingProvider iDrawingProvider, ISwingUI iSwingUI, String string) {
            this.plugInPort = iPlugInPort;
            this.drawingProvider = iDrawingProvider;
            this.drawingProvider = iDrawingProvider;
            this.swingUI = iSwingUI;
            this.defaultSuffix = string;
            this.putValue("Name", "Export to PNG");
            this.putValue("SmallIcon", IconLoader.Image.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            LOG.info((Object)"ExportPNGAction triggered");
            File file2 = null;
            String string = this.plugInPort.getCurrentFileName();
            if (string != null) {
                file = new File(string);
                file2 = new File(file.getName().replaceAll("(?i)\\.diy", "") + this.defaultSuffix + ".png");
            }
            if ((file = DialogFactory.getInstance().showSaveDialog(this.swingUI.getOwnerFrame(), FileFilterEnum.PNG.getFilter(), file2, FileFilterEnum.PNG.getExtensions()[0], null)) != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Exporting to " + file.getAbsolutePath()));
                        DrawingExporter.getInstance().exportPNG(ExportPNGAction.this.drawingProvider, file);
                        return null;
                    }

                    public void complete(Void void_) {
                    }

                    public void failed(Exception exception) {
                        ExportPNGAction.this.swingUI.showMessage("Could not export to PNG. " + exception.getMessage(), "Error", 0);
                    }
                }, true);
            }
        }
    }

    public static class ExportPDFAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IDrawingProvider drawingProvider;
        private ISwingUI swingUI;
        private IPlugInPort plugInPort;
        private String defaultSuffix;

        public ExportPDFAction(IPlugInPort iPlugInPort, IDrawingProvider iDrawingProvider, ISwingUI iSwingUI, String string) {
            this.plugInPort = iPlugInPort;
            this.drawingProvider = iDrawingProvider;
            this.swingUI = iSwingUI;
            this.defaultSuffix = string;
            this.putValue("Name", "Export to PDF");
            this.putValue("SmallIcon", IconLoader.PDF.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            LOG.info((Object)"ExportPDFAction triggered");
            File file2 = null;
            String string = this.plugInPort.getCurrentFileName();
            if (string != null) {
                file = new File(string);
                file2 = new File(file.getName().replaceAll("(?i)\\.diy", "") + this.defaultSuffix + ".pdf");
            }
            if ((file = DialogFactory.getInstance().showSaveDialog(this.swingUI.getOwnerFrame(), FileFilterEnum.PDF.getFilter(), file2, FileFilterEnum.PDF.getExtensions()[0], null)) != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Exporting to " + file.getAbsolutePath()));
                        DrawingExporter.getInstance().exportPDF(ExportPDFAction.this.drawingProvider, file);
                        return null;
                    }

                    public void complete(Void void_) {
                    }

                    public void failed(Exception exception) {
                        ExportPDFAction.this.swingUI.showMessage("Could not export to PDF. " + exception.getMessage(), "Error", 0);
                    }
                }, true);
            }
        }
    }

    public static class CreateBomAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public CreateBomAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Create B.O.M.");
            this.putValue("SmallIcon", IconLoader.BOM.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            LOG.info((Object)"CreateBomAction triggered");
            List list = BomMaker.getInstance().createBom(this.plugInPort.getCurrentProject().getComponents());
            String string = null;
            String string2 = this.plugInPort.getCurrentFileName();
            if (string2 != null) {
                serializable = new File(string2);
                string = ((File)serializable).getName().replaceAll("(?i)\\.diy", "") + " BOM";
            }
            serializable = DialogFactory.getInstance().createBomDialog(list, string);
            ((BomDialog)serializable).setVisible(true);
        }
    }

    public static class SaveAsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;

        public SaveAsAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.putValue("Name", "Save As");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
            this.putValue("SmallIcon", IconLoader.DiskBlue.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"SaveAsAction triggered");
            final File file = DialogFactory.getInstance().showSaveDialog(this.swingUI.getOwnerFrame(), FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null);
            if (file != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Saving to " + file.getAbsolutePath()));
                        SaveAsAction.this.plugInPort.saveProjectToFile(file.getAbsolutePath(), false);
                        return null;
                    }

                    public void complete(Void void_) {
                    }

                    public void failed(Exception exception) {
                        SaveAsAction.this.swingUI.showMessage("Could not save to file. " + exception.getMessage(), "Error", 0);
                    }
                }, true);
            }
        }
    }

    public static class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;

        public SaveAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.putValue("Name", "Save");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.DiskBlue.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"SaveAction triggered");
            if (this.plugInPort.getCurrentFileName() == null) {
                final File file = DialogFactory.getInstance().showSaveDialog(this.swingUI.getOwnerFrame(), FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null);
                if (file != null) {
                    this.swingUI.executeBackgroundTask(new ITask<Void>(){

                        public Void doInBackground() throws Exception {
                            LOG.debug((Object)("Saving to " + file.getAbsolutePath()));
                            SaveAction.this.plugInPort.saveProjectToFile(file.getAbsolutePath(), false);
                            return null;
                        }

                        public void complete(Void void_) {
                        }

                        public void failed(Exception exception) {
                            SaveAction.this.swingUI.showMessage("Could not save to file. " + exception.getMessage(), "Error", 0);
                        }
                    }, true);
                }
            } else {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Saving to " + SaveAction.this.plugInPort.getCurrentFileName()));
                        SaveAction.this.plugInPort.saveProjectToFile(SaveAction.this.plugInPort.getCurrentFileName(), false);
                        return null;
                    }

                    public void complete(Void void_) {
                    }

                    public void failed(Exception exception) {
                        SaveAction.this.swingUI.showMessage("Could not save to file. " + exception.getMessage(), "Error", 0);
                    }
                }, true);
            }
        }
    }

    public static class ImportAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;
        private Presenter presenter;

        public ImportAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.presenter = new Presenter(new IView(){

                public int showConfirmDialog(String string, String string2, int n, int n2) {
                    return JOptionPane.showConfirmDialog(null, string, string2, n, n2);
                }

                public void showMessage(String string, String string2, int n) {
                    JOptionPane.showMessageDialog(null, string, string2, n);
                }

                public File promptFileSave() {
                    return null;
                }

                public boolean editProperties(List<PropertyWrapper> list, Set<PropertyWrapper> set) {
                    return false;
                }
            });
            this.putValue("Name", "Import");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.ElementInto.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"ImportAction triggered");
            final File file = DialogFactory.getInstance().showOpenDialog(FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null);
            if (file != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Opening from " + file.getAbsolutePath()));
                        ImportAction.this.presenter.loadProjectFromFile(file.getAbsolutePath());
                        ImportAction.this.plugInPort.pasteComponents((Collection)ImportAction.this.presenter.getCurrentProject().getComponents(), false);
                        ImportAction.this.presenter.selectAll(0);
                        ImportAction.this.presenter.deleteSelectedComponents();
                        return null;
                    }

                    public void complete(Void void_) {
                    }

                    public void failed(Exception exception) {
                        ImportAction.this.swingUI.showMessage("Could not open file. " + exception.getMessage(), "Error", 0);
                    }
                }, true);
            }
        }
    }

    public static class OpenAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;

        public OpenAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.putValue("Name", "Open");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.FolderOut.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"OpenAction triggered");
            if (!this.plugInPort.allowFileAction()) {
                return;
            }
            final File file = DialogFactory.getInstance().showOpenDialog(FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null);
            if (file != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Opening from " + file.getAbsolutePath()));
                        OpenAction.this.plugInPort.loadProjectFromFile(file.getAbsolutePath());
                        return null;
                    }

                    public void complete(Void void_) {
                    }

                    public void failed(Exception exception) {
                        OpenAction.this.swingUI.showMessage("Could not open file. " + exception.getMessage(), "Error", 0);
                    }
                }, true);
            }
        }
    }

    public static class NewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public NewAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "New");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", IconLoader.DocumentPlain.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"NewAction triggered");
            if (!this.plugInPort.allowFileAction()) {
                return;
            }
            this.plugInPort.createNewProject();
            List list = this.plugInPort.getProperties((Object)this.plugInPort.getCurrentProject());
            PropertyEditorDialog propertyEditorDialog = DialogFactory.getInstance().createPropertyEditorDialog(list, "Edit Project", true);
            propertyEditorDialog.setVisible(true);
            if ("OK".equals(propertyEditorDialog.getSelectedButtonCaption())) {
                this.plugInPort.applyProperties((Object)this.plugInPort.getCurrentProject(), list);
            }
            for (PropertyWrapper propertyWrapper : propertyEditorDialog.getDefaultedProperties()) {
                if (propertyWrapper.getValue() == null) continue;
                this.plugInPort.setDefaultPropertyValue(Project.class, propertyWrapper.getName(), propertyWrapper.getValue());
            }
        }
    }
}

