/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.components.passive.Voltage;
import org.diylc.core.CreationMethod;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Capacitance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Electrolytic Capacitor (Axial)", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="C", description="Axial electrolytic capacitor, similar to Sprague Atom, F&T, etc", zOrder=4.0, transformer=SimpleComponentTransformer.class)
public class AxialElectrolyticCapacitor
extends AbstractLeadedComponent<Capacitance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.5), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(0.125), SizeUnit.in);
    public static Color BODY_COLOR = Color.decode("#6B6DCE");
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    public static Color MARKER_COLOR = Color.decode("#8CACEA");
    public static Color TICK_COLOR = Color.white;
    private Capacitance value = null;
    @Deprecated
    private Voltage voltage = Voltage._63V;
    private org.diylc.core.measures.Voltage voltageNew = null;
    private Color markerColor = MARKER_COLOR;
    private Color tickColor = TICK_COLOR;
    private boolean polarized = true;

    public AxialElectrolyticCapacitor() {
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
        this.labelColor = TICK_COLOR;
    }

    @EditableProperty(validatorClass=PositiveMeasureValidator.class)
    public Capacitance getValue() {
        return this.value;
    }

    public void setValue(Capacitance value) {
        this.value = value;
    }

    public String getValueForDisplay() {
        return this.getValue().toString() + (this.getVoltageNew() == null ? "" : " " + this.getVoltageNew().toString());
    }

    @Deprecated
    public Voltage getVoltage() {
        return this.voltage;
    }

    @Deprecated
    public void setVoltage(Voltage voltage) {
        this.voltage = voltage;
    }

    @EditableProperty(name="Voltage")
    public org.diylc.core.measures.Voltage getVoltageNew() {
        return this.voltageNew;
    }

    public void setVoltageNew(org.diylc.core.measures.Voltage voltageNew) {
        this.voltageNew = voltageNew;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR_ICON);
        g2d.drawLine(0, height / 2, width, height / 2);
        g2d.setColor(BODY_COLOR);
        g2d.fillRect(4, height / 2 - 3, width - 8, 6);
        g2d.setColor(MARKER_COLOR);
        g2d.fillRect(width - 9, height / 2 - 3, 5, 6);
        g2d.setColor(TICK_COLOR);
        g2d.drawLine(width - 6, height / 2 - 1, width - 6, height / 2 + 1);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(4, height / 2 - 3, width - 8, 6);
    }

    @Override
    protected Size getDefaultWidth() {
        return DEFAULT_HEIGHT;
    }

    @Override
    protected Size getDefaultLength() {
        return DEFAULT_WIDTH;
    }

    @EditableProperty(name="Marker")
    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(Color coverColor) {
        this.markerColor = coverColor;
    }

    @EditableProperty(name="Tick")
    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color tickColor) {
        this.tickColor = tickColor;
    }

    @EditableProperty(name="Polarized")
    public boolean getPolarized() {
        return this.polarized;
    }

    public void setPolarized(boolean polarized) {
        this.polarized = polarized;
    }

    @Override
    protected Shape getBodyShape() {
        double length = this.getLength().convertToPixels();
        double width = this.getWidth().convertToPixels();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, length, width, width / 6.0, width / 6.0);
        Area a = new Area(rect);
        double notchDiameter = width / 4.0;
        a.subtract(new Area(new Ellipse2D.Double(notchDiameter, -notchDiameter * 3.0 / 4.0, notchDiameter, notchDiameter)));
        a.subtract(new Area(new Ellipse2D.Double(notchDiameter, width - notchDiameter / 4.0, notchDiameter, notchDiameter)));
        if (!this.getPolarized()) {
            a.subtract(new Area(new Ellipse2D.Double(length - notchDiameter * 2.0, -notchDiameter * 3.0 / 4.0, notchDiameter, notchDiameter)));
            a.subtract(new Area(new Ellipse2D.Double(length - notchDiameter * 2.0, width - notchDiameter / 4.0, notchDiameter, notchDiameter)));
        }
        return a;
    }

    @Override
    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        int width = (int)this.getWidth().convertToPixels();
        int length = (int)this.getLength().convertToPixels();
        g2d.setColor(AxialElectrolyticCapacitor.blend(this.getBorderColor(), this.getBodyColor()));
        int notchDiameter = width / 4;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.drawLine(notchDiameter, 0, notchDiameter, width);
        g2d.drawLine(notchDiameter * 2, 0, notchDiameter * 2, width);
        if (this.polarized) {
            Color finalTickColor;
            int markerLength = (int)(this.getLength().convertToPixels() * 0.2);
            if (!outlineMode) {
                g2d.setColor(this.markerColor);
                Rectangle2D.Double markerRect = new Rectangle2D.Double(length - markerLength, 0.0, markerLength + 2, width);
                Area markerArea = new Area(markerRect);
                markerArea.intersect((Area)this.getBodyShape());
                g2d.fill(markerArea);
            }
            if (outlineMode) {
                Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
                finalTickColor = theme.getOutlineColor();
            } else {
                finalTickColor = this.tickColor;
            }
            g2d.setColor(finalTickColor);
            g2d.setStroke(ObjectCache.getInstance().fetchZoomableStroke(2.0f));
            g2d.drawLine((int)this.getLength().convertToPixels() - markerLength / 2, (int)((double)(width / 2) - (double)width * 0.15), (int)this.getLength().convertToPixels() - markerLength / 2, (int)((double)(width / 2) + (double)width * 0.15));
        } else {
            g2d.drawLine(length - notchDiameter, 0, length - notchDiameter, width);
            g2d.drawLine(length - notchDiameter * 2, 0, length - notchDiameter * 2, width);
        }
    }

    public static Color blend(Color c0, Color c1) {
        double totalAlpha = c0.getAlpha() + c1.getAlpha();
        double weight0 = (double)c0.getAlpha() / totalAlpha;
        double weight1 = (double)c1.getAlpha() / totalAlpha;
        double r = weight0 * (double)c0.getRed() + weight1 * (double)c1.getRed();
        double g = weight0 * (double)c0.getGreen() + weight1 * (double)c1.getGreen();
        double b = weight0 * (double)c0.getBlue() + weight1 * (double)c1.getBlue();
        double a = Math.max(c0.getAlpha(), c1.getAlpha());
        return new Color((int)r, (int)g, (int)b, (int)a);
    }
}

