/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.boards;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.components.transform.TerminalStripTransformer;
import org.diylc.core.ComponentState;
import org.diylc.core.IContinuity;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.annotations.PositiveNonZeroMeasureValidator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Terminal Strip", author="Branislav Stojkovic", category="Boards", instanceNamePrefix="TS", description="Row of terminals for point-to-point construction", zOrder=2.0, keywordPolicy=KeywordPolicy.SHOW_TYPE_NAME, transformer=TerminalStripTransformer.class)
public class TerminalStrip
extends AbstractTransparentComponent<String>
implements IContinuity {
    private static final long serialVersionUID = 1L;
    public static Color BOARD_COLOR = Color.decode("#CD8500");
    public static Color BORDER_COLOR = BOARD_COLOR.darker();
    public static Color TERMINAL_COLOR = Color.lightGray;
    public static Color TERMINAL_BORDER_COLOR = TERMINAL_COLOR.darker();
    public static int EDGE_RADIUS = 2;
    public static Size HOLE_SIZE = new Size(Double.valueOf(0.06), SizeUnit.in);
    public static Size MOUNTING_HOLE_SIZE = new Size(Double.valueOf(0.07), SizeUnit.in);
    private String value = "";
    private Orientation orientation = Orientation.DEFAULT;
    private int terminalCount = 10;
    private Size boardWidth = new Size(Double.valueOf(0.35), SizeUnit.in);
    private Size terminalSpacing = new Size(Double.valueOf(0.25), SizeUnit.in);
    private Size holeSpacing = new Size(Double.valueOf(0.5), SizeUnit.in);
    private Point[] controlPoints = new Point[]{new Point(0, 0)};
    private Color boardColor = BOARD_COLOR;
    private Color borderColor = BORDER_COLOR;
    private boolean centerHole = false;
    private transient Area[] body;

    public TerminalStrip() {
        this.updateControlPoints();
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Terminals")
    public int getTerminalCount() {
        return this.terminalCount;
    }

    public void setTerminalCount(int terminalCount) {
        this.terminalCount = terminalCount;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Terminal Spacing", validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getTerminalSpacing() {
        return this.terminalSpacing;
    }

    public void setTerminalSpacing(Size pinSpacing) {
        this.terminalSpacing = pinSpacing;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Hole Spacing", validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getHoleSpacing() {
        return this.holeSpacing;
    }

    public void setHoleSpacing(Size rowSpacing) {
        this.holeSpacing = rowSpacing;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Center Terminal")
    public boolean getCenterHole() {
        return this.centerHole;
    }

    public void setCenterHole(boolean centerHole) {
        this.centerHole = centerHole;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Board Width", validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getBoardWidth() {
        return this.boardWidth;
    }

    public void setBoardWidth(Size boardWidth) {
        this.boardWidth = boardWidth;
        this.body = null;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        Point firstPoint = this.controlPoints[0];
        this.controlPoints = new Point[this.getTerminalCount() * (this.getCenterHole() ? 3 : 2)];
        this.controlPoints[0] = firstPoint;
        int pinSpacing = (int)this.terminalSpacing.convertToPixels();
        int rowSpacing = (int)this.holeSpacing.convertToPixels();
        for (int i = 0; i < this.getTerminalCount(); ++i) {
            int cy;
            int cx;
            int dy2;
            int dx2;
            int dy1;
            int dx1;
            switch (this.orientation) {
                case DEFAULT: {
                    dx1 = 0;
                    dy1 = i * pinSpacing;
                    dx2 = rowSpacing;
                    dy2 = i * pinSpacing;
                    cx = rowSpacing / 2;
                    cy = i * pinSpacing;
                    break;
                }
                case _90: {
                    dx1 = -i * pinSpacing;
                    dy1 = 0;
                    dx2 = -i * pinSpacing;
                    dy2 = rowSpacing;
                    cx = -i * pinSpacing;
                    cy = rowSpacing / 2;
                    break;
                }
                case _180: {
                    dx1 = 0;
                    dy1 = -i * pinSpacing;
                    dx2 = -rowSpacing;
                    dy2 = -i * pinSpacing;
                    cx = -rowSpacing / 2;
                    cy = -i * pinSpacing;
                    break;
                }
                case _270: {
                    dx1 = i * pinSpacing;
                    dy1 = 0;
                    dx2 = i * pinSpacing;
                    dy2 = -rowSpacing;
                    cx = i * pinSpacing;
                    cy = -rowSpacing / 2;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            this.controlPoints[i] = new Point(firstPoint.x + dx1, firstPoint.y + dy1);
            this.controlPoints[i + this.getTerminalCount()] = new Point(firstPoint.x + dx2, firstPoint.y + dy2);
            if (!this.centerHole) continue;
            this.controlPoints[i + 2 * this.getTerminalCount()] = new Point(firstPoint.x + cx, firstPoint.y + cy);
        }
    }

    public Area[] getBody() {
        if (this.body == null) {
            int height;
            int width;
            this.body = new Area[2];
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            int holeSize = (int)HOLE_SIZE.convertToPixels();
            int terminalSpacing = (int)this.getTerminalSpacing().convertToPixels();
            int holeSpacing = (int)this.getHoleSpacing().convertToPixels();
            int boardWidth = (int)this.getBoardWidth().convertToPixels();
            int boardLength = (this.getTerminalCount() - 1) * terminalSpacing + 2 * boardWidth;
            Area indentation = null;
            Area terminals = null;
            int mountingHoleSize = this.getClosestOdd(MOUNTING_HOLE_SIZE.convertToPixels());
            switch (this.orientation) {
                case DEFAULT: {
                    width = boardWidth;
                    height = boardLength;
                    indentation = new Area(new Ellipse2D.Double((x += holeSpacing / 2 - boardWidth / 2) + boardWidth / 2 - mountingHoleSize / 2, (y -= boardWidth) + boardWidth / 2 - mountingHoleSize / 2, mountingHoleSize, mountingHoleSize));
                    indentation.add(new Area(new Ellipse2D.Double(x + boardWidth / 2 - mountingHoleSize / 2, y + boardLength - boardWidth / 2, mountingHoleSize, mountingHoleSize)));
                    break;
                }
                case _90: {
                    width = boardLength;
                    height = boardWidth;
                    indentation = new Area(new Ellipse2D.Double((x += boardWidth - boardLength) + boardWidth / 2 - mountingHoleSize, (y += holeSpacing / 2 - boardWidth / 2) + boardWidth / 2 - mountingHoleSize / 2, mountingHoleSize, mountingHoleSize));
                    indentation.add(new Area(new Ellipse2D.Double(x + boardLength - boardWidth / 2, y + boardWidth / 2 - mountingHoleSize / 2, mountingHoleSize, mountingHoleSize)));
                    break;
                }
                case _180: {
                    width = boardWidth;
                    height = boardLength;
                    indentation = new Area(new Ellipse2D.Double((x -= holeSpacing / 2 + boardWidth / 2) + boardWidth / 2 - mountingHoleSize / 2, (y += boardWidth - boardLength) + boardWidth / 2 - mountingHoleSize / 2, mountingHoleSize, mountingHoleSize));
                    indentation.add(new Area(new Ellipse2D.Double(x + boardWidth / 2 - mountingHoleSize / 2, y + boardLength - boardWidth / 2, mountingHoleSize, mountingHoleSize)));
                    break;
                }
                case _270: {
                    width = boardLength;
                    height = boardWidth;
                    indentation = new Area(new Ellipse2D.Double((x -= boardWidth) + boardWidth / 2 - mountingHoleSize, (y -= holeSpacing / 2 + boardWidth / 2) + boardWidth / 2 - mountingHoleSize / 2, mountingHoleSize, mountingHoleSize));
                    indentation.add(new Area(new Ellipse2D.Double(x + boardLength - boardWidth / 2, y + boardWidth / 2 - mountingHoleSize / 2, mountingHoleSize, mountingHoleSize)));
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            Area bodyArea = new Area(new RoundRectangle2D.Double(x, y, width, height, EDGE_RADIUS, EDGE_RADIUS));
            bodyArea.subtract(indentation);
            this.body[0] = bodyArea;
            terminals = new Area();
            for (int i = 0; i < this.getTerminalCount(); ++i) {
                Point p1 = this.getControlPoint(i);
                Point p2 = this.getControlPoint(i + this.getTerminalCount());
                if (p2.x < p1.x || p2.y < p1.y) {
                    Point p = p1;
                    p1 = p2;
                    p2 = p;
                }
                Area terminal = new Area(new RoundRectangle2D.Double(p1.x - holeSize, p1.y - holeSize, p2.x - p1.x + holeSize * 2, p2.y - p1.y + holeSize * 2, holeSize, holeSize));
                terminal.subtract(new Area(new Ellipse2D.Double(p1.x - holeSize / 2, p1.y - holeSize / 2, holeSize, holeSize)));
                terminal.subtract(new Area(new Ellipse2D.Double(p2.x - holeSize / 2, p2.y - holeSize / 2, holeSize, holeSize)));
                if (this.centerHole) {
                    Point p3 = this.getControlPoint(i + 2 * this.getTerminalCount());
                    Area centerHole = new Area(new Ellipse2D.Double(p3.x - holeSize / 2, p3.y - holeSize / 2, holeSize, holeSize));
                    terminal.subtract(centerHole);
                    bodyArea.subtract(centerHole);
                }
                terminals.add(terminal);
            }
            this.body[1] = terminals;
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalTerminalBorderColor;
        Color finalBorderColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        Area mainArea = this.getBody()[0];
        Area terminalArea = this.getBody()[1];
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getBoardColor());
        g2d.fill(mainArea);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getBorderColor();
        }
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.setColor(finalBorderColor);
        g2d.draw(mainArea);
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : TERMINAL_COLOR);
        drawingObserver.startTrackingContinuityArea(true);
        g2d.fill(terminalArea);
        drawingObserver.stopTrackingContinuityArea();
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalTerminalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalTerminalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : TERMINAL_BORDER_COLOR;
        }
        g2d.setColor(finalTerminalBorderColor);
        g2d.draw(terminalArea);
        g2d.setComposite(oldComposite);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int radius = 6 * width / 32;
        int holeSize = 3 * width / 32;
        g2d.setColor(BOARD_COLOR);
        g2d.fillRect(width / 4, 1, width / 2, height - 4);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(width / 4, 1, width / 2, height - 4);
        int terminalSize = this.getClosestOdd(height / 5);
        Area terminal = new Area(new RoundRectangle2D.Double(2 * width / 32, height / 5, width - 4 * width / 32, terminalSize, radius, radius));
        terminal.subtract(new Area(new Ellipse2D.Double(2 * width / 32 + holeSize, height * 3 / 10 - holeSize / 2, holeSize, holeSize)));
        terminal.subtract(new Area(new Ellipse2D.Double(width - 2 * width / 32 - holeSize * 2, height * 3 / 10 - holeSize / 2, holeSize, holeSize)));
        g2d.setColor(TERMINAL_COLOR);
        g2d.fill(terminal);
        g2d.setColor(TERMINAL_BORDER_COLOR);
        g2d.draw(terminal);
        g2d.translate(0, height * 2 / 5);
        g2d.setColor(TERMINAL_COLOR);
        g2d.fill(terminal);
        g2d.setColor(TERMINAL_BORDER_COLOR);
        g2d.draw(terminal);
    }

    @EditableProperty(name="Board")
    public Color getBoardColor() {
        if (this.boardColor == null) {
            this.boardColor = BOARD_COLOR;
        }
        return this.boardColor;
    }

    public void setBoardColor(Color bodyColor) {
        this.boardColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        if (this.borderColor == null) {
            this.borderColor = BORDER_COLOR;
        }
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public String getControlPointNodeName(int index) {
        return "TerminalStrip" + index;
    }

    public boolean arePointsConnected(int index1, int index2) {
        return Math.abs(index1 - index2) == this.getTerminalCount();
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }
}

