/*
 * Decompiled with CFR 0.152.
 */
package cib.util.msg;

import cib.util.Dbg;
import cib.util.msg.MsgHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class ClientMsgHandler
extends MsgHandler {
    private static int s_nHandlers = 0;
    private int m_clientId = 0;
    private static Socket s_socket = null;

    public static synchronized ClientMsgHandler getServerConnection(String serverHostName, int port) {
        if (s_nHandlers != 0) {
            return null;
        }
        ++s_nHandlers;
        try {
            InetAddress ipAddress = InetAddress.getByName(serverHostName);
            System.out.println("ClientMsgHandler: Try to connect to server at ipAddress " + ipAddress + " and port " + port + " ...");
            s_socket = new Socket(ipAddress, port);
            System.out.println("ClientMsgHandler: ... Connection to server established" + s_socket);
            InputStream in = s_socket.getInputStream();
            OutputStream out = s_socket.getOutputStream();
            ClientMsgHandler cmh = new ClientMsgHandler(in, out);
            DataInputStream din = new DataInputStream(in);
            int id = din.readInt();
            cmh.setClientId(id);
            cmh.start();
            return cmh;
        }
        catch (UnknownHostException e) {
            Dbg.println("ServerMsgHandler.getServerConnection(): " + e);
        }
        catch (IOException e) {
            Dbg.println("ServerMsgHandler.getServerConnection(): " + e);
        }
        return null;
    }

    private ClientMsgHandler(InputStream in, OutputStream out) {
        super(in, out);
    }

    @Override
    public void close() {
        super.close();
        if (s_socket != null) {
            try {
                s_socket.close();
                s_socket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        s_nHandlers = 0;
    }

    public int getClientId() {
        return this.m_clientId;
    }

    private void setClientId(int id) {
        this.m_clientId = id;
    }

    public String getClientName() {
        InetAddress addr = s_socket.getLocalAddress();
        return addr.getHostName();
    }
}

