/*
 * Decompiled with CFR 0.152.
 */
package cib.util.dxf;

import cib.util.dxf.Attributes;
import cib.util.dxf.ContentHandler;
import cib.util.dxf.interpreter.DXFParser;
import cib.util.dxf.interpreter.ParseException;
import cib.util.dxf.interpreter.TokenMgrError;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DXFReader {
    public static final String SECTION_HEADER = "HEADER";
    public static final String SECTION_CLASSES = "CLASSES";
    public static final String SECTION_TABLES = "TABLES";
    public static final String SECTION_BLOCKS = "BLOCKS";
    public static final String SECTION_ENTITIES = "ENTITIES";
    public static final String SECTION_OBJECTS = "OBJECTS";
    public static final String SECTION_THUMBNAILIMAGE = "THUMBNAILIMAGE";
    private Set<ContentHandler> m_contentHandlers = new HashSet<ContentHandler>();
    private DXFParser m_parser = null;

    public void addContentHandler(ContentHandler handler) {
        this.m_contentHandlers.add(handler);
    }

    public void removeContentHandler(ContentHandler handler) {
        if (!this.m_contentHandlers.contains(handler)) {
            System.out.println("handler not removable");
        } else {
            System.out.println("handler properly removed");
        }
        this.m_contentHandlers.remove(handler);
    }

    public void parse(Reader reader) throws TokenMgrError, ParseException {
        this.m_parser = new DXFParser(reader);
        this.m_parser.setContentHandler(new ContentHandler(){

            @Override
            public void startSection(String section) {
                Iterator it = DXFReader.this.m_contentHandlers.iterator();
                while (it.hasNext()) {
                    ((ContentHandler)it.next()).startSection(section);
                }
            }

            @Override
            public void endSection(String section) {
                Iterator it = DXFReader.this.m_contentHandlers.iterator();
                while (it.hasNext()) {
                    ((ContentHandler)it.next()).endSection(section);
                }
            }

            @Override
            public void startTable(String name, Attributes atts) {
                Iterator it = DXFReader.this.m_contentHandlers.iterator();
                while (it.hasNext()) {
                    ((ContentHandler)it.next()).startTable(name, atts);
                }
            }

            @Override
            public void endTable(String name) {
                Iterator it = DXFReader.this.m_contentHandlers.iterator();
                while (it.hasNext()) {
                    ((ContentHandler)it.next()).endTable(name);
                }
            }

            @Override
            public void startBlock(String name, Attributes atts) {
                Iterator it = DXFReader.this.m_contentHandlers.iterator();
                while (it.hasNext()) {
                    ((ContentHandler)it.next()).startBlock(name, atts);
                }
            }

            @Override
            public void endBlock(String name, Attributes atts) {
                Iterator it = DXFReader.this.m_contentHandlers.iterator();
                while (it.hasNext()) {
                    ((ContentHandler)it.next()).endBlock(name, atts);
                }
            }

            @Override
            public void startElement(String name, Attributes atts) {
                Iterator it = DXFReader.this.m_contentHandlers.iterator();
                while (it.hasNext()) {
                    ((ContentHandler)it.next()).startElement(name, atts);
                }
            }

            @Override
            public void endElement(String name) {
                Iterator it = DXFReader.this.m_contentHandlers.iterator();
                while (it.hasNext()) {
                    ((ContentHandler)it.next()).endElement(name);
                }
            }
        });
        this.m_parser.start();
    }

    public int getCurrentlyParsedLine() {
        if (this.m_parser == null || this.m_parser.token == null) {
            return -1;
        }
        return this.m_parser.token.beginLine;
    }

    public int getCurrentlyParsedColumn() {
        if (this.m_parser == null || this.m_parser.token == null) {
            return -1;
        }
        return this.m_parser.token.beginColumn;
    }
}

