/*
 * Decompiled with CFR 0.152.
 */
package cib.util.coll;

import cib.util.coll.ObservableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

class _SubSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected ObservableSet<E> m_superSet;
    protected Set<E> m_subSet;

    protected _SubSet(Set<E> subSet, ObservableSet<E> superSet) {
        if (superSet == null || subSet == null) {
            throw new IllegalArgumentException();
        }
        this.m_superSet = superSet;
        this.m_subSet = subSet;
        superSet.addListener(new ObservableSet.Listener<E>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasRemoved(Object o) {
                _SubSet.this.m_subSet.remove(o);
            }
        });
    }

    @Override
    public boolean add(E e) {
        if (!this.m_superSet.contains(e)) {
            return false;
        }
        return this.m_subSet.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (!this.m_superSet.containsAll(c)) {
            return false;
        }
        return this.m_subSet.addAll(c);
    }

    @Override
    public void clear() {
        this.m_subSet.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_subSet.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_subSet.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.m_subSet.equals(o);
    }

    @Override
    public int hashCode() {
        return this.m_subSet.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.m_subSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.m_subSet.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.m_subSet.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.m_subSet.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.m_subSet.retainAll(c);
    }

    @Override
    public int size() {
        return this.m_subSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.m_subSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_subSet.toArray(a);
    }

    public String toString() {
        return this.m_subSet.toString();
    }
}

