/*
 * Decompiled with CFR 0.152.
 */
package cib.util.coll;

import cib.util.coll.ReverseAccessMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class _ReverseAccessHashMap<K, V>
implements ReverseAccessMap<K, V>,
Serializable {
    private static final long serialVersionUID = 0L;
    private Map<K, V> m_keyToValue;
    private Map<V, Set<K>> m_valueToKey;

    protected _ReverseAccessHashMap(Map<K, V> map) {
        if (!map.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.m_keyToValue = map;
        this.m_valueToKey = new HashMap<V, Set<K>>();
    }

    @Override
    public K getKey(V value) {
        Set<K> keys = this.m_valueToKey.get(value);
        if (keys == null || keys.isEmpty()) {
            return null;
        }
        return keys.iterator().next();
    }

    @Override
    public Set<K> keySet(V value) {
        Set<K> keys = this.m_valueToKey.get(value);
        if (keys == null) {
            keys = new HashSet<K>();
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public void clear() {
        this.m_keyToValue.clear();
        this.m_valueToKey.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_keyToValue.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_valueToKey.containsKey(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.m_keyToValue.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.m_keyToValue.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.m_keyToValue.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.m_keyToValue.keySet();
    }

    @Override
    public V put(K key, V value) {
        Set<K> keys;
        V oldValue = this.m_keyToValue.get(key);
        if (oldValue != null) {
            if (oldValue == value) {
                return value;
            }
            keys = this.m_valueToKey.get(oldValue);
            if (!keys.remove(key)) {
                throw new Error("Unexpected state");
            }
            if (keys.isEmpty()) {
                this.m_valueToKey.remove(oldValue);
            }
        }
        this.m_keyToValue.put(key, value);
        keys = this.m_valueToKey.get(value);
        if (keys == null) {
            keys = new HashSet<K>();
            this.m_valueToKey.put((Set<K>)value, (Set<V>)keys);
        }
        keys.add(key);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        V value = this.m_keyToValue.remove(key);
        if (value == null) {
            return null;
        }
        Set<K> keys = this.m_valueToKey.get(value);
        if (!keys.remove(key)) {
            throw new Error("Unexpected state");
        }
        if (keys.isEmpty()) {
            this.m_valueToKey.remove(value);
        }
        return value;
    }

    @Override
    public int size() {
        return this.m_keyToValue.size();
    }

    @Override
    public Collection<V> values() {
        return this.m_keyToValue.values();
    }

    public String toString() {
        return this.m_keyToValue.toString();
    }
}

