/*
 * Decompiled with CFR 0.152.
 */
package cib.util.coll;

import cib.util.coll.IteratorFilter;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class _FilterableListIterator<E>
implements ListIterator<E> {
    protected IteratorFilter<E> m_filter;
    protected ListIterator<E> m_iter;
    protected E obj;
    protected boolean hasNext;
    protected boolean hasPrevious;
    protected boolean searchNext = true;
    protected int nextIndex = -1;
    protected int previousIndex = -1;

    protected _FilterableListIterator(ListIterator<E> iterator) {
        this.m_iter = iterator;
    }

    protected _FilterableListIterator(ListIterator<E> iterator, IteratorFilter<E> filter) {
        this.m_filter = filter;
        this.m_iter = iterator;
        this.filterNext();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (this.obj == null || !this.hasNext) {
            throw new NoSuchElementException();
        }
        if (!this.searchNext) {
            this.filterNext();
        }
        this.searchNext = true;
        E tmpObj = this.obj;
        this.previousIndex = this.nextIndex;
        this.filterNext();
        this.hasPrevious = true;
        return tmpObj;
    }

    @Override
    public boolean hasPrevious() {
        return this.hasPrevious;
    }

    @Override
    public E previous() {
        if (this.obj == null || !this.hasPrevious) {
            throw new NoSuchElementException();
        }
        if (this.searchNext) {
            this.filterPrevious();
        }
        this.searchNext = false;
        E tmpObj = this.obj;
        this.nextIndex = this.previousIndex;
        this.filterPrevious();
        this.hasNext = true;
        return tmpObj;
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public int previousIndex() {
        return this.previousIndex;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Object o) {
        throw new UnsupportedOperationException();
    }

    protected void filterNext() {
        while (this.m_iter.hasNext()) {
            this.obj = this.m_iter.next();
            if (!this.m_filter.matches(this.obj)) continue;
            this.hasNext = true;
            this.nextIndex = this.m_iter.nextIndex() - 1;
            return;
        }
        this.searchNext = true;
        this.nextIndex = this.m_iter.nextIndex();
        this.hasNext = false;
    }

    protected void filterPrevious() {
        while (this.m_iter.hasPrevious()) {
            this.obj = this.m_iter.previous();
            if (!this.m_filter.matches(this.obj)) continue;
            this.hasPrevious = true;
            this.previousIndex = this.m_iter.previousIndex() + 1;
            return;
        }
        this.previousIndex = -1;
        this.hasPrevious = false;
    }

    public static void main(String[] args) {
        LinkedList<Object> testList = new LinkedList<Object>();
        testList.add(new Integer(0));
        testList.add("A");
        testList.add("B");
        testList.add(new Integer(3));
        testList.add(new Integer(4));
        testList.add("E");
        testList.add("F");
        testList.add(new Integer(7));
        System.err.println(testList);
        IteratorFilter<Object> filter = new IteratorFilter<Object>(){

            @Override
            public boolean matches(Object o) {
                return o instanceof Integer;
            }
        };
        _FilterableListIterator<Object> i = new _FilterableListIterator<Object>(testList.listIterator(), filter);
        System.out.print("[" + i.previousIndex() + "|" + i.nextIndex() + "]->");
        while (i.hasNext()) {
            System.out.print(" " + i.next() + "<-[" + i.previousIndex() + "|" + i.nextIndex() + "]->");
        }
        System.out.println("\n");
        System.out.print("[" + i.previousIndex() + "|" + i.nextIndex() + "]->");
        while (i.hasPrevious()) {
            System.out.print(" " + i.previous() + "<-[" + i.previousIndex() + "|" + i.nextIndex() + "]->");
        }
        System.out.println("\n");
    }
}

