/*
 * Decompiled with CFR 0.152.
 */
package cib.util;

import cib.util.ObservableObject;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class ObservableObjectAdapter
implements ObservableObject,
Serializable {
    private static final long serialVersionUID = 0L;
    private Set<ObservableObject.Listener> m_listeners = new HashSet<ObservableObject.Listener>();

    @Override
    public boolean addListener(ObservableObject.Listener l) {
        return this.m_listeners.add(l);
    }

    @Override
    public boolean removeListener(ObservableObject.Listener l) {
        return this.m_listeners.remove(l);
    }

    @Override
    public void clearListeners() {
        this.m_listeners.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        Object dst = super.clone();
        ((ObservableObjectAdapter)dst).m_listeners = new HashSet<ObservableObject.Listener>();
        this._notifyWasCloned((ObservableObject)dst);
        return dst;
    }

    protected void _notifyWasChanged() {
        for (ObservableObject.Listener l : this.m_listeners) {
            l.wasChanged(this);
        }
    }

    protected void _notifyWasCloned(ObservableObject dst) {
        for (ObservableObject.Listener l : this.m_listeners) {
            l.wasCloned(this, dst);
        }
    }
}

