/*
 * Decompiled with CFR 0.152.
 */
package cib.util;

import cib.util.geo.Geo2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class CoordSpace
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static CoordSpace s_instance = null;
    private double m_scale = 100.0;
    private double m_wu = 1.0;
    private double m_nu = 10000.0;
    private AffineTransform m_userCrdTransform = new AffineTransform();
    private AffineTransform m_userToWorldTransform = null;
    private AffineTransform m_worldToUserTransform = null;
    private String m_format = "0.0###########";
    private String m_shortFormat = "0.0###";
    private transient Set<Listener> m_listeners = new HashSet<Listener>();

    private CoordSpace() {
        if (s_instance == null) {
            s_instance = this;
        }
        this._invalidate();
        this._updateGeoEps();
    }

    public static CoordSpace getCoordSpace() {
        if (s_instance == null) {
            new CoordSpace();
        }
        return s_instance;
    }

    public void setScale(double scale) {
        this.m_scale = scale;
        this._notifyScaleChanged();
    }

    public double getScale() {
        return this.m_scale;
    }

    public void setNaturalUnitsPerWorldUnit(double nuPerWu) {
        this._invalidate();
        this.m_nu = nuPerWu;
    }

    public double getNaturalUnitsPerWorldUnit() {
        return this.m_nu;
    }

    public void setMillimetersPerNaturalUnit(double mm, String format, boolean adjustNaturalUnitsPerWorldUnits) {
        double scaleNU = this.getMillimetersPerNaturalUnit() / mm;
        this.m_wu = mm / 1000.0;
        if (format == null) {
            double eps = Geo2D.getEps();
            if (1.0 - eps <= mm && mm <= 1.0 + eps) {
                this.m_format = "0.0########";
                this.m_shortFormat = "0.0";
            } else if (10.0 - eps <= mm && mm <= 10.0 + eps) {
                this.m_format = "0.0#########";
                this.m_shortFormat = "0.0#";
            } else if (100.0 - eps <= mm && mm <= 100.0 + eps) {
                this.m_format = "0.0##########";
                this.m_shortFormat = "0.0##";
            } else if (1000.0 - eps <= mm && mm <= 1000.0 + eps) {
                this.m_format = "0.0###########";
                this.m_shortFormat = "0.0###";
            } else if (1000000.0 - eps <= mm && mm <= 1000000.0 + eps) {
                this.m_format = "0.000#";
                this.m_shortFormat = "0.000#";
            } else {
                this.m_format = "0.0###########";
                this.m_shortFormat = "0.0###";
            }
        } else {
            this.m_format = format;
        }
        double[] d = new double[6];
        this.m_userCrdTransform.getMatrix(d);
        d[4] = d[4] * scaleNU;
        d[5] = d[5] * scaleNU;
        this.m_userCrdTransform.setTransform(d[0], d[1], d[2], d[3], d[4], d[5]);
        this._notifyNaturalUnitChanged();
        if (adjustNaturalUnitsPerWorldUnits) {
            this.setNaturalUnitsPerWorldUnit(this.getNaturalUnitsPerWorldUnit() * scaleNU);
        }
        this._updateGeoEps();
    }

    public double getMillimetersPerNaturalUnit() {
        return this.m_wu * 1000.0;
    }

    public String getNaturalUnitString() {
        double mms = this.getMillimetersPerNaturalUnit();
        double eps = Geo2D.getEps();
        if (1.0 - eps <= mms && mms <= 1.0 + eps) {
            return "mm";
        }
        if (10.0 - eps <= mms && mms <= 10.0 + eps) {
            return "cm";
        }
        if (100.0 - eps <= mms && mms <= 100.0 + eps) {
            return "dm";
        }
        if (1000.0 - eps <= mms && mms <= 1000.0 + eps) {
            return "m";
        }
        if (1000000.0 - eps <= mms && mms <= 1000000.0 + eps) {
            return "km";
        }
        return String.valueOf(mms) + "*mm";
    }

    public void setFormat(String format) {
        this.m_format = format;
    }

    public String getFormat() {
        return this.m_format != null ? this.m_format : "0.0###########";
    }

    public String formatCoordinate(double x) {
        DecimalFormat nf = new DecimalFormat();
        nf.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        nf.applyLocalizedPattern(this.getFormat());
        return nf.format(x);
    }

    public void setShortFormat(String format) {
        this.m_shortFormat = format;
    }

    public String getShortFormat() {
        return this.m_shortFormat != null ? this.m_shortFormat : "0.0###";
    }

    public String shortFormatCoordinate(double x) {
        DecimalFormat nf = new DecimalFormat();
        nf.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        nf.applyLocalizedPattern(this.getShortFormat());
        return nf.format(x);
    }

    public void setUserCrdTransform(AffineTransform trf) {
        this._invalidate();
        this.m_userCrdTransform.setTransform(trf);
        this._notifyUCSChanged();
    }

    public AffineTransform getUserCrdTransform() {
        return (AffineTransform)this.m_userCrdTransform.clone();
    }

    public AffineTransform getWorldToUserTransform() {
        this._validate();
        return (AffineTransform)this.m_worldToUserTransform.clone();
    }

    public AffineTransform getUserToWorldTransform() {
        this._validate();
        return (AffineTransform)this.m_userToWorldTransform.clone();
    }

    public double angleToWorld(double angle) {
        this._validate();
        Point2D.Double o = new Point2D.Double();
        Point2D.Double x = new Point2D.Double(1.0, 0.0);
        Point2D ot = this.m_userToWorldTransform.transform(o, null);
        Point2D xt = this.m_userToWorldTransform.transform(x, null);
        double _angle = Math.atan2(xt.getY() - ot.getY(), xt.getX() - ot.getX());
        return (angle + _angle) % (Math.PI * 2);
    }

    public double angleToUser(double angle) {
        double _angle = this.angleToWorld(0.0);
        return (angle - _angle) % (Math.PI * 2);
    }

    private void _invalidate() {
        this.m_worldToUserTransform = null;
        this.m_userToWorldTransform = null;
    }

    private void _validate() {
        if (this.m_worldToUserTransform != null) {
            return;
        }
        try {
            double scale = this.m_nu;
            this.m_worldToUserTransform = AffineTransform.getScaleInstance(scale, scale);
            this.m_worldToUserTransform.preConcatenate(this.m_userCrdTransform.createInverse());
            this.m_userToWorldTransform = this.m_worldToUserTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalStateException("Uncatchable error");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._updateGeoEps();
        this.m_listeners = new HashSet<Listener>();
        s_instance = this;
    }

    public boolean addListener(Listener l) {
        return this.m_listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.m_listeners.remove(l);
    }

    private void _notifyUCSChanged() {
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().ucsChanged(this.getUserCrdTransform());
        }
    }

    private void _notifyScaleChanged() {
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().scaleChanged(this.m_scale);
        }
    }

    private void _notifyNaturalUnitChanged() {
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().naturalUnitChanged(this.m_wu * 1000.0);
        }
    }

    private void _updateGeoEps() {
        Geo2D.setEps(0.001 / this.getMillimetersPerNaturalUnit());
    }

    public static interface Listener {
        public void ucsChanged(AffineTransform var1);

        public void scaleChanged(double var1);

        public void naturalUnitChanged(double var1);
    }
}

