/*
 * Decompiled with CFR 0.152.
 */
package cib.util;

import cib.util.AttributedShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class AttributedShapeSerializable
extends AttributedShape
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int END_OF_COMPONENT = -1;

    public AttributedShapeSerializable(Shape shape) {
        super(shape);
    }

    public AttributedShapeSerializable(AttributedShapeSerializable as) {
        super(as);
    }

    public AttributedShapeSerializable(Shape shape, BasicStroke stroke, Color draw, Color fill) {
        super(shape, stroke, draw, fill);
    }

    @Override
    public Object clone() {
        AttributedShapeSerializable clone = (AttributedShapeSerializable)super.clone();
        return clone;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int windingRule = this.m_shape instanceof Path2D ? ((Path2D)this.m_shape).getWindingRule() : 1;
        out.writeInt(windingRule);
        double[] coord = new double[6];
        PathIterator it = this.m_shape.getPathIterator(null);
        while (!it.isDone()) {
            int seg = it.currentSegment(coord);
            out.writeInt(seg);
            int nCoord = 0;
            switch (seg) {
                case 0: 
                case 1: {
                    nCoord = 2;
                    break;
                }
                case 2: {
                    nCoord = 4;
                    break;
                }
                case 3: {
                    nCoord = 6;
                    break;
                }
                case 4: {
                    nCoord = 0;
                    break;
                }
                default: {
                    throw new Error("Unexpected segment type");
                }
            }
            int i = 0;
            while (i < nCoord) {
                out.writeDouble(coord[i]);
                ++i;
            }
            it.next();
        }
        out.writeInt(-1);
        Stroke stroke = this.m_stroke;
        if (stroke == null || stroke instanceof Serializable) {
            out.writeObject(stroke);
            out.writeBoolean(false);
        } else if (stroke instanceof BasicStroke) {
            out.writeObject(null);
            out.writeBoolean(true);
            BasicStroke basicStroke = (BasicStroke)stroke;
            out.writeFloat(basicStroke.getLineWidth());
            out.writeInt(basicStroke.getEndCap());
            out.writeInt(basicStroke.getLineJoin());
            out.writeFloat(basicStroke.getMiterLimit());
            out.writeObject(basicStroke.getDashArray());
            out.writeFloat(basicStroke.getDashPhase());
        } else {
            out.writeObject(null);
            out.writeBoolean(false);
        }
        Paint draw = this.m_draw;
        if (draw != null && !(draw instanceof Serializable)) {
            draw = null;
        }
        out.writeObject(draw);
        Paint fill = this.m_fill;
        if (fill != null && !(fill instanceof Serializable)) {
            fill = null;
        }
        out.writeObject(fill);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int windingRule = in.readInt();
        Path2D.Double path = new Path2D.Double(windingRule);
        this.m_shape = null;
        while (this.m_shape == null) {
            int seg = in.readInt();
            switch (seg) {
                case 0: {
                    ((Path2D)path).moveTo(in.readDouble(), in.readDouble());
                    break;
                }
                case 1: {
                    ((Path2D)path).lineTo(in.readDouble(), in.readDouble());
                    break;
                }
                case 2: {
                    ((Path2D)path).quadTo(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
                    break;
                }
                case 3: {
                    ((Path2D)path).curveTo(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
                case -1: {
                    this.m_shape = path;
                    break;
                }
                default: {
                    throw new Error("Unexpected segment type");
                }
            }
        }
        this.m_stroke = (Stroke)in.readObject();
        if (in.readBoolean()) {
            this.m_stroke = new BasicStroke(in.readFloat(), in.readInt(), in.readInt(), in.readFloat(), (float[])in.readObject(), in.readFloat());
        }
        this.m_draw = (Paint)in.readObject();
        this.m_fill = (Paint)in.readObject();
    }

    @Override
    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        super.setShape(shape);
    }

    @Override
    public void setDrawPaint(Paint paint) {
        if (paint != null && !(paint instanceof Serializable)) {
            throw new IllegalArgumentException();
        }
        super.setDrawPaint(paint);
    }

    @Override
    public void setFillPaint(Paint paint) {
        if (paint != null && !(paint instanceof Serializable)) {
            throw new IllegalArgumentException();
        }
        super.setFillPaint(paint);
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (stroke != null && !(stroke instanceof Serializable) && !(stroke instanceof BasicStroke)) {
            throw new IllegalArgumentException();
        }
        super.setStroke(stroke);
    }
}

