/*
 * Decompiled with CFR 0.152.
 */
package cib.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class AttributedImage
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    private static Object s_stream = null;
    private static List<File> s_sharedFiles = null;
    private static List<BufferedImage> s_sharedImages = null;
    private transient BufferedImage m_bi = null;
    private transient File m_originalFile = null;
    private transient File m_physicalFile = null;
    private double m_width = 1.0;
    private double m_height = 1.0;
    private AffineTransform m_trf = new AffineTransform();

    public AttributedImage() {
    }

    public AttributedImage(double width, double height, AffineTransform trf) {
        this.setImageSize(width, height);
        this.setTransform((AffineTransform)trf.clone());
        this.m_trf = trf;
    }

    public Object clone() {
        AttributedImage clonedObject;
        try {
            clonedObject = (AttributedImage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        this.m_trf = (AffineTransform)this.m_trf.clone();
        return clonedObject;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int bufId;
        out.defaultWriteObject();
        out.writeObject(this.m_originalFile);
        if (s_stream != out) {
            s_stream = out;
            s_sharedFiles = new ArrayList<File>();
        }
        if ((bufId = s_sharedFiles.indexOf(this.m_physicalFile)) != -1) {
            out.writeInt(bufId);
            out.writeLong(0L);
            return;
        }
        s_sharedFiles.add(this.m_physicalFile);
        bufId = s_sharedFiles.size() - 1;
        out.writeInt(bufId);
        RandomAccessFile raf = new RandomAccessFile(this.m_physicalFile, "r");
        long bufLen = raf.length();
        out.writeLong(bufLen);
        int LEN = 1024;
        byte[] buf = new byte[1024];
        long i = 0L;
        while (i < bufLen) {
            int len = i + 1024L < bufLen ? 1024 : (int)(bufLen - i);
            raf.read(buf, 0, len);
            out.write(buf, 0, len);
            i += 1024L;
        }
        raf.close();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_originalFile = (File)in.readObject();
        if (s_stream != in) {
            s_stream = in;
            s_sharedFiles = new ArrayList<File>();
            s_sharedImages = new ArrayList<BufferedImage>();
        }
        int bufId = in.readInt();
        long bufLen = in.readLong();
        if (bufId < s_sharedFiles.size()) {
            this.m_physicalFile = s_sharedFiles.get(bufId);
            this.m_bi = s_sharedImages.get(bufId);
            return;
        }
        if (this.m_originalFile.exists()) {
            this.m_physicalFile = this.m_originalFile;
            in.skip(bufLen);
        } else {
            this.m_physicalFile = File.createTempFile("cademia", "_" + this.m_originalFile.getName());
            RandomAccessFile raf = new RandomAccessFile(this.m_physicalFile, "rw");
            long i = 0L;
            while (i < bufLen) {
                raf.write(in.read());
                ++i;
            }
            raf.close();
        }
        this.m_bi = ImageIO.read(this.m_physicalFile);
        s_sharedFiles.add(this.m_physicalFile);
        s_sharedImages.add(this.m_bi);
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.m_trf.clone();
    }

    public void setTransform(AffineTransform trf) {
        this.m_trf = (AffineTransform)trf.clone();
    }

    public BufferedImage getImage() {
        return this.m_bi;
    }

    public void setImageFile(File file) throws IOException {
        this.m_bi = ImageIO.read(file);
        this.m_originalFile = file;
        this.m_physicalFile = file;
    }

    public File getOriginalImageFile() {
        return this.m_originalFile;
    }

    public File getPhysicalImageFile() {
        return this.m_physicalFile;
    }

    public void transformBy(AffineTransform at) {
        this.m_trf.preConcatenate(at);
    }

    public void setImageSize(double width, double height) {
        this.m_width = width;
        this.m_height = height;
    }

    public double getWidth() {
        return this.m_width;
    }

    public double getHeight() {
        return this.m_height;
    }

    public void cornerPoints(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        p1.setLocation(0.0, 0.0);
        p2.setLocation(this.m_width, 0.0);
        p3.setLocation(this.m_width, this.m_height);
        p4.setLocation(0.0, this.m_height);
        this.m_trf.transform(p1, p1);
        this.m_trf.transform(p2, p2);
        this.m_trf.transform(p3, p3);
        this.m_trf.transform(p4, p4);
    }
}

