/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view.cmds;

import cib.cad.kernel.InputDeviceAdapter;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.view.GraphicalUserInterface;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.view.ToolBarLayout;
import cib.util.view.ViewUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public abstract class AddToolBar
extends CmdAdapter {
    public static final int INPUT = 0;
    public static final int COMMAND = 1;
    public static final int INTERRUPTING_COMMAND = 2;
    protected JToolBar m_toolBar;
    protected InputDeviceAdapter m_inputDevice;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        GraphicalUserInterface gui = (GraphicalUserInterface)ui;
        if (gui.getToolBarPanel() == null) {
            gui.createToolBarPanel();
        }
        this.m_inputDevice = new InputDeviceAdapter();
        this.m_inputDevice.setEnabled(false);
        JPanel tbp = gui.getToolBarPanel();
        ToolBarLayout layout = new ToolBarLayout();
        layout.setAlignment(0);
        layout.setHgap(2);
        layout.setVgap(2);
        tbp.setLayout(layout);
        this._addToolBar(context);
        ViewUtilities.enableMenuIcons(true);
        tbp.revalidate();
        this.m_inputDevice.setEnabled(true);
    }

    protected void fireInput(String input) {
        if (this.m_inputDevice.isEnabled()) {
            this.m_inputDevice.fireInput(input);
        }
    }

    protected abstract void _addToolBar(Object var1);

    protected URL getImageURL(String path) {
        return AddToolBar.class.getClassLoader().getResource(path);
    }

    protected boolean containsToolBar(JPanel panel, String name) {
        Component[] tbpComps = panel.getComponents();
        int i = 0;
        while (i < tbpComps.length) {
            Component c = tbpComps[i];
            if (c instanceof JToolBar && ((JToolBar)c).getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected class _CmdListener
    implements ActionListener {
        private String m_cmd = null;
        private int m_inputType = 2;

        public _CmdListener(String cmd) {
            this.m_cmd = cmd;
        }

        public _CmdListener(String cmd, int inputType) {
            this.m_cmd = cmd;
            this.m_inputType = inputType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddToolBar.this.m_inputDevice.isEnabled()) {
                switch (this.m_inputType) {
                    case 1: {
                        AddToolBar.this.m_inputDevice.fireInput(String.valueOf(this.m_cmd) + ";setagain " + this.m_cmd);
                        break;
                    }
                    case 2: {
                        AddToolBar.this.m_inputDevice.fireInterruptingInput(String.valueOf(this.m_cmd) + ";setagain " + this.m_cmd);
                        break;
                    }
                    default: {
                        AddToolBar.this.m_inputDevice.fireInput(this.m_cmd);
                    }
                }
            }
        }
    }
}

