/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view.cmds;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.cad.view.GraphicalUserInterface;
import cib.cad.view.cmds.AddToolBar;
import cib.util.coll.ObservableSet;
import cib.util.view.ViewUtilities;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class AddSelectToolBar
extends AddToolBar {
    public static final String NAME = "Selection";

    @Override
    protected void _addToolBar(Object context) {
        final Kernel krnl = (Kernel)context;
        GraphicalUserInterface gui = (GraphicalUserInterface)krnl.getUserInterface();
        JPanel tbp = gui.getToolBarPanel();
        if (this.containsToolBar(tbp, NAME)) {
            System.err.println(String.valueOf(Messages.getString("view.cmds.AddSelectToolBar.1")) + NAME + Messages.getString("view.cmds.AddSelectToolBar.2"));
            return;
        }
        gui.addInputDevice(this.m_inputDevice);
        this.m_toolBar = new JToolBar(NAME);
        this.m_toolBar.setRollover(true);
        final JButton selectAllButton = ViewUtilities.createImageButton("SelectAll", this.getImageURL("cib/cad/img/selectall.gif"), Messages.getString("view.cmds.AddSelectToolBar.5"));
        selectAllButton.addActionListener(new AddToolBar._CmdListener(this, "selectall"));
        this.m_toolBar.add(selectAllButton);
        final JButton selectByNameButton = ViewUtilities.createImageButton("SelectByName", this.getImageURL("cib/cad/img/selectbyname.gif"), Messages.getString("view.cmds.AddSelectToolBar.9"));
        selectByNameButton.addActionListener(new AddToolBar._CmdListener(this, "selectbyname"));
        this.m_toolBar.add(selectByNameButton);
        final JButton selectByPickButton = ViewUtilities.createImageButton("SelectByPick", this.getImageURL("cib/cad/img/selectbypick.gif"), Messages.getString("view.cmds.AddSelectToolBar.13"));
        selectByPickButton.addActionListener(new AddToolBar._CmdListener(this, "selectbypick"));
        this.m_toolBar.add(selectByPickButton);
        this.m_toolBar.addSeparator();
        final JButton unselectAllButton = ViewUtilities.createImageButton("UnselectAll", this.getImageURL("cib/cad/img/unselectall.gif"), Messages.getString("view.cmds.AddSelectToolBar.17"));
        unselectAllButton.addActionListener(new AddToolBar._CmdListener(this, "unselectall"));
        this.m_toolBar.add(unselectAllButton);
        final JButton unselectByNameButton = ViewUtilities.createImageButton("UnselectByName", this.getImageURL("cib/cad/img/unselectbyname.gif"), Messages.getString("view.cmds.AddSelectToolBar.21"));
        unselectByNameButton.addActionListener(new AddToolBar._CmdListener(this, "unselectbyname"));
        this.m_toolBar.add(unselectByNameButton);
        final JButton unselectByPickButton = ViewUtilities.createImageButton("UnselectByPick", this.getImageURL("cib/cad/img/unselectbypick.gif"), Messages.getString("view.cmds.AddSelectToolBar.25"));
        unselectByPickButton.addActionListener(new AddToolBar._CmdListener(this, "unselectbypick"));
        this.m_toolBar.add(unselectByPickButton);
        krnl.addListener(new Kernel.Listener(){

            @Override
            public void cmdEnds(String cmdName) {
                Database db = krnl.getDatabase();
                ObservableSet<Component> compSet = db.getComponentSet();
                ObservableSet<Component> selSet = db.getSelectSet();
                selectAllButton.setEnabled(compSet.size() != selSet.size());
                selectByNameButton.setEnabled(compSet.size() != selSet.size());
                selectByPickButton.setEnabled(compSet.size() != selSet.size());
                unselectAllButton.setEnabled(!selSet.isEmpty());
                unselectByNameButton.setEnabled(!selSet.isEmpty());
                unselectByPickButton.setEnabled(!selSet.isEmpty());
            }
        });
        tbp.add(this.m_toolBar);
    }
}

