/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view.cmds;

import cib.cad.kernel.InputDeviceAdapter;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.view.GraphicalUserInterface;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public abstract class AddMenu
extends CmdAdapter {
    public static final int INPUT = 0;
    public static final int COMMAND = 1;
    public static final int INTERRUPTING_COMMAND = 2;
    protected JMenu m_menu;
    protected InputDeviceAdapter m_inputDevice;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        GraphicalUserInterface gui = (GraphicalUserInterface)ui;
        if (gui.getJMenuBar() == null) {
            gui.setJMenuBar(new JMenuBar());
        }
        this.m_inputDevice = new InputDeviceAdapter(){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
            }
        };
        this._addMenu(context);
    }

    protected void fireInput(String input) {
        if (this.m_inputDevice.isEnabled()) {
            this.m_inputDevice.fireInput(input);
        }
    }

    protected abstract void _addMenu(Object var1);

    protected URL getImageURL(String path) {
        return AddMenu.class.getClassLoader().getResource(path);
    }

    protected boolean containsMenu(JMenuBar menuBar, String name) {
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            JMenu m = menuBar.getMenu(i);
            if (m.getText().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected class _CmdListener
    implements ActionListener {
        private String m_cmd = null;
        private int m_inputType = 2;

        public _CmdListener(String cmd) {
            this.m_cmd = cmd;
        }

        public _CmdListener(String cmd, int inputType) {
            this.m_cmd = cmd;
            this.m_inputType = inputType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddMenu.this.m_inputDevice.isEnabled()) {
                switch (this.m_inputType) {
                    case 1: {
                        AddMenu.this.m_inputDevice.fireInput(String.valueOf(this.m_cmd) + ";setagain " + this.m_cmd);
                        break;
                    }
                    case 2: {
                        AddMenu.this.m_inputDevice.fireInterruptingInput(String.valueOf(this.m_cmd) + ";setagain " + this.m_cmd);
                        break;
                    }
                    default: {
                        AddMenu.this.m_inputDevice.fireInput(this.m_cmd);
                    }
                }
            }
        }
    }
}

