/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.InputDevice;
import cib.cad.kernel.InputDeviceAdapter;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.ViewController;
import cib.cad.lang.Messages;
import cib.cad.view.CmdLineDialogPanel;
import cib.cad.view.Desktop;
import cib.cad.view.DrawPanel;
import cib.cad.view.ErrorMessagePrintStream;
import cib.cad.view.InfoAreaPrintStream;
import cib.cad.view.InputManager;
import cib.util.coll.ObservableSet;
import cib.util.geo.Vector2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class GraphicalUserInterface
extends JFrame
implements UserInterface {
    private static final long serialVersionUID = 0L;
    private Desktop m_desktop;
    private final JTextArea m_infoArea = new JTextArea();
    private JScrollPane m_scrollPane = new JScrollPane();
    private JSplitPane m_splitPane = new JSplitPane();
    private JPanel m_toolbarPanel = null;
    private JPanel m_northPanel = new JPanel(new BorderLayout());
    private JPanel m_statusBar = new JPanel(new BorderLayout());
    private final JLabel m_locatorLabel = new JLabel("");
    private final JLabel m_componentLabel = new JLabel("");
    private final JTextField m_outputTextField = new JTextField();
    private BorderLayout m_borderLayout = new BorderLayout();
    private boolean m_isAnnotationsEnabled = true;
    private CmdLineDialogPanel m_cmdLineDialogPanel = null;
    private String m_applicationTitle = "";
    private Kernel m_krnl = null;
    private InputManager m_inputManager = null;
    private InfoAreaPrintStream m_out = null;
    private ErrorMessagePrintStream m_err = null;
    private PrintStream m_svout = System.out;
    private PrintStream m_sverr = System.err;
    private Set<cib.cad.db.comp.Component> m_addedElements = new HashSet<cib.cad.db.comp.Component>();
    private Set<cib.cad.db.comp.Component> m_changedElements = new HashSet<cib.cad.db.comp.Component>();
    private Set<cib.cad.db.comp.Component> m_removedElements = new HashSet<cib.cad.db.comp.Component>();
    private Map<Class<cib.cad.db.comp.Component>, Class<ViewController>> m_viewCtrlAssignment = new HashMap<Class<cib.cad.db.comp.Component>, Class<ViewController>>();
    private static final boolean IS_MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");

    public GraphicalUserInterface(Kernel krnl) {
        this.constructGui(krnl);
    }

    public GraphicalUserInterface(Kernel krnl, GraphicsConfiguration gc) {
        super(gc);
        this.constructGui(krnl);
    }

    public GraphicalUserInterface(Kernel krnl, String title) {
        super(title);
        this.constructGui(krnl);
    }

    public GraphicalUserInterface(Kernel krnl, String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.constructGui(krnl);
    }

    private void constructGui(Kernel krnl) {
        this.m_krnl = krnl;
        this.setDefaultCloseOperation(0);
        this.setSize(640, 450);
        try {
            this.m_viewCtrlAssignment.put(Class.forName("cib.cad.db.comp.Component"), Class.forName("cib.cad.view.BasicViewController"));
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(Messages.getString("view.GraphicalUserInterface.6"));
        }
        this.m_desktop = new Desktop(this.m_krnl);
        this.m_infoArea.setLineWrap(true);
        this.m_infoArea.setEditable(false);
        this.m_infoArea.setWrapStyleWord(true);
        this.m_infoArea.setFont(new Font("sansserif", 0, 12));
        this.m_scrollPane.setHorizontalScrollBarPolicy(31);
        this.m_scrollPane.getViewport().add((Component)this.m_infoArea, null);
        this.m_scrollPane.setPreferredSize(new Dimension(this.getWidth(), 0));
        this.m_scrollPane.setMinimumSize(new Dimension(this.getWidth(), 0));
        this.m_desktop.setBackground(Color.WHITE);
        this.m_splitPane.setOrientation(0);
        this.m_splitPane.setBottomComponent(this.m_scrollPane);
        this.m_splitPane.setResizeWeight(1.0);
        this.m_splitPane.setTopComponent(this.m_desktop);
        this.m_splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_splitPane.setDividerSize(5);
        this.m_splitPane.setDividerLocation(1.0);
        this.setLayout(this.m_borderLayout);
        this.add((Component)this.m_splitPane, "Center");
        this.m_cmdLineDialogPanel = new CmdLineDialogPanel();
        this.m_cmdLineDialogPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.m_northPanel.add((Component)this.m_cmdLineDialogPanel, "South");
        this.add((Component)this.m_northPanel, "North");
        this.m_inputManager = new InputManager(this.m_krnl, this.m_cmdLineDialogPanel);
        this.m_locatorLabel.setFont(new Font("sansserif", 0, 10));
        this.m_locatorLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.m_componentLabel.setFont(new Font("sansserif", 0, 10));
        this.m_componentLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.m_outputTextField.setEditable(false);
        this.m_outputTextField.setFont(new Font("sansserif", 0, 10));
        this.m_outputTextField.setBackground(this.getBackground());
        this.m_outputTextField.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.m_statusBar.add((Component)this.m_locatorLabel, "West");
        this.m_statusBar.add((Component)this.m_outputTextField, "Center");
        this.m_statusBar.add((Component)this.m_componentLabel, "East");
        this.m_statusBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 6, 0));
        this.add((Component)this.m_statusBar, "South");
        this.m_out = new InfoAreaPrintStream(this.m_infoArea, this.m_outputTextField);
        System.setOut(this.m_out);
        this.m_err = new ErrorMessagePrintStream(this);
        System.setErr(this.m_err);
        final InputDeviceAdapter frameCloser = new InputDeviceAdapter();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frameCloser.fireInput("exit");
            }
        });
        this.addInputDevice(frameCloser);
    }

    @Override
    public void setVisible(boolean show) {
        super.setVisible(show);
        super.toFront();
        Database db = this.m_krnl.getDatabase();
        ObservableSet<cib.cad.db.comp.Component> cmpSet = db.getComponentSet();
        ObservableSet<cib.cad.db.comp.Component> selSet = db.getSelectSet();
        MarkerMap markerMap = db.getMarkerMap();
        this._loadAllViews();
        final ObservableSet.Listener<cib.cad.db.comp.Component> csl = new ObservableSet.Listener<cib.cad.db.comp.Component>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasAdded(cib.cad.db.comp.Component o) {
                if (GraphicalUserInterface.this.m_changedElements.contains(o)) {
                    return;
                }
                if (GraphicalUserInterface.this.m_removedElements.contains(o)) {
                    GraphicalUserInterface.this.m_removedElements.remove(o);
                }
                GraphicalUserInterface.this.m_addedElements.add(o);
            }

            @Override
            public void wasChanged(cib.cad.db.comp.Component o) {
                if (GraphicalUserInterface.this.m_addedElements.contains(o)) {
                    return;
                }
                if (GraphicalUserInterface.this.m_removedElements.contains(o)) {
                    return;
                }
                GraphicalUserInterface.this.m_changedElements.add(o);
            }

            @Override
            public void wasRemoved(cib.cad.db.comp.Component o) {
                if (GraphicalUserInterface.this.m_addedElements.contains(o)) {
                    GraphicalUserInterface.this.m_addedElements.remove(o);
                    return;
                }
                if (GraphicalUserInterface.this.m_changedElements.contains(o)) {
                    GraphicalUserInterface.this.m_changedElements.remove(o);
                }
                GraphicalUserInterface.this.m_removedElements.add(o);
            }
        };
        cmpSet.addListener(csl);
        final ObservableSet.Listener<cib.cad.db.comp.Component> ssl = new ObservableSet.Listener<cib.cad.db.comp.Component>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void wasAdded(cib.cad.db.comp.Component o) {
                if (GraphicalUserInterface.this.m_addedElements.contains(o)) {
                    return;
                }
                if (GraphicalUserInterface.this.m_removedElements.contains(o)) {
                    throw new IllegalArgumentException();
                }
                GraphicalUserInterface.this.m_changedElements.add(o);
            }

            @Override
            public void wasRemoved(cib.cad.db.comp.Component o) {
                if (GraphicalUserInterface.this.m_addedElements.contains(o) || GraphicalUserInterface.this.m_removedElements.contains(o)) {
                    return;
                }
                GraphicalUserInterface.this.m_changedElements.add(o);
            }
        };
        selSet.addListener(ssl);
        final MarkerMap.Listener mml = new MarkerMap.Listener(){

            @Override
            public void markerWasChanged(cib.cad.db.comp.Component o) {
                if (GraphicalUserInterface.this.m_addedElements.contains(o)) {
                    return;
                }
                if (GraphicalUserInterface.this.m_removedElements.contains(o)) {
                    throw new IllegalArgumentException();
                }
                GraphicalUserInterface.this.m_changedElements.add(o);
            }
        };
        markerMap.addListener(mml);
        this.m_krnl.addListener(new Kernel.Listener(){

            @Override
            public void loadStarts() {
                Database _db = GraphicalUserInterface.this.m_krnl.getDatabase();
                ObservableSet<cib.cad.db.comp.Component> _cmpSet = _db.getComponentSet();
                ObservableSet<cib.cad.db.comp.Component> _selSet = _db.getSelectSet();
                MarkerMap _mm = _db.getMarkerMap();
                _cmpSet.removeListener(csl);
                _selSet.removeListener(ssl);
                _mm.removeListener(mml);
            }

            @Override
            public void loadEnds() {
                GraphicalUserInterface.this._clearViews();
                GraphicalUserInterface.this.m_addedElements.clear();
                GraphicalUserInterface.this.m_changedElements.clear();
                GraphicalUserInterface.this.m_removedElements.clear();
                Database _db = GraphicalUserInterface.this.m_krnl.getDatabase();
                ObservableSet<cib.cad.db.comp.Component> _cmpSet = _db.getComponentSet();
                ObservableSet<cib.cad.db.comp.Component> _selSet = _db.getSelectSet();
                MarkerMap _mm = _db.getMarkerMap();
                _cmpSet.addListener(csl);
                _selSet.addListener(ssl);
                _mm.addListener(mml);
                GraphicalUserInterface.this._loadAllViews();
            }

            @Override
            public void storeStarts() {
                Database _db = GraphicalUserInterface.this.m_krnl.getDatabase();
                ObservableSet<cib.cad.db.comp.Component> _cmpSet = _db.getComponentSet();
                ObservableSet<cib.cad.db.comp.Component> _selSet = _db.getSelectSet();
                MarkerMap _mm = _db.getMarkerMap();
                _cmpSet.removeListener(csl);
                _selSet.removeListener(ssl);
                _mm.removeListener(mml);
            }

            @Override
            public void storeEnds() {
                Database _db = GraphicalUserInterface.this.m_krnl.getDatabase();
                ObservableSet<cib.cad.db.comp.Component> _cmpSet = _db.getComponentSet();
                ObservableSet<cib.cad.db.comp.Component> _selSet = _db.getSelectSet();
                MarkerMap _mm = _db.getMarkerMap();
                _cmpSet.addListener(csl);
                _selSet.addListener(ssl);
                _mm.addListener(mml);
            }

            @Override
            public void cmdStarts(String cmdName) {
                GraphicalUserInterface.this.m_cmdLineDialogPanel._setProgressEnabled(true);
            }

            @Override
            public void cmdEnds(String cmdName) {
                GraphicalUserInterface.this.m_cmdLineDialogPanel._setProgressEnabled(false);
            }
        });
    }

    public JPanel createToolBarPanel() {
        if (this.m_toolbarPanel == null) {
            this.m_toolbarPanel = new JPanel();
            this.m_toolbarPanel.setBorder(new EmptyBorder(0, 0, 3, 0));
            this.m_northPanel.add((Component)this.m_toolbarPanel, "North");
        }
        return this.m_toolbarPanel;
    }

    public JPanel getToolBarPanel() {
        return this.m_toolbarPanel;
    }

    public PrintStream getSavedOut() {
        return this.m_svout;
    }

    public PrintStream getSavedErr() {
        return this.m_sverr;
    }

    public void finish() {
        System.setOut(this.m_svout);
        System.setErr(this.m_sverr);
    }

    public void clearInfoArea() {
        try {
            Document doc = this.m_infoArea.getDocument();
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Desktop getDesktop() {
        return this.m_desktop;
    }

    @Override
    public boolean addInputDevice(InputDevice device) {
        return this.m_inputManager.addInputDevice(device);
    }

    @Override
    public boolean removeInputDevice(InputDevice device) {
        return this.m_inputManager.removeInputDevice(device);
    }

    @Override
    public String promptForCommand(String prompt) {
        return this.m_inputManager.promptForCommand(prompt);
    }

    @Override
    public CmdLineDialog getCmdLineDialog() {
        return this.m_inputManager.getCmdLineDialog();
    }

    @Override
    public void showCmdLineDialog(CmdLineDialog dlg) {
        this.m_inputManager.showCmdLineDialog(dlg);
    }

    @Override
    public CmdLineDialog getActiveCmdLineDialogAt(int index) {
        return this.m_inputManager.getActiveCmdLineDialogAt(index);
    }

    @Override
    public void disposeCmdLineDialog() {
        this.m_inputManager.disposeCmdLineDialog();
    }

    @Override
    public void consumeArgsByCmdLineDialog() {
        this.m_inputManager.consumeArgsByCmdLineDialog();
    }

    public boolean isInGraphicMode() {
        return true;
    }

    @Override
    public void enableDrawing(boolean on) {
        this.m_isAnnotationsEnabled = on;
    }

    @Override
    public boolean isDrawingEnabled() {
        return this.m_isAnnotationsEnabled;
    }

    @Override
    public void repaintUserInterface() {
        if (!this.isDrawingEnabled()) {
            return;
        }
        this._clearViews();
        this._loadAllViews();
    }

    @Override
    public void updateUserInterface() {
        String database;
        if (!this.isDrawingEnabled()) {
            return;
        }
        Iterator<cib.cad.db.comp.Component> it = this.m_removedElements.iterator();
        while (it.hasNext()) {
            this._removeViews(it.next());
        }
        this.m_removedElements.clear();
        it = this.m_changedElements.iterator();
        while (it.hasNext()) {
            this._updateViews(it.next());
        }
        this.m_changedElements.clear();
        it = this.m_addedElements.iterator();
        while (it.hasNext()) {
            this._putViews(it.next());
        }
        this.m_addedElements.clear();
        String title = "CADEMIA";
        String appTitle = this.getApplicationTitle();
        if (appTitle != null && appTitle.length() != 0) {
            title = String.valueOf(title) + " -- " + appTitle;
        }
        if ((database = this.m_krnl.getDatabasePathname()) == null || database.length() == 0) {
            database = Messages.getString("view.GraphicalUserInterface.14");
        }
        title = String.valueOf(title) + " -- " + database;
        if (IS_MAC_OS_X) {
            this.getRootPane().putClientProperty("windowModified", this.m_krnl.databaseChanged());
        } else if (this.m_krnl.databaseChanged()) {
            title = String.valueOf(title) + "*";
        }
        this.setTitle(title);
        Database db = this.m_krnl.getDatabase();
        ObservableSet<cib.cad.db.comp.Component> cmpSet = db.getComponentSet();
        ObservableSet<cib.cad.db.comp.Component> selSet = db.getSelectSet();
        String text = String.valueOf(Messages.getString("view.GraphicalUserInterface.20")) + selSet.size() + Messages.getString("view.GraphicalUserInterface.21") + cmpSet.size() + (this.m_krnl.getOpenGroupCount() > 0 ? Messages.getString("view.GraphicalUserInterface.22") : Messages.getString("view.GraphicalUserInterface.23"));
        if (this.m_krnl.getOpenGroupCount() > 1) {
            text = String.valueOf(text) + " (" + this.m_krnl.getOpenGroupCount() + ")";
        }
        this.m_componentLabel.setText(text);
        this._updatePanels();
    }

    @Override
    public void draw(Point2D pnt) {
        this._draw(pnt, true);
    }

    @Override
    public void undraw(Point2D pnt) {
        this._draw(pnt, false);
    }

    private void _draw(Point2D pnt, boolean on) {
        if (!this.isDrawingEnabled()) {
            return;
        }
        Iterator<GeometryPanel> gpit = this.geometryPanelIterator();
        while (gpit.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)gpit.next();
            if (on) {
                drawPanel.draw(pnt);
                continue;
            }
            drawPanel.undraw(pnt);
        }
    }

    @Override
    public void draw(Shape shp) {
        this._draw(shp, true);
    }

    @Override
    public void undraw(Shape shp) {
        this._draw(shp, false);
    }

    private void _draw(Shape shp, boolean on) {
        if (!this.isDrawingEnabled()) {
            return;
        }
        Iterator<GeometryPanel> gpit = this.geometryPanelIterator();
        while (gpit.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)gpit.next();
            if (on) {
                drawPanel.draw(shp);
                continue;
            }
            drawPanel.undraw(shp);
        }
    }

    @Override
    public void drawLine(Line2D lin) {
        this._drawLine(lin, true);
    }

    @Override
    public void undrawLine(Line2D lin) {
        this._drawLine(lin, false);
    }

    private void _drawLine(Line2D lin, boolean on) {
        if (!this.isDrawingEnabled()) {
            return;
        }
        Iterator<GeometryPanel> gpit = this.geometryPanelIterator();
        while (gpit.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)gpit.next();
            if (on) {
                drawPanel.drawLine(lin);
                continue;
            }
            drawPanel.undrawLine(lin);
        }
    }

    @Override
    public void drawVector(Vector2D vec, Point2D at) {
        this._drawVector(vec, at, true);
    }

    @Override
    public void undrawVector(Vector2D vec) {
        this._drawVector(vec, null, false);
    }

    private void _drawVector(Vector2D vec, Point2D at, boolean on) {
        if (!this.isDrawingEnabled()) {
            return;
        }
        Iterator<GeometryPanel> gpit = this.geometryPanelIterator();
        while (gpit.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)gpit.next();
            if (on) {
                drawPanel.drawVector(vec, at);
                continue;
            }
            drawPanel.undrawVector(vec);
        }
    }

    @Override
    public Point getUpperLeftLocationOnScreen(Point p) {
        if (p == null) {
            p = new Point();
        }
        if (IS_MAC_OS_X) {
            p.setLocation(this.m_splitPane.getLocationOnScreen());
            p.y += 22;
        } else {
            int y = (int)this.getLocationOnScreen().getY() + this.getInsets().top;
            if (this.getJMenuBar() != null) {
                y += this.getJMenuBar().getPreferredSize().height;
            }
            if (this.getToolBarPanel() != null) {
                y += this.getToolBarPanel().getPreferredSize().height;
            }
            int x = (int)this.getLocationOnScreen().getX() + this.getInsets().left;
            p.setLocation(x, y);
        }
        return p;
    }

    @Override
    public Iterator<GeometryPanel> geometryPanelIterator() {
        return this.m_desktop.panelIterator();
    }

    @Override
    public void setApplicationTitle(String title) {
        this.m_applicationTitle = title;
    }

    @Override
    public String getApplicationTitle() {
        return this.m_applicationTitle;
    }

    @Override
    public void showLocatorPosition(String pos) {
        this.m_locatorLabel.setText(pos);
    }

    @Override
    public Class<ViewController> putViewControllerAssignment(Class<cib.cad.db.comp.Component> comp, Class<ViewController> viewCtrl) {
        return this.m_viewCtrlAssignment.put(comp, viewCtrl);
    }

    @Override
    public Class<ViewController> getViewControllerClass(Class<cib.cad.db.comp.Component> comp) {
        return this.m_viewCtrlAssignment.get(comp);
    }

    @Override
    public Class<ViewController> removeViewControllerAssignment(Class<cib.cad.db.comp.Component> comp) {
        return this.m_viewCtrlAssignment.remove(comp);
    }

    @Override
    public void clearViewControllerAssignments() {
        this.m_viewCtrlAssignment.clear();
    }

    private void _putViews(cib.cad.db.comp.Component comp) {
        Iterator<GeometryPanel> gpit = this.geometryPanelIterator();
        while (gpit.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)gpit.next();
            try {
                Class<ViewController> viewCtrlClass = this._findViewCtrlClass(comp);
                if (viewCtrlClass == null) continue;
                drawPanel.putView(comp, viewCtrlClass);
            }
            catch (IllegalAccessException e) {
                System.err.println(e.getMessage());
            }
            catch (InstantiationException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Class<ViewController> _findViewCtrlClass(cib.cad.db.comp.Component comp) {
        compCls = comp.getClass();
        viewCtrlClass = this.m_viewCtrlAssignment.get(compCls);
        if (!this.m_viewCtrlAssignment.containsKey(compCls)) ** GOTO lbl13
        return viewCtrlClass;
lbl-1000:
        // 1 sources

        {
            interfaces = compCls.getInterfaces();
            ifc = this._findInterface(interfaces);
            if (ifc != null) {
                return this.m_viewCtrlAssignment.get(ifc);
            }
            compCls = compCls.getSuperclass();
            viewCtrlClass = this.m_viewCtrlAssignment.get(compCls);
            if (!this.m_viewCtrlAssignment.containsKey(compCls)) continue;
            return viewCtrlClass;
lbl13:
            // 2 sources

            ** while (compCls != null && viewCtrlClass == null)
        }
lbl14:
        // 1 sources

        return null;
    }

    private Class<?> _findInterface(Class<?>[] interfaces) {
        int i = 0;
        while (i < interfaces.length) {
            if (this.m_viewCtrlAssignment.containsKey(interfaces[i])) {
                return interfaces[i];
            }
            ++i;
        }
        i = 0;
        while (i < interfaces.length) {
            Class<?> ifc = this._findInterface(interfaces[i].getInterfaces());
            if (ifc != null) {
                return ifc;
            }
            ++i;
        }
        return null;
    }

    private void _updateViews(cib.cad.db.comp.Component comp) {
        Iterator<GeometryPanel> gpit = this.geometryPanelIterator();
        while (gpit.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)gpit.next();
            drawPanel.updateView(comp);
        }
    }

    private void _removeViews(cib.cad.db.comp.Component comp) {
        Iterator<GeometryPanel> gpit = this.geometryPanelIterator();
        while (gpit.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)gpit.next();
            drawPanel.removeView(comp);
        }
    }

    private void _clearViews() {
        Iterator<GeometryPanel> gpit = this.geometryPanelIterator();
        while (gpit.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)gpit.next();
            drawPanel.clearViews();
        }
    }

    private void _updatePanels() {
        Iterator<GeometryPanel> gpit = this.geometryPanelIterator();
        while (gpit.hasNext()) {
            DrawPanel drawPanel = (DrawPanel)gpit.next();
            drawPanel.updatePanel();
        }
    }

    private void _loadAllViews() {
        Database db = this.m_krnl.getDatabase();
        ObservableSet<cib.cad.db.comp.Component> cmpSet = db.getComponentSet();
        Iterator it = cmpSet.iterator();
        while (it.hasNext()) {
            this._putViews((cib.cad.db.comp.Component)it.next());
        }
        this._updatePanels();
    }
}

