/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.kernel.LayeredGraphics2D;
import cib.cad.kernel.View;
import cib.cad.view.BasicViewController;
import cib.util.geo.Geo2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;

public class AxisView
implements View {
    private static final Stroke STROKE = BasicViewController.DEFAULT_STROKE;
    private int m_ctrlPntName;
    private Shape m_axis = null;
    private Paint m_paint = Color.BLACK;

    public AxisView(int ctrlPntName, int type, double[] crds, Paint paint) {
        this.setAxis(ctrlPntName, type, crds);
        this.setPaint(paint);
    }

    public Shape getAxis() {
        return this.m_axis;
    }

    public int getCtrlPntName() {
        return this.m_ctrlPntName;
    }

    public void setAxis(int ctrlPntName, int type, double[] crds) {
        switch (type) {
            case 8: {
                this.m_axis = new Line2D.Double(crds[0], crds[1], crds[2], crds[3]);
                break;
            }
            case 64: {
                Point2D.Double sp = new Point2D.Double(crds[0], crds[1]);
                Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                Point2D.Double ep = new Point2D.Double(crds[4], crds[5]);
                this.m_axis = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
                if (this.m_axis != null) break;
                this.m_axis = new Line2D.Double(crds[0], crds[1], crds[4], crds[5]);
                break;
            }
            case 16: {
                this.m_axis = new QuadCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
                break;
            }
            case 32: {
                this.m_axis = new CubicCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.m_ctrlPntName = ctrlPntName;
    }

    public void setPaint(Paint p) {
        this.m_paint = p instanceof Color && p.equals(Color.WHITE) ? Color.BLACK : p;
    }

    @Override
    public void draw(Graphics g) {
        LayeredGraphics2D lg = (LayeredGraphics2D)g;
        if (lg.setLayer("COMPONENT_CONTROLS")) {
            this._draw(g, this.m_paint);
        }
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return Geo2D.collision(this.m_axis, r, 2.0);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.m_axis.getBounds2D();
    }

    private void _draw(Graphics _g, Paint p) {
        Graphics2D g = (Graphics2D)_g;
        g.setStroke(STROKE);
        g.setPaint(p);
        g.draw(this.m_axis);
    }
}

