/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.geo.Geo2D;
import java.util.Iterator;

public class ConScale2D
extends ConObject {
    private double m_defScale = Double.NaN;
    private transient Object m_input = null;

    public ConScale2D(Kernel krnl) {
        super(krnl);
        this._init();
    }

    protected ConScale2D(ConObject con) {
        super(con);
        this._init();
    }

    private void _init() {
        this.setPrompt(Messages.getString("kernel.constr.ConScale2D.0"));
    }

    public boolean setDefault(double scale) {
        if (scale < 0.0) {
            return false;
        }
        this.m_defScale = scale;
        return true;
    }

    public double getDefault() {
        return this.m_defScale;
    }

    @Override
    public void show() {
        this.showConScaleDialog();
    }

    @Override
    public void dispose() {
        this._getUI().disposeCmdLineDialog();
    }

    @Override
    public void setDigitizeCursor(boolean on) {
        ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        conPoint.setDigitizeCursor(on);
    }

    private void showConScaleDialog() {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConScale2D-menu0");
        dlg.setPrompt(this.getPrompt());
        dlg.enableDigitize(-1);
        dlg.enableTextInput();
        if (!Double.isNaN(this.m_defScale)) {
            dlg.setDefaultText(Geo2D.formatCoordinate(this.m_defScale));
        }
        dlg.addChoice("To size");
        dlg.setChoiceHints(0, Messages.getString("kernel.constr.ConScale2D.5"));
        dlg.setChoiceChecked(0, true);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                try {
                    Number n = ConScale2D.this.m_krnl.getNumberInterpreter().getNumber(text);
                    double scale = n.doubleValue();
                    if (scale >= 0.0) {
                        ConScale2D.this.notifyScaleConstructed(scale);
                        return;
                    }
                    System.err.println(Messages.getString("kernel.constr.ConScale2D.6"));
                }
                catch (IllegalArgumentException e) {
                    System.err.println(Messages.getString("kernel.constr.ConScale2D.7"));
                }
            }

            @Override
            public void choiceSelected(int iChoice) {
                ConScale2D.this.m_input = new Integer(iChoice);
                ConScale2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                ConScale2D.this.m_krnl.pushBackArguments(new CmdLineToken[]{new DigitizeToken(x, y, gp.getId())});
                ConScale2D.this.m_input = new Integer(0);
                ConScale2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ConScale2D.this.m_input = new CmdAbortedException();
                ConScale2D.this.notifyAborted();
            }

            @Override
            public void interruptStarts(String argList) {
                ConScale2D.this.setDigitizeCursor(false);
            }

            @Override
            public void interruptEnds() {
                ConScale2D.this.setDigitizeCursor(true);
            }
        });
        this.setDigitizeCursor(true);
        this.m_input = null;
        this._getUI().showCmdLineDialog(dlg);
        this.setDigitizeCursor(false);
        if (this.m_input == null) {
            return;
        }
        if (this.m_input instanceof Integer) {
            double distActual = -1.0;
            while (true) {
                switch ((Integer)this.m_input) {
                    case 0: {
                        try {
                            distActual = Construction.getConstruction(this.m_krnl).distance2D(Messages.getString("kernel.constr.ConScale2D.9"), Double.NaN, this.m_filter);
                            break;
                        }
                        catch (CmdAbortedException e) {
                            this.notifyAborted();
                            return;
                        }
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                if (distActual > Geo2D.getEps()) break;
                System.err.println(Messages.getString("kernel.constr.ConScale2D.10"));
            }
            double distTarget = Construction.getConstruction(this.m_krnl).distance2D(Messages.getString("kernel.constr.ConScale2D.11"), Double.NaN, this.m_filter);
            this.notifyScaleConstructed(distTarget / distActual);
            return;
        }
        if (this.m_input instanceof CmdAbortedException) {
            return;
        }
        this.showConScaleDialog();
    }

    private void notifyScaleConstructed(double scale) {
        Iterator<ConObject.Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = (Listener)it.next();
            l.scaleConstructed(scale);
        }
    }

    @Override
    protected void notifyAborted() {
        super.notifyAborted();
    }

    public static class Adapter
    implements Listener {
        @Override
        public void dialogAborted() {
        }

        @Override
        public void scaleConstructed(double scale) {
        }
    }

    public static interface Listener
    extends ConObject.Listener {
        public void scaleConstructed(double var1);
    }
}

