/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.db.comp.CtrlSegments;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.MenuItemToken;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.constr.ConCircle2D;
import cib.cad.kernel.constr.ConDistance2D;
import cib.cad.kernel.constr.ConLine2D;
import cib.cad.kernel.constr.ConLineSeg2D;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConVector2D;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.AttributedShape;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.geo.Geo2D;
import cib.util.geo.NoIntersectionException;
import cib.util.geo.Vector2D;
import cib.util.view.Projection2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class ConPoint2D
extends ConObject {
    private static final String PROPERTY_REL_COORD = "RelCoord";
    private static Point2D s_lastPoint = new Point2D.Double(0.0, 0.0);
    private Point2D m_defPoint = null;
    private DigitizeObject m_digObject = null;
    private boolean m_svOrthoMode = ConLineSeg2D.isOrthogonalMode();
    private _AnnotationRenderer m_renderer = new _AnnotationRenderer();
    private int m_input = -1;
    private int m_nValues = 0;
    private double[] m_values = new double[2];

    public ConPoint2D(Kernel krnl) {
        super(krnl);
        this._init();
    }

    protected ConPoint2D(ConObject con) {
        super(con);
        this._init();
    }

    private void _init() {
        this.setPrompt(Messages.getString("kernel.constr.ConPoint2D.5"));
        this.m_svOrthoMode = ConLineSeg2D.isOrthogonalMode();
    }

    public static boolean getRelCoordFlag() {
        try {
            Kernel krnl = Kernel.getInstance();
            return 1 == Integer.parseInt(krnl.getProperty(PROPERTY_REL_COORD));
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void setRelCoordFlag(boolean flag) {
        Kernel krnl = Kernel.getInstance();
        krnl.setProperty(PROPERTY_REL_COORD, flag ? "1" : "0");
    }

    public static Point2D getRelCoord(Point2D p) {
        Point2D ret = p != null ? p : new Point2D.Double();
        ret.setLocation(ConPoint2D.getRelCoordX(), ConPoint2D.getRelCoordY());
        return ret;
    }

    public static double getRelCoordX() {
        return ConPoint2D.getRelCoordFlag() ? s_lastPoint.getX() : 0.0;
    }

    public static double getRelCoordY() {
        return ConPoint2D.getRelCoordFlag() ? s_lastPoint.getY() : 0.0;
    }

    public static void setRelCoord(Point2D p) {
        ConPoint2D.setRelCoord(p.getX(), p.getY());
    }

    public static void setRelCoord(double x, double y) {
        s_lastPoint.setLocation(x, y);
    }

    public DigitizeObject getLastDigitizeObject() {
        return this.m_digObject;
    }

    public void setDefault(Point2D pnt) {
        this.m_defPoint = pnt == null ? null : (Point2D)pnt.clone();
    }

    public Point2D getDefault() {
        return this.m_defPoint == null ? null : (Point2D)this.m_defPoint.clone();
    }

    @Override
    public void show() {
        this.m_nValues = 0;
        this.m_digObject = null;
        this.showConPointDialog();
    }

    @Override
    public void dispose() {
        this._setDigitizeCursor(false);
        this._getUI().disposeCmdLineDialog();
    }

    private void _showRelativeCoordinatesAid(boolean on) {
        if (!this._getUI().isDrawingEnabled()) {
            return;
        }
        this.m_renderer.setOrigin(ConPoint2D.getRelCoordFlag() ? s_lastPoint : new Point2D.Double());
        this.m_renderer.setDirection(Vector2D.NULL);
        Iterator<GeometryPanel> it = this._getUI().geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            if (on) {
                gp.addAnnotationRenderer(this.m_renderer);
                continue;
            }
            gp.removeAnnotationRenderer(this.m_renderer);
        }
    }

    private void _showVectorialConstructionAid(Point2D origin, Vector2D vec, boolean on) {
        if (!this._getUI().isDrawingEnabled()) {
            return;
        }
        if (on) {
            this.m_renderer.setOrigin(origin);
            this.m_renderer.setDirection(vec);
            Iterator<GeometryPanel> it = this._getUI().geometryPanelIterator();
            while (it.hasNext()) {
                it.next().addAnnotationRenderer(this.m_renderer);
            }
        } else {
            Iterator<GeometryPanel> it = this._getUI().geometryPanelIterator();
            while (it.hasNext()) {
                it.next().removeAnnotationRenderer(this.m_renderer);
            }
        }
    }

    private void _setDigitizeCursor(boolean on) {
        if (!this._getUI().isDrawingEnabled()) {
            return;
        }
        Cursor cursor = on ? Construction.getSnapCursor() : Cursor.getPredefinedCursor(0);
        this._setMicroscopeInAllWindows(on);
        Iterator<GeometryPanel> it = this._getUI().geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(cursor);
        }
    }

    private void _setMicroscopeInAllWindows(boolean on) {
        UserInterface ui = this.m_krnl.getUserInterface();
        Iterator<GeometryPanel> itgp = ui.geometryPanelIterator();
        while (itgp.hasNext()) {
            itgp.next().enableMicroscope(on);
        }
    }

    @Override
    public void setDigitizeCursor(boolean on) {
        this._setDigitizeCursor(on);
    }

    public void showRelativeCoordinatesAid(boolean on) {
        this._showRelativeCoordinatesAid(on);
    }

    private void showConPointDialog() {
        block8: while (true) {
            CmdLineDialog dlg = this._getUI().getCmdLineDialog();
            dlg.setUniqueName("kernel.constr.ConPoint2D-menu0");
            this.m_input = -1;
            dlg.setPrompt(String.valueOf(this.getPrompt()) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("kernel.constr.ConPoint2D.7") : "") + (this.m_nValues == 1 ? Messages.getString("kernel.constr.ConPoint2D.9") : ""));
            dlg.setPromptHints(Messages.getString("kernel.constr.ConPoint2D.11"));
            dlg.enableTextInput();
            if (this.m_defPoint != null) {
                if (this.m_nValues == 0) {
                    dlg.setDefaultText(String.valueOf(Geo2D.formatCoordinate(this.m_defPoint.getX())) + " " + Geo2D.formatCoordinate(this.m_defPoint.getY()));
                } else if (this.m_nValues == 1) {
                    dlg.setDefaultText(Geo2D.formatCoordinate(this.m_defPoint.getY()));
                }
            }
            dlg.enableDigitize(-1);
            dlg.addChoice("Absolute");
            dlg.setChoiceHints(0, Messages.getString("kernel.constr.ConPoint2D.12"));
            dlg.setChoiceChecked(0, !ConPoint2D.getRelCoordFlag());
            dlg.addChoice("Relative");
            dlg.setChoiceHints(1, Messages.getString("kernel.constr.ConPoint2D.14"));
            dlg.setChoiceChecked(1, ConPoint2D.getRelCoordFlag());
            dlg.addSeparator();
            dlg.addChoice("Intersect");
            dlg.setChoiceHints(2, Messages.getString("kernel.constr.ConPoint2D.16"));
            dlg.addChoice("Project");
            dlg.setChoiceHints(3, Messages.getString("kernel.constr.ConPoint2D.18"));
            dlg.addChoice("Vectorial");
            dlg.setChoiceHints(4, Messages.getString("kernel.constr.ConPoint2D.20"));
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void textEntered(String text) {
                    double crd;
                    boolean relative = ConPoint2D.getRelCoordFlag();
                    if ((text = text.trim()).startsWith("!")) {
                        relative = false;
                        text = text.substring(1);
                    } else if (text.startsWith("@")) {
                        relative = true;
                        text = text.substring(1);
                    }
                    try {
                        crd = ConPoint2D.this.m_krnl.getNumberInterpreter().getNumber(text).doubleValue();
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println(Messages.getString("kernel.constr.ConPoint2D.23"));
                        return;
                    }
                    if (relative) {
                        crd = ConPoint2D.this.m_nValues == 0 ? (crd += s_lastPoint.getX()) : (crd += s_lastPoint.getY());
                    }
                    double[] dArray = ConPoint2D.this.m_values;
                    ConPoint2D conPoint2D = ConPoint2D.this;
                    int n = conPoint2D.m_nValues;
                    conPoint2D.m_nValues = n + 1;
                    dArray[n] = crd;
                    if (ConPoint2D.this.m_nValues == 2) {
                        ConPoint2D.this.notifyPointConstructed(new Point2D.Double(ConPoint2D.this.m_values[0], ConPoint2D.this.m_values[1]));
                        return;
                    }
                    ConPoint2D.this.m_input = -1;
                    ConPoint2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void choiceSelected(int iChoice) {
                    ConPoint2D.this.m_input = iChoice;
                    ConPoint2D.this._getUI().disposeCmdLineDialog();
                }

                @Override
                public void digitized(int x, int y, GeometryPanel gp) {
                    ConPoint2D.this.m_digObject = new DigitizeObject(gp, x, y);
                    Point2D pnt = ConPoint2D.this._pointFromDigitizedInput(x, y, gp);
                    if (pnt != null) {
                        ConPoint2D.this.notifyPointConstructed(pnt);
                    }
                }

                @Override
                public void dialogAborted() {
                    ConPoint2D.this.notifyAborted();
                }

                @Override
                public void interruptStarts(String argList) {
                    ConPoint2D.this._setDigitizeCursor(false);
                    ConPoint2D.this._showRelativeCoordinatesAid(false);
                }

                @Override
                public void interruptEnds() {
                    ConPoint2D.this._setDigitizeCursor(true);
                    ConPoint2D.this._showRelativeCoordinatesAid(true);
                }
            });
            dlg.addListener(new CmdLineDialog.ContextMenuListener(){

                @Override
                public void extendContextMenu(JPopupMenu m) {
                    m.addSeparator();
                    JRadioButtonMenuItem absRB = new JRadioButtonMenuItem(Messages.getString("kernel.constr.ConPoint2D.24"));
                    JRadioButtonMenuItem relRB = new JRadioButtonMenuItem(Messages.getString("kernel.constr.ConPoint2D.25"));
                    m.add(absRB);
                    m.add(relRB);
                    absRB.setSelected(!ConPoint2D.getRelCoordFlag());
                    relRB.setSelected(ConPoint2D.getRelCoordFlag());
                    absRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            (this).ConPoint2D.this.m_krnl.addArgument(new MenuItemToken("Absolute"));
                            (this).ConPoint2D.this.m_krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    relRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            (this).ConPoint2D.this.m_krnl.addArgument(new MenuItemToken("Relative"));
                            (this).ConPoint2D.this.m_krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                }
            });
            this._setDigitizeCursor(true);
            this._showRelativeCoordinatesAid(true);
            this.m_input = -2;
            this._getUI().showCmdLineDialog(dlg);
            this._setDigitizeCursor(false);
            this._showRelativeCoordinatesAid(false);
            if (this.m_input == -2) {
                return;
            }
            switch (this.m_input) {
                case -1: {
                    if (this.m_nValues != 2) continue block8;
                    return;
                }
                case 0: {
                    ConPoint2D.setRelCoordFlag(false);
                    continue block8;
                }
                case 1: {
                    ConPoint2D.setRelCoordFlag(true);
                    continue block8;
                }
                case 2: {
                    this.showIntersectDialog();
                    return;
                }
                case 3: {
                    this.showProjectionDialog();
                    return;
                }
                case 4: {
                    Point2D.Double origin = new Point2D.Double(0.0, 0.0);
                    origin.setLocation(s_lastPoint);
                    this.showVectorialDialog(new Vector2D(1.0, 0.0), origin);
                    return;
                }
            }
            break;
        }
        throw new InternalError();
    }

    private void showIntersectDialog() {
        HashSet<Shape> shapes1 = new HashSet<Shape>();
        DigitizeObject dig1 = new DigitizeObject(null, 0, 0);
        boolean unbounded1 = this.showIntersectDialog(Messages.getString("kernel.constr.ConPoint2D.47"), shapes1, dig1);
        if (shapes1.isEmpty()) {
            return;
        }
        if (shapes1.size() > 1) {
            HashSet<Point2D> pnts = new HashSet<Point2D>();
            this.intersect(shapes1, unbounded1, shapes1, unbounded1, pnts);
            if (!pnts.isEmpty()) {
                GeometryPanel gp = dig1.getGeometryPanel();
                Point2D biasPnt = gp.ungriddedModelPoint(dig1.getX(), dig1.getY());
                Iterator it = pnts.iterator();
                Point2D iscPnt = (Point2D)it.next();
                double dist = Geo2D.distance(iscPnt, biasPnt);
                while (it.hasNext()) {
                    Point2D p = (Point2D)it.next();
                    double d = Geo2D.distance(p, biasPnt);
                    if (!(d < dist)) continue;
                    dist = d;
                    iscPnt = p;
                }
                this.notifyPointConstructed(iscPnt);
                return;
            }
        }
        HashSet<Shape> shapes2 = new HashSet<Shape>();
        boolean unbounded2 = this.showIntersectDialog(Messages.getString("kernel.constr.ConPoint2D.48"), shapes2, null);
        if (shapes2.isEmpty()) {
            return;
        }
        HashSet<Point2D> pnts = new HashSet<Point2D>();
        this.intersect(shapes1, unbounded1, shapes2, unbounded2, pnts);
        Point2D iscPnt = this.selectIntersectionPoint(pnts.iterator());
        if (iscPnt == null) {
            return;
        }
        this.notifyPointConstructed(iscPnt);
    }

    private void intersect(Set<Shape> shapes1, boolean unbounded1, Set<Shape> shapes2, boolean unbounded2, Set<Point2D> pnts) {
        for (Shape shp1 : shapes1) {
            for (Shape shp2 : shapes2) {
                if (shp1 == shp2) continue;
                try {
                    Line2D lin2;
                    PathIterator pit;
                    RectangularShape arc2;
                    Iterator<Point2D> it;
                    Ellipse2D ell2;
                    if (shp1 instanceof Line2D) {
                        Line2D lin1 = (Line2D)shp1;
                        if (shp2 instanceof Line2D) {
                            Point2D.Double pnt = new Point2D.Double();
                            Line2D lin22 = (Line2D)shp2;
                            Geo2D.intersection(lin1, unbounded1, lin22, unbounded2, pnt);
                            this.addPoint(pnt, pnts);
                            continue;
                        }
                        if (shp2 instanceof Ellipse2D) {
                            ell2 = (Ellipse2D)shp2;
                            it = Geo2D.intersection(lin1, unbounded1, ell2);
                            this.addPoints(it, pnts);
                            continue;
                        }
                        if (shp2 instanceof Arc2D) {
                            arc2 = (Arc2D)shp2;
                            it = Geo2D.intersection(lin1, unbounded1, arc2);
                            this.addPoints(it, pnts);
                            continue;
                        }
                        pit = shp2.getPathIterator(null);
                        it = Geo2D.intersection(pit, lin1, unbounded1);
                        this.addPoints(it, pnts);
                        continue;
                    }
                    if (shp1 instanceof Ellipse2D) {
                        Ellipse2D ell1 = (Ellipse2D)shp1;
                        if (shp2 instanceof Line2D) {
                            lin2 = (Line2D)shp2;
                            it = Geo2D.intersection(lin2, unbounded2, ell1);
                            this.addPoints(it, pnts);
                            continue;
                        }
                        if (shp2 instanceof Ellipse2D) {
                            arc2 = (Ellipse2D)shp2;
                            it = Geo2D.intersection(ell1, (Ellipse2D)arc2);
                            this.addPoints(it, pnts);
                            continue;
                        }
                        if (shp2 instanceof Arc2D) {
                            arc2 = (Arc2D)shp2;
                            it = Geo2D.intersection(ell1, arc2);
                            this.addPoints(it, pnts);
                            continue;
                        }
                        pit = shp2.getPathIterator(null);
                        it = Geo2D.intersection(pit, ell1);
                        this.addPoints(it, pnts);
                        continue;
                    }
                    if (shp1 instanceof Arc2D) {
                        Arc2D arc1 = (Arc2D)shp1;
                        if (shp2 instanceof Line2D) {
                            lin2 = (Line2D)shp2;
                            it = Geo2D.intersection(lin2, unbounded2, arc1);
                            this.addPoints(it, pnts);
                            continue;
                        }
                        if (shp2 instanceof Ellipse2D) {
                            ell2 = (Ellipse2D)shp2;
                            it = Geo2D.intersection(ell2, arc1);
                            this.addPoints(it, pnts);
                            continue;
                        }
                        if (shp2 instanceof Arc2D) {
                            arc2 = (Arc2D)shp2;
                            it = Geo2D.intersection(arc1, arc2);
                            this.addPoints(it, pnts);
                            continue;
                        }
                        pit = shp2.getPathIterator(null);
                        it = Geo2D.intersection(pit, arc1);
                        this.addPoints(it, pnts);
                        continue;
                    }
                    PathIterator pit1 = shp1.getPathIterator(null);
                    if (shp2 instanceof Line2D) {
                        lin2 = (Line2D)shp2;
                        it = Geo2D.intersection(pit1, lin2, unbounded2);
                        this.addPoints(it, pnts);
                        continue;
                    }
                    if (shp2 instanceof Ellipse2D) {
                        ell2 = (Ellipse2D)shp2;
                        it = Geo2D.intersection(pit1, ell2);
                        this.addPoints(it, pnts);
                        continue;
                    }
                    if (shp2 instanceof Arc2D) {
                        arc2 = (Arc2D)shp2;
                        it = Geo2D.intersection(pit1, arc2);
                        this.addPoints(it, pnts);
                        continue;
                    }
                    PathIterator pit2 = shp2.getPathIterator(null);
                    it = Geo2D.intersection(pit1, pit2);
                    this.addPoints(it, pnts);
                }
                catch (NoIntersectionException noIntersectionException) {
                    // empty catch block
                }
            }
        }
    }

    private void addPoint(Point2D pnt, Set<Point2D> pnts) {
        for (Point2D p : pnts) {
            if (!Geo2D.equality(p, pnt)) continue;
            return;
        }
        pnts.add(pnt);
    }

    private void addPoints(Iterator<Point2D> pit, Set<Point2D> pnts) {
        while (pit.hasNext()) {
            this.addPoint(pit.next(), pnts);
        }
    }

    private boolean showIntersectDialog(String prompt, final Set<Shape> shapes, final DigitizeObject dig) {
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConPoint2D-menu2");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + "> " + prompt);
        dlg.enableTextInput(false);
        dlg.enableDigitize(-1);
        dlg.addChoice("Line");
        dlg.addChoice("Circle");
        shapes.clear();
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                ConPoint2D.this.m_input = iChoice;
                ConPoint2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                if (dig != null) {
                    dig.setLocation(x, y);
                    dig.setGeometryPanel(gp);
                }
                Rectangle2D.Double pickBox = new Rectangle2D.Double(x - 5, y - 5, 10.0, 10.0);
                Iterator<cib.cad.db.comp.Component> it = gp.objectIterator(pickBox, true);
                while (it.hasNext()) {
                    cib.cad.db.comp.Component cmp = it.next();
                    if (!ConPoint2D.this._accepts(cmp, -1, -1)) continue;
                    if (cmp instanceof CtrlSegments) {
                        CtrlSegments ctrlSegs = (CtrlSegments)cmp;
                        NamedListIterator<Point2D> pit = cmp.controlPointIterator();
                        double[] crds = new double[8];
                        while (pit.hasNext()) {
                            pit.next();
                            int name = pit.previousName();
                            switch (ctrlSegs.getCtrlType(name)) {
                                case 8: {
                                    ctrlSegs.getSegmentCrds(name, crds);
                                    shapes.add(new Line2D.Double(crds[0], crds[1], crds[2], crds[3]));
                                    break;
                                }
                                case 64: {
                                    ctrlSegs.getSegmentCrds(name, crds);
                                    Arc2D arc = Geo2D.calculateArc2D(new Point2D.Double(crds[0], crds[1]), new Point2D.Double(crds[2], crds[3]), new Point2D.Double(crds[4], crds[5]), new Arc2D.Double());
                                    shapes.add(arc);
                                    break;
                                }
                                case 16: {
                                    ctrlSegs.getSegmentCrds(name, crds);
                                    shapes.add(new QuadCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]));
                                    break;
                                }
                                case 32: {
                                    ctrlSegs.getSegmentCrds(name, crds);
                                    shapes.add(new CubicCurve2D.Double(crds[0], crds[1], crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]));
                                }
                            }
                        }
                        continue;
                    }
                    NamedListIterator<AttributedShape> sit = cmp.shapeIterator();
                    while (sit.hasNext()) {
                        shapes.add((Shape)sit.next());
                    }
                }
                if (shapes.isEmpty()) {
                    System.err.println(Messages.getString("kernel.constr.ConPoint2D.53"));
                    return;
                }
                ConPoint2D.this.m_input = -1;
                ConPoint2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ConPoint2D.this.notifyAborted();
            }

            @Override
            public void interruptEnds() {
                ConPoint2D.this._setDigitizeCursor(true);
            }
        });
        this._setDigitizeCursor(true);
        this.m_input = -2;
        this._getUI().showCmdLineDialog(dlg);
        this._setDigitizeCursor(false);
        if (this.m_input == -2) {
            return false;
        }
        boolean unbounded = false;
        switch (this.m_input) {
            case -1: {
                UserInterface ui = this.m_krnl.getUserInterface();
                for (Shape shape : shapes) {
                    ui.draw(shape);
                }
                unbounded = false;
                break;
            }
            case 0: {
                final ConLine2D cl1 = new ConLine2D(this);
                cl1.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.54"));
                cl1.setFilter(this.m_filter);
                cl1.addListener(new ConLine2D.Listener(){

                    @Override
                    public void lineConstructed(Line2D l) {
                        shapes.add(l);
                        ConPoint2D.this.m_input = 0;
                        cl1.dispose();
                    }

                    @Override
                    public void dialogAborted() {
                        ConPoint2D.this.notifyAborted();
                    }
                });
                this.m_input = -2;
                cl1.show();
                if (this.m_input == -2) {
                    return false;
                }
                unbounded = true;
                break;
            }
            case 1: {
                final ConCircle2D ca1 = new ConCircle2D(this);
                ca1.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.55"));
                ca1.setFilter(this.m_filter);
                ca1.addListener(new ConCircle2D.Adapter(){

                    @Override
                    public void circleConstructed(Ellipse2D c) {
                        shapes.add(c);
                        ConPoint2D.this.m_input = 0;
                        ca1.dispose();
                    }

                    @Override
                    public void dialogAborted() {
                        ConPoint2D.this.notifyAborted();
                    }
                });
                this.m_input = -2;
                ca1.show();
                if (this.m_input == -2) {
                    return false;
                }
                unbounded = true;
                break;
            }
            default: {
                throw new InternalError(Messages.getString("kernel.constr.ConPoint2D.56"));
            }
        }
        return unbounded;
    }

    private Point2D selectIntersectionPoint(Iterator<Point2D> it) {
        if (!it.hasNext()) {
            System.err.println(Messages.getString("kernel.constr.ConPoint2D.57"));
            this.showConPointDialog();
            return null;
        }
        Point2D iscPnt = it.next();
        if (!it.hasNext()) {
            return iscPnt;
        }
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConPoint2D-menu3");
        System.out.println(Messages.getString("kernel.constr.ConPoint2D.59"));
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.60"));
        dlg.enableTextInput(false);
        dlg.enableDigitize(-1);
        final Point2D.Double bias = new Point2D.Double();
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                bias.setLocation(gp.ungriddedModelPoint(x, y));
                ConPoint2D.this.m_input = -1;
                ConPoint2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ConPoint2D.this.notifyAborted();
            }
        });
        this.m_input = -2;
        this._getUI().showCmdLineDialog(dlg);
        if (this.m_input == -2) {
            return null;
        }
        double dist = Geo2D.distance(iscPnt, bias);
        while (it.hasNext()) {
            Point2D p = it.next();
            double d = Geo2D.distance(p, bias);
            if (!(d < dist)) continue;
            dist = d;
            iscPnt = p;
        }
        return iscPnt;
    }

    private void showProjectionDialog() {
        final ConPoint2D cp = new ConPoint2D(this);
        final Point2D.Double pnt = new Point2D.Double();
        cp.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.61"));
        cp.setFilter(this.m_filter);
        cp.addListener(new Listener(){

            @Override
            public void pointConstructed(Point2D p) {
                pnt.setLocation(p);
                ConPoint2D.this.m_input = 0;
                cp.dispose();
            }

            @Override
            public void dialogAborted() {
                ConPoint2D.this.notifyAborted();
            }
        });
        this.m_input = -2;
        cp.show();
        if (this.m_input == -2) {
            return;
        }
        final ConLine2D cl = new ConLine2D(this);
        final Line2D.Double lin = new Line2D.Double();
        cl.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.62"));
        cl.setFilter(this.m_filter);
        cl.addListener(new ConLine2D.Listener(){

            @Override
            public void lineConstructed(Line2D l) {
                lin.setLine(l);
                ConPoint2D.this.m_input = 0;
                cl.dispose();
            }

            @Override
            public void dialogAborted() {
                ConPoint2D.this.notifyAborted();
            }
        });
        this.m_input = -2;
        cl.show();
        if (this.m_input == -2) {
            return;
        }
        Point2D.Double prjPnt = new Point2D.Double();
        Geo2D.projection(pnt, (Line2D)lin, prjPnt);
        this.notifyPointConstructed(prjPnt);
    }

    private void showVectorialDialog(final Vector2D curVec, Point2D curPoint) {
        ConPoint2D.setRelCoord(curPoint);
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConPoint2D-menu4");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.64"));
        dlg.enableTextInput();
        dlg.enableDigitize(-1);
        dlg.addChoice("From point");
        dlg.addSeparator();
        dlg.addChoice("To point");
        dlg.setChoiceChecked(1, true);
        dlg.addChoice("Vector");
        dlg.addChoice("Left");
        dlg.addChoice("Right");
        dlg.addChoice("Forth");
        dlg.addChoice("Back");
        dlg.addSeparator();
        dlg.addChoice("Done");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                ConPoint2D.this.m_input = 1;
                ConPoint2D.this.m_krnl.pushBackArguments(new CmdLineToken[]{new DigitizeToken(x, y, gp.getId())});
                ConPoint2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void textEntered(String text) {
                ConPoint2D.this.m_input = 2;
                ConPoint2D.this.m_krnl.pushBackArguments(new CmdLineToken[]{new TextToken(text)});
                ConPoint2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void choiceSelected(int iChoice) {
                ConPoint2D.this.m_input = iChoice;
                ConPoint2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ConPoint2D.this.notifyAborted();
            }

            @Override
            public void interruptEnds() {
                ConPoint2D.this._setDigitizeCursor(true);
            }
        });
        this.m_input = -2;
        this._setDigitizeCursor(true);
        this.m_renderer.extendPath(curPoint);
        this._showVectorialConstructionAid(curPoint, curVec, true);
        this._getUI().showCmdLineDialog(dlg);
        this._setDigitizeCursor(false);
        this._showVectorialConstructionAid(null, null, false);
        if (this.m_input == -2) {
            return;
        }
        switch (this.m_input) {
            case 0: {
                final ConPoint2D cp = new ConPoint2D(this);
                final Point2D.Double pnt = new Point2D.Double();
                cp.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.73"));
                cp.setFilter(this.m_filter);
                cp.addListener(new Listener(){

                    @Override
                    public void pointConstructed(Point2D p) {
                        pnt.setLocation(p);
                        ConPoint2D.this.m_input = 0;
                        cp.dispose();
                    }

                    @Override
                    public void dialogAborted() {
                        ConPoint2D.this.notifyAborted();
                    }
                });
                this.m_input = -2;
                cp.show();
                if (this.m_input == -2) {
                    return;
                }
                curVec.setLocation(Vector2D.X_UNIT);
                curPoint.setLocation(pnt);
                this._getUI().draw(pnt);
                s_lastPoint.setLocation(pnt);
                this.m_renderer.clearPath();
                this.showVectorialDialog(curVec, curPoint);
                return;
            }
            case 1: {
                final ConPoint2D cp = new ConPoint2D(this);
                final Point2D.Double pnt = new Point2D.Double();
                cp.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.74"));
                cp.setFilter(this.m_filter);
                cp.addListener(new Listener(){

                    @Override
                    public void pointConstructed(Point2D p) {
                        pnt.setLocation(p);
                        ConPoint2D.this.m_input = 0;
                        cp.dispose();
                    }

                    @Override
                    public void dialogAborted() {
                        ConPoint2D.this.notifyAborted();
                    }
                });
                this.m_input = -2;
                cp.show();
                if (this.m_input == -2) {
                    return;
                }
                curVec.setLocation(curPoint, pnt);
                break;
            }
            case 2: {
                final ConVector2D cv = new ConVector2D(this);
                cv.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.75"));
                cv.setFilter(this.m_filter);
                cv.addListener(new ConVector2D.Listener(){

                    @Override
                    public void vectorConstructed(Vector2D v) {
                        curVec.setLocation(v);
                        ConPoint2D.this.m_input = 0;
                        cv.dispose();
                    }

                    @Override
                    public void dialogAborted() {
                        ConPoint2D.this.notifyAborted();
                    }
                });
                this.m_input = -2;
                cv.show();
                if (this.m_input != -2) break;
                return;
            }
            case 3: {
                curVec.left();
                break;
            }
            case 4: {
                curVec.right();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                curVec.scaleBy(-1.0);
                break;
            }
            case 7: {
                this.notifyPointConstructed(curPoint);
                return;
            }
            default: {
                throw new InternalError();
            }
        }
        if (!this.showVectorLengthDialog(curVec, curPoint)) {
            return;
        }
        this._getUI().draw(curPoint);
        s_lastPoint.setLocation(curPoint);
        this.showVectorialDialog(curVec, curPoint);
    }

    private boolean showVectorLengthDialog(final Vector2D curVec, final Point2D curPoint) {
        if (Geo2D.isNull(curVec)) {
            System.err.println(Messages.getString("kernel.constr.ConPoint2D.76"));
            return true;
        }
        CmdLineDialog dlg = this._getUI().getCmdLineDialog();
        dlg.setUniqueName("kernel.constr.ConPoint2D-menu5");
        dlg.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.78"));
        dlg.enableTextInput();
        dlg.setDefaultText(Geo2D.formatCoordinate(Geo2D.length(curVec)));
        dlg.addChoice("Scale");
        dlg.addChoice("Length");
        dlg.addChoice("Project");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                ConPoint2D.this.m_input = 1;
                ConPoint2D.this.m_krnl.pushBackArguments(new CmdLineToken[]{new TextToken(text)});
                ConPoint2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void choiceSelected(int iChoice) {
                ConPoint2D.this.m_input = iChoice;
                ConPoint2D.this._getUI().disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                ConPoint2D.this.notifyAborted();
            }
        });
        this.m_input = -2;
        this._showVectorialConstructionAid(curPoint, curVec, true);
        this._getUI().showCmdLineDialog(dlg);
        this._showVectorialConstructionAid(curPoint, curVec, false);
        if (this.m_input == -2) {
            return false;
        }
        switch (this.m_input) {
            case 0: {
                try {
                    double s = this.m_krnl.readDouble(Messages.getString("kernel.constr.ConPoint2D.82"));
                    curVec.scaleBy(s);
                    curPoint.setLocation(curPoint.getX() + curVec.x, curPoint.getY() + curVec.y);
                    break;
                }
                catch (CmdAbortedException e) {
                    return false;
                }
            }
            case 1: {
                final ConDistance2D cd = new ConDistance2D(this);
                cd.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.83"));
                cd.setFilter(this.m_filter);
                cd.addListener(new ConDistance2D.Listener(){

                    @Override
                    public void distanceConstructed(double d) {
                        curVec.normalize();
                        curVec.scaleBy(d);
                        curPoint.setLocation(curPoint.getX() + curVec.x, curPoint.getY() + curVec.y);
                        ConPoint2D.this.m_input = 0;
                        cd.dispose();
                    }

                    @Override
                    public void dialogAborted() {
                        ConPoint2D.this.notifyAborted();
                    }
                });
                this.m_input = -2;
                cd.show();
                if (this.m_input != -2) break;
                return false;
            }
            case 2: {
                final ConPoint2D cp = new ConPoint2D(this);
                final Point2D.Double pnt = new Point2D.Double();
                cp.setPrompt(String.valueOf(this.getPrompt()) + Messages.getString("kernel.constr.ConPoint2D.84"));
                cp.setFilter(this.m_filter);
                cp.addListener(new Listener(){

                    @Override
                    public void pointConstructed(Point2D p) {
                        pnt.setLocation(p);
                        ConPoint2D.this.m_input = 0;
                        cp.dispose();
                    }

                    @Override
                    public void dialogAborted() {
                        ConPoint2D.this.notifyAborted();
                    }
                });
                this.m_input = -2;
                cp.show();
                if (this.m_input == -2) {
                    return false;
                }
                Line2D.Double line = new Line2D.Double(curPoint.getX(), curPoint.getY(), curPoint.getX() + curVec.getX(), curPoint.getY() + curVec.getY());
                Point2D.Double prjPnt = new Point2D.Double();
                Geo2D.projection(pnt, (Line2D)line, prjPnt);
                curVec.setLocation(curPoint, prjPnt);
                curPoint.setLocation(curPoint.getX() + curVec.getX(), curPoint.getY() + curVec.getY());
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return true;
    }

    private void notifyPointConstructed(Point2D pnt) {
        this._setDigitizeCursor(false);
        ConLineSeg2D.setOrthogonalMode(this.m_svOrthoMode);
        if (this.isDrawEnabled()) {
            this._getUI().draw(pnt);
        }
        s_lastPoint.setLocation(pnt);
        Iterator<ConObject.Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = (Listener)it.next();
            l.pointConstructed(pnt);
        }
    }

    @Override
    protected void notifyAborted() {
        this._setDigitizeCursor(false);
        ConLineSeg2D.setOrthogonalMode(this.m_svOrthoMode);
        super.notifyAborted();
    }

    private Point2D _pointFromDigitizedInput(int x, int y, GeometryPanel gp) {
        Rectangle2D.Double pickBox = new Rectangle2D.Double(x - 5, y - 5, 10.0, 10.0);
        Point2D.Double pnt = new Point2D.Double();
        Iterator<cib.cad.db.comp.Component> it = gp.objectIterator(pickBox, true);
        while (it.hasNext()) {
            cib.cad.db.comp.Component o = it.next();
            GeometryPanel.PointIterator git = gp.intersectionPointIterator(o, pickBox);
            while (git.hasNext()) {
                int ctrlPntName = git.next(pnt);
                if (!this._accepts(o, 2, ctrlPntName)) continue;
                return pnt;
            }
        }
        pnt.setLocation(gp.griddedModelPoint(x, y));
        Projection2D prj = gp.getProjection();
        AffineTransform m2v = prj.getModelToView();
        Point2D.Double vPnt = new Point2D.Double();
        m2v.transform(pnt, vPnt);
        if (pickBox.contains(vPnt)) {
            return pnt;
        }
        pnt.setLocation(gp.ungriddedModelPoint(x, y));
        return pnt;
    }

    public static class Adapter
    implements Listener {
        @Override
        public void dialogAborted() {
        }

        @Override
        public void pointConstructed(Point2D p) {
        }
    }

    public static interface Listener
    extends ConObject.Listener {
        public void pointConstructed(Point2D var1);
    }

    private static class _AnnotationRenderer
    implements GeometryPanel.AnnotationRenderer {
        private Point2D m_origin = new Point2D.Double(0.0, 0.0);
        private Vector2D m_direction = Vector2D.NULL;
        private List<Point2D> m_path = new ArrayList<Point2D>();

        private _AnnotationRenderer() {
        }

        public void setOrigin(Point2D origin) {
            this.m_origin = origin;
        }

        public void setDirection(Vector2D direction) {
            this.m_direction = direction;
        }

        public void clearPath() {
            this.m_path.clear();
        }

        public void extendPath(Point2D pnt) {
            this.m_path.add((Point2D)pnt.clone());
        }

        @Override
        public void paint(GeometryPanel p, Graphics g) {
            this._drawOrigin(p, g);
            this._drawDirection(p, g);
            this._drawPath(p, g);
        }

        private void _drawOrigin(GeometryPanel p, Graphics _g) {
            int RI = 5;
            int RO = 9;
            Point2D.Double originModel = new Point2D.Double(this.m_origin.getX(), this.m_origin.getY());
            Point2D.Double originDevice = new Point2D.Double();
            Projection2D prj = p.getProjection();
            AffineTransform modelToView = prj.getModelToView();
            modelToView.transform(originModel, originDevice);
            Color fillPaint = Kernel.getInstance().getTempGeometryFillPaint();
            Color drawPaint = Color.BLACK;
            if (p instanceof JPanel) {
                JPanel panel = (JPanel)((Object)p);
                if (((Point2D)originDevice).getX() < 0.0 || ((Point2D)originDevice).getX() > (double)panel.getWidth() || ((Point2D)originDevice).getY() < 0.0 || ((Point2D)originDevice).getY() > (double)panel.getHeight()) {
                    ((Point2D)originDevice).setLocation(20.0, panel.getHeight() - 20);
                    drawPaint = Color.LIGHT_GRAY;
                    fillPaint = fillPaint.brighter();
                }
            }
            int x = (int)((Point2D)originDevice).getX();
            int y = (int)((Point2D)originDevice).getY();
            Graphics2D g = (Graphics2D)_g;
            g.setStroke(new BasicStroke(1.0f));
            g.setPaint(fillPaint);
            g.fillOval(x - 5, y - 5, 10, 10);
            g.setPaint(drawPaint);
            g.drawOval(x - 5, y - 5, 10, 10);
            g.drawLine(x - 9, y, x + 9, y);
            g.drawLine(x, y - 9, x, y + 9);
        }

        private void _drawDirection(GeometryPanel p, Graphics _g) {
            if (Geo2D.isNull(this.m_direction)) {
                return;
            }
            int ARROW_LENGTH = 20;
            int ARROW_HEIGHT = 6;
            Projection2D prj = p.getProjection();
            AffineTransform modelToView = prj.getModelToView();
            Point2D.Double startPointDevice = new Point2D.Double();
            modelToView.transform(this.m_origin, startPointDevice);
            Point2D.Double endPoint = new Point2D.Double(this.m_origin.getX() + this.m_direction.getX(), this.m_origin.getY() + this.m_direction.getY());
            Point2D.Double endPointDevice = new Point2D.Double();
            modelToView.transform(endPoint, endPointDevice);
            Graphics2D g = (Graphics2D)_g;
            g.setStroke(new BasicStroke(1.0f));
            double l = Geo2D.distance((Point2D)startPointDevice, endPointDevice);
            double x1 = ((Point2D)startPointDevice).getX();
            double y1 = ((Point2D)startPointDevice).getY();
            double x2 = ((Point2D)endPointDevice).getX();
            double y2 = ((Point2D)endPointDevice).getY();
            Path2D.Double path = new Path2D.Double();
            ((Path2D)path).moveTo(0.0, 0.0);
            ((Path2D)path).lineTo(l - 20.0, 0.0);
            ((Path2D)path).lineTo(l - 20.0, 6.0);
            ((Path2D)path).lineTo(l, 0.0);
            ((Path2D)path).lineTo(l - 20.0, -6.0);
            ((Path2D)path).lineTo(l - 20.0, 0.0);
            double angle = Math.atan2(y2 - y1, x2 - x1);
            AffineTransform trf = AffineTransform.getTranslateInstance(x1, y1);
            trf.rotate(angle);
            Shape shp = path.createTransformedShape(trf);
            g.setPaint(Color.WHITE);
            g.fill(shp);
            g.setPaint(Kernel.getInstance().getTempGeometryFillPaint());
            g.draw(shp);
        }

        private void _drawPath(GeometryPanel p, Graphics _g) {
            Projection2D prj = p.getProjection();
            AffineTransform modelToView = prj.getModelToView();
            Path2D.Double path = new Path2D.Double();
            int i = 0;
            while (i < this.m_path.size()) {
                Point2D _pnt = this.m_path.get(i);
                Point2D pnt = modelToView.transform(_pnt, new Point2D.Double());
                if (i == 0) {
                    ((Path2D)path).moveTo(pnt.getX(), pnt.getY());
                } else {
                    ((Path2D)path).lineTo(pnt.getX(), pnt.getY());
                }
                ++i;
            }
            Graphics2D g = (Graphics2D)_g;
            BasicStroke stroke = new BasicStroke(2.0f, 2, 2, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
            g.setStroke(stroke);
            g.setPaint(Kernel.getInstance().getTempGeometryFillPaint());
            g.draw(path);
        }
    }
}

