/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.constr;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import java.awt.Component;
import java.awt.Cursor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class ConObject {
    private Set<Listener> m_listeners = new HashSet<Listener>();
    private String m_prompt = Messages.getString("kernel.constr.ConObject.0");
    protected Filter m_filter = null;
    protected Kernel m_krnl = null;
    private boolean m_draw = true;

    public ConObject(Kernel krnl) {
        this.m_krnl = krnl;
    }

    protected ConObject(ConObject con) {
        this.m_krnl = con.m_krnl;
        this.m_filter = con.m_filter;
    }

    public abstract void show();

    public abstract void dispose();

    public void setPrompt(String prompt) {
        this.m_prompt = prompt;
    }

    public String getPrompt() {
        return this.m_prompt;
    }

    public void setDigitizeCursor(boolean on) {
    }

    public void setDrawEnabled(boolean enable) {
        this.m_draw = enable;
    }

    public boolean isDrawEnabled() {
        return this.m_draw;
    }

    public boolean addListener(Listener l) {
        return this.m_listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this.m_listeners.remove(l);
    }

    public void clearListeners() {
        this.m_listeners.clear();
    }

    public Iterator<Listener> listenerIterator() {
        return this.m_listeners.iterator();
    }

    protected void notifyAborted() {
        Iterator<Listener> it = this.listenerIterator();
        while (it.hasNext()) {
            Listener l = it.next();
            l.dialogAborted();
        }
    }

    public void setFilter(Filter f) {
        this.m_filter = f;
    }

    protected UserInterface _getUI() {
        return this.m_krnl.getUserInterface();
    }

    protected void _setPickCursor(boolean on) {
        Iterator<GeometryPanel> itgp;
        UserInterface ui;
        Cursor cursor;
        if (on) {
            cursor = Construction.getPickNearCursor();
            ui = this.m_krnl.getUserInterface();
            itgp = ui.geometryPanelIterator();
            while (itgp.hasNext()) {
                itgp.next().enableMicroscope(true);
            }
        } else {
            cursor = Cursor.getPredefinedCursor(0);
            ui = this.m_krnl.getUserInterface();
            itgp = ui.geometryPanelIterator();
            while (itgp.hasNext()) {
                itgp.next().enableMicroscope(false);
            }
        }
        Iterator<GeometryPanel> it = this._getUI().geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(cursor);
        }
    }

    protected boolean _accepts(cib.cad.db.comp.Component comp, int chain, int prmName) {
        return this.m_filter == null ? true : this.m_filter.accept(comp, chain, prmName);
    }

    public static interface Filter {
        public boolean accept(cib.cad.db.comp.Component var1, int var2, int var3);
    }

    public static interface Listener {
        public void dialogAborted();
    }
}

