/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds.util;

import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.util.geo.Geo2D;
import cib.util.view.Projection2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

public class WindowRubberBand
implements GeometryPanel.RubberbandListener {
    private UserInterface m_ui = null;
    private Point2D m_p1 = new Point2D.Double();
    private Point2D m_p2 = new Point2D.Double();
    private Rectangle2D m_rectangle = new Rectangle2D.Double();
    private Map<JPanel, Graphics2D> m_panelToGfx = new HashMap<JPanel, Graphics2D>();

    public WindowRubberBand(Kernel krnl, DigitizeObject d) {
        this.m_ui = krnl.getUserInterface();
        Point2D.Double pin = new Point2D.Double();
        GeometryPanel gp = d.getGeometryPanel();
        Projection2D prj2D = gp.getProjection();
        ((Point2D)pin).setLocation(d.getX(), d.getY());
        prj2D.getViewToModel().transform(pin, this.m_p1);
        this.m_p2.setLocation(this.m_p1);
        this.m_rectangle.setFrameFromDiagonal(this.m_p1, this.m_p2);
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Graphics2D gfx = (Graphics2D)panel.getGraphics();
            gfx.setColor(panel.getForeground());
            gfx.setXORMode(panel.getBackground());
            this.m_panelToGfx.put(panel, gfx);
            gp.addListener(this);
        }
    }

    public void close() {
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            gp.removeListener(this);
            JPanel panel = (JPanel)((Object)gp);
            Graphics gfx = this.m_panelToGfx.get(panel);
            gfx.dispose();
        }
    }

    @Override
    public void reset() {
        this.m_rectangle.setFrameFromDiagonal(this.m_p1, this.m_p1);
    }

    @Override
    public void paintStarts() {
        this._draw();
        this.m_rectangle.setFrameFromDiagonal(this.m_p1, this.m_p1);
    }

    @Override
    public void paintEnds() {
        this.m_rectangle.setFrameFromDiagonal(this.m_p1, this.m_p1);
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Point p = panel.getMousePosition();
            if (p == null) continue;
            Point2D.Double pin = new Point2D.Double();
            Projection2D prj2D = gp.getProjection();
            ((Point2D)pin).setLocation(((Point2D)p).getX(), ((Point2D)p).getY());
            prj2D.getViewToModel().transform(pin, this.m_p2);
            this.m_rectangle.setFrameFromDiagonal(this.m_p1, this.m_p2);
            break;
        }
        this._draw();
    }

    private void _draw() {
        if (this.m_rectangle.getWidth() < Geo2D.getEps() && this.m_rectangle.getHeight() < Geo2D.getEps()) {
            return;
        }
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel panel = it.next();
            Graphics2D gfx = this.m_panelToGfx.get(panel);
            gfx.setColor(((JPanel)((Object)panel)).getForeground());
            Projection2D prj2D = panel.getProjection();
            AffineTransform m2v = prj2D.getModelToView();
            gfx.draw(m2v.createTransformedShape(this.m_rectangle));
        }
    }
}

