/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds.util;

import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.IteratorFilter;

public class SelectFilter {
    private static final String ACCEPT_VISIBLE = "SelectFilter.acceptVisible";
    private static final String ACCEPT_INVISIBLE = "SelectFilter.acceptInvisible";
    private Kernel m_krnl = Kernel.getInstance();
    private boolean m_acceptVisible;
    private boolean m_acceptInvisible;
    private int m_action = -1;

    public SelectFilter() {
        this._loadFilter();
    }

    private void _loadFilter() {
        this.m_acceptVisible = this.m_krnl.getProperty(ACCEPT_VISIBLE, "true").equals("true");
        this.m_acceptInvisible = this.m_krnl.getProperty(ACCEPT_INVISIBLE, "false").equals("true");
    }

    private void _resetFilter() {
        this.m_acceptVisible = true;
        this.m_acceptInvisible = false;
    }

    private void _saveFilter() {
        this.m_krnl.setProperty(ACCEPT_VISIBLE, String.valueOf(this.m_acceptVisible));
        this.m_krnl.setProperty(ACCEPT_INVISIBLE, String.valueOf(this.m_acceptInvisible));
    }

    public IteratorFilter<Component> showDialog() throws CmdAbortedException {
        Kernel krnl = Kernel.getInstance();
        final UserInterface ui = krnl.getUserInterface();
        do {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("kernel.cmds.util.SelectFilter-menu0");
            dlg.setPrompt(Messages.getString("kernel.cmds.util.SelectFilter.7"));
            int iChoice = dlg.addChoice("Visible");
            if (this.m_acceptVisible) {
                dlg.setChoiceChecked(iChoice);
            }
            iChoice = dlg.addChoice("Invisible");
            if (this.m_acceptInvisible) {
                dlg.setChoiceChecked(iChoice);
            }
            dlg.addSeparator();
            dlg.addChoice("Reset");
            iChoice = dlg.addChoice("Done");
            if (!this.m_acceptVisible && !this.m_acceptInvisible) {
                dlg.setChoiceEnabled(iChoice, false);
            }
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    SelectFilter.this.m_action = iChoice;
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    SelectFilter.this.m_action = -1;
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            if (this.m_action == 0) {
                this.m_acceptVisible = !this.m_acceptVisible;
                continue;
            }
            if (this.m_action == 1) {
                this.m_acceptInvisible = !this.m_acceptInvisible;
                continue;
            }
            if (this.m_action == 2) {
                this._resetFilter();
                continue;
            }
            if (this.m_action != -1) continue;
            throw new CmdAbortedException();
        } while (this.m_action != 3);
        this._saveFilter();
        return new IteratorFilter<Component>(){
            private AttributeManager m_atm = AttributeManager.getAttributeManager();

            @Override
            public boolean matches(Component c) {
                if (c == null) {
                    return false;
                }
                Attributes attr = c.getAttributes();
                boolean isVisible = this.m_atm.getVisibility(attr.getVisibility());
                if (isVisible && SelectFilter.this.m_acceptVisible) {
                    return true;
                }
                return !isVisible && SelectFilter.this.m_acceptInvisible;
            }
        };
    }
}

