/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds.util;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import cib.util.view.Projection2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

public class RelativeAngleRubberBand
implements GeometryPanel.RubberbandListener {
    private UserInterface m_ui = null;
    private Point2D m_apex = new Point2D.Double();
    private double m_startAngle = 0.0;
    private double m_sweepAngle = Double.NaN;
    private double m_signumSweepAngle = 1.0;
    private Shape m_shape = null;
    private Line2D m_radialLineStart = new Line2D.Double();
    private Line2D m_radialLineEnd = new Line2D.Double();
    private double m_lastAngle = 1.0;
    private Map<JPanel, Graphics2D> m_panelToGfx = new HashMap<JPanel, Graphics2D>();

    public RelativeAngleRubberBand(Kernel krnl, Point2D apex) {
        this.m_ui = krnl.getUserInterface();
        this.m_apex.setLocation(apex);
        this.m_radialLineStart.setLine(apex, apex);
        this.m_radialLineEnd.setLine(apex, apex);
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Graphics2D gfx = (Graphics2D)panel.getGraphics();
            gfx.setXORMode(panel.getBackground());
            gfx.setColor(panel.getForeground());
            this.m_panelToGfx.put(panel, gfx);
            gp.addListener(this);
        }
    }

    @Override
    public void reset() {
        this.m_shape = null;
    }

    @Override
    public void paintStarts() {
        this._draw();
        this.m_shape = null;
    }

    @Override
    public void paintEnds() {
        this.m_shape = null;
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Point p = panel.getMousePosition();
            if (p == null) continue;
            Point2D.Double pin = new Point2D.Double();
            Point2D.Double pout = new Point2D.Double();
            Projection2D prj2D = gp.getProjection();
            ((Point2D)pin).setLocation(((Point2D)p).getX(), ((Point2D)p).getY());
            prj2D.getViewToModel().transform(pin, pout);
            if (Double.isNaN(this.m_sweepAngle)) {
                Vector2D vp = new Vector2D(this.m_apex, pout);
                this.m_startAngle = Geo2D.isNull(vp) ? 0.0 : Vector2D.X_UNIT.getAngleCCW(vp);
                this.m_radialLineStart.setLine(this.m_apex, pout);
            } else {
                double angleCCW;
                Vector2D vsp = new Vector2D(this.m_startAngle);
                Vector2D vp = new Vector2D(this.m_apex, pout);
                double d = angleCCW = Geo2D.isNull(vp) ? 0.0 : vsp.getAngleCCW(vp);
                if (angleCCW > 0.0 && angleCCW < 1.5707963267948966 && this.m_lastAngle > 4.71238898038469 && this.m_lastAngle < Math.PI * 2) {
                    this.m_signumSweepAngle = 1.0;
                } else if (this.m_lastAngle > 0.0 && this.m_lastAngle < 1.5707963267948966 && angleCCW > 4.71238898038469 && angleCCW < Math.PI * 2) {
                    this.m_signumSweepAngle = -1.0;
                }
                this.m_lastAngle = angleCCW;
                this.m_sweepAngle = this.m_signumSweepAngle > 0.0 ? angleCCW : angleCCW - Math.PI * 2;
                this.m_radialLineEnd.setLine(this.m_apex, pout);
            }
            this.m_shape = this._getShape();
            break;
        }
        this._draw();
    }

    public void close() {
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            gp.removeListener(this);
            JPanel panel = (JPanel)((Object)gp);
            Graphics gfx = this.m_panelToGfx.get(panel);
            gfx.dispose();
        }
    }

    public void setStartAnglePoint(Point2D p) {
        this.m_sweepAngle = 0.0;
        try {
            Vector2D v1 = new Vector2D(this.m_apex, p);
            this.m_startAngle = Vector2D.X_UNIT.getAngleCCW(v1);
            this.m_radialLineStart.setLine(this.m_apex, p);
        }
        catch (NullVectorException e) {
            this.m_startAngle = 0.0;
        }
    }

    public double relativeAngleFromPoint(Point2D ep) {
        Vector2D vsp = new Vector2D(this.m_startAngle);
        Vector2D vp = new Vector2D(this.m_apex, ep);
        double angleCCW = vsp.getAngleCCW(vp);
        return this.m_signumSweepAngle > 0.0 ? angleCCW : angleCCW - Math.PI * 2;
    }

    private Shape _getShape() {
        if (Double.isNaN(this.m_sweepAngle)) {
            return new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        double scale = Math.min(Geo2D.length(this.m_radialLineStart), Geo2D.length(this.m_radialLineEnd));
        Vector2D vsp = new Vector2D(this.m_startAngle);
        vsp.scaleBy(scale);
        vsp.add(this.m_apex);
        Vector2D vcp = new Vector2D(this.m_startAngle + 0.5 * this.m_sweepAngle);
        vcp.scaleBy(scale);
        vcp.add(this.m_apex);
        Vector2D vep = new Vector2D(this.m_startAngle + this.m_sweepAngle);
        vep.scaleBy(scale);
        vep.add(this.m_apex);
        return Geo2D.calculateArc2D(vsp, vcp, vep, new Arc2D.Double());
    }

    private void _draw() {
        if (this.m_shape != null) {
            Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
            while (it.hasNext()) {
                GeometryPanel panel = it.next();
                Graphics2D gfx = this.m_panelToGfx.get(panel);
                if (gfx == null) {
                    throw new InternalError("ArcAngleRubberBand: gfx == null");
                }
                Projection2D prj2D = panel.getProjection();
                AffineTransform m2v = prj2D.getModelToView();
                gfx.draw(m2v.createTransformedShape(this.m_shape));
                gfx.draw(m2v.createTransformedShape(this.m_radialLineStart));
                gfx.draw(m2v.createTransformedShape(this.m_radialLineEnd));
            }
        }
    }
}

