/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds.util;

import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.util.geo.Geo2D;
import cib.util.view.Projection2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

public class LineRubberBand
implements GeometryPanel.RubberbandListener {
    private UserInterface m_ui = null;
    private Line2D m_line = new Line2D.Double();
    private Map<JPanel, Graphics2D> m_panelToGfx = new HashMap<JPanel, Graphics2D>();
    private boolean m_orthogonalMode = false;

    public LineRubberBand(Kernel krnl, Point2D pnt) {
        this.m_ui = krnl.getUserInterface();
        this.m_line.setLine(pnt, pnt);
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Graphics2D gfx = (Graphics2D)panel.getGraphics();
            gfx.setXORMode(panel.getBackground());
            gfx.setColor(panel.getForeground());
            this.m_panelToGfx.put(panel, gfx);
            gp.addListener(this);
        }
    }

    public void setOrthogonalMode(boolean on) {
        this.reset();
        this.m_orthogonalMode = on;
    }

    public boolean getOrthogonalMode() {
        return this.m_orthogonalMode;
    }

    @Override
    public void reset() {
        this.m_line.setLine(this.m_line.getP1(), this.m_line.getP1());
    }

    @Override
    public void paintStarts() {
        this._draw();
        this.m_line.setLine(this.m_line.getX1(), this.m_line.getY1(), this.m_line.getX1(), this.m_line.getY1());
    }

    @Override
    public void paintEnds() {
        this.m_line.setLine(this.m_line.getX1(), this.m_line.getY1(), this.m_line.getX1(), this.m_line.getY1());
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            JPanel panel = (JPanel)((Object)gp);
            Point p = panel.getMousePosition();
            if (p == null) continue;
            Point2D.Double pin = new Point2D.Double();
            Point2D.Double pout = new Point2D.Double();
            Projection2D prj2D = gp.getProjection();
            ((Point2D)pin).setLocation(((Point2D)p).getX(), ((Point2D)p).getY());
            prj2D.getViewToModel().transform(pin, pout);
            if (this.m_orthogonalMode) {
                double dy;
                double dx = Math.abs(((Point2D)pout).getX() - this.m_line.getX1());
                if (dx < (dy = Math.abs(((Point2D)pout).getY() - this.m_line.getY1()))) {
                    ((Point2D)pout).setLocation(this.m_line.getX1(), ((Point2D)pout).getY());
                } else {
                    ((Point2D)pout).setLocation(((Point2D)pout).getX(), this.m_line.getY1());
                }
            }
            this.m_line.setLine(this.m_line.getX1(), this.m_line.getY1(), ((Point2D)pout).getX(), ((Point2D)pout).getY());
            break;
        }
        this._draw();
    }

    public void close() {
        Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
        while (it.hasNext()) {
            GeometryPanel gp = it.next();
            gp.removeListener(this);
            JPanel panel = (JPanel)((Object)gp);
            Graphics gfx = this.m_panelToGfx.get(panel);
            gfx.dispose();
        }
    }

    private void _draw() {
        if (Geo2D.length(this.m_line) >= Geo2D.getEps()) {
            Iterator<GeometryPanel> it = this.m_ui.geometryPanelIterator();
            while (it.hasNext()) {
                GeometryPanel panel = it.next();
                Graphics2D gfx = this.m_panelToGfx.get(panel);
                if (gfx == null) {
                    throw new InternalError("LineRubberBand: gfx == null");
                }
                Projection2D prj2D = panel.getProjection();
                AffineTransform m2v = prj2D.getModelToView();
                if (!this._mustClip()) {
                    gfx.draw(m2v.createTransformedShape(this.m_line));
                    continue;
                }
                Point2D.Double scrPoint1 = new Point2D.Double();
                m2v.transform(this.m_line.getP1(), scrPoint1);
                Point2D.Double scrPoint2 = new Point2D.Double();
                m2v.transform(this.m_line.getP2(), scrPoint2);
                Line2D.Double scrLine = new Line2D.Double(scrPoint1, scrPoint2);
                if (Geo2D.clip(((JPanel)((Object)panel)).getVisibleRect(), scrLine) == 0) continue;
                gfx.draw(scrLine);
            }
        }
    }

    private boolean _mustClip() {
        return false;
    }
}

